/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.numberpicker;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.numberpicker.NumberPicker;
import java.util.Vector;

public class NumberPickerDialogFragment
extends DialogFragment {
    private static final String REFERENCE_KEY = "NumberPickerDialogFragment_ReferenceKey";
    private static final String THEME_RES_ID_KEY = "NumberPickerDialogFragment_ThemeResIdKey";
    private static final String MIN_NUMBER_KEY = "NumberPickerDialogFragment_MinNumberKey";
    private static final String MAX_NUMBER_KEY = "NumberPickerDialogFragment_MaxNumberKey";
    private static final String PLUS_MINUS_VISIBILITY_KEY = "NumberPickerDialogFragment_PlusMinusVisibilityKey";
    private static final String DECIMAL_VISIBILITY_KEY = "NumberPickerDialogFragment_DecimalVisibilityKey";
    private static final String LABEL_TEXT_KEY = "NumberPickerDialogFragment_LabelTextKey";
    private static final String CURRENT_NUMBER_KEY = "NumberPickerDialogFragment_CurrentNumberKey";
    private static final String CURRENT_DECIMAL_KEY = "NumberPickerDialogFragment_CurrentDecimalKey";
    private static final String CURRENT_SIGN_KEY = "NumberPickerDialogFragment_CurrentSignKey";
    private Button mSet;
    private Button mCancel;
    private NumberPicker mPicker;
    private View mDividerOne;
    private View mDividerTwo;
    private int mReference = -1;
    private int mTheme = -1;
    private int mDividerColor;
    private ColorStateList mTextColor;
    private String mLabelText = "";
    private int mButtonBackgroundResId;
    private int mDialogBackgroundResId;
    private Integer mMinNumber = null;
    private Integer mMaxNumber = null;
    private Integer mCurrentNumber = null;
    private Double mCurrentDecimal = null;
    private Integer mCurrentSign = null;
    private int mPlusMinusVisibility = 0;
    private int mDecimalVisibility = 0;
    private Vector<NumberPickerDialogHandler> mNumberPickerDialogHandlers = new Vector();

    public static NumberPickerDialogFragment newInstance(int reference, int themeResId, Integer minNumber, Integer maxNumber, Integer plusMinusVisibility, Integer decimalVisibility, String labelText, Integer currentNumberValue, Double currentDecimalValue, Integer currentNumberSign) {
        NumberPickerDialogFragment frag = new NumberPickerDialogFragment();
        Bundle args = new Bundle();
        args.putInt(REFERENCE_KEY, reference);
        args.putInt(THEME_RES_ID_KEY, themeResId);
        if (minNumber != null) {
            args.putInt(MIN_NUMBER_KEY, minNumber.intValue());
        }
        if (maxNumber != null) {
            args.putInt(MAX_NUMBER_KEY, maxNumber.intValue());
        }
        if (plusMinusVisibility != null) {
            args.putInt(PLUS_MINUS_VISIBILITY_KEY, plusMinusVisibility.intValue());
        }
        if (decimalVisibility != null) {
            args.putInt(DECIMAL_VISIBILITY_KEY, decimalVisibility.intValue());
        }
        if (labelText != null) {
            args.putString(LABEL_TEXT_KEY, labelText);
        }
        if (currentNumberValue != null) {
            args.putInt(CURRENT_NUMBER_KEY, currentNumberValue.intValue());
        }
        if (currentDecimalValue != null) {
            args.putDouble(CURRENT_DECIMAL_KEY, currentDecimalValue.doubleValue());
        }
        if (currentNumberSign != null) {
            args.putInt(CURRENT_SIGN_KEY, currentNumberSign.intValue());
        }
        frag.setArguments(args);
        return frag;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null && args.containsKey(REFERENCE_KEY)) {
            this.mReference = args.getInt(REFERENCE_KEY);
        }
        if (args != null && args.containsKey(THEME_RES_ID_KEY)) {
            this.mTheme = args.getInt(THEME_RES_ID_KEY);
        }
        if (args != null && args.containsKey(PLUS_MINUS_VISIBILITY_KEY)) {
            this.mPlusMinusVisibility = args.getInt(PLUS_MINUS_VISIBILITY_KEY);
        }
        if (args != null && args.containsKey(DECIMAL_VISIBILITY_KEY)) {
            this.mDecimalVisibility = args.getInt(DECIMAL_VISIBILITY_KEY);
        }
        if (args != null && args.containsKey(MIN_NUMBER_KEY)) {
            this.mMinNumber = args.getInt(MIN_NUMBER_KEY);
        }
        if (args != null && args.containsKey(MAX_NUMBER_KEY)) {
            this.mMaxNumber = args.getInt(MAX_NUMBER_KEY);
        }
        if (args != null && args.containsKey(LABEL_TEXT_KEY)) {
            this.mLabelText = args.getString(LABEL_TEXT_KEY);
        }
        if (args != null && args.containsKey(CURRENT_NUMBER_KEY)) {
            this.mCurrentNumber = args.getInt(CURRENT_NUMBER_KEY);
        }
        if (args != null && args.containsKey(CURRENT_DECIMAL_KEY)) {
            this.mCurrentDecimal = args.getDouble(CURRENT_DECIMAL_KEY);
        }
        if (args != null && args.containsKey(CURRENT_SIGN_KEY)) {
            this.mCurrentSign = args.getInt(CURRENT_SIGN_KEY);
        }
        this.setStyle(1, 0);
        this.mTextColor = this.getResources().getColorStateList(R.color.dialog_text_color_holo_dark);
        this.mButtonBackgroundResId = R.drawable.button_background_dark;
        this.mDividerColor = this.getResources().getColor(R.color.default_divider_color_dark);
        this.mDialogBackgroundResId = R.drawable.dialog_full_holo_dark;
        if (this.mTheme != -1) {
            TypedArray a = this.getActivity().getApplicationContext().obtainStyledAttributes(this.mTheme, R.styleable.BetterPickersDialogFragment);
            this.mTextColor = a.getColorStateList(R.styleable.BetterPickersDialogFragment_bpTextColor);
            this.mButtonBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpButtonBackground, this.mButtonBackgroundResId);
            this.mDividerColor = a.getColor(R.styleable.BetterPickersDialogFragment_bpDividerColor, this.mDividerColor);
            this.mDialogBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpDialogBackground, this.mDialogBackgroundResId);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.number_picker_dialog, null);
        this.mSet = (Button)v.findViewById(R.id.set_button);
        this.mCancel = (Button)v.findViewById(R.id.cancel_button);
        this.mCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                NumberPickerDialogFragment.this.dismiss();
            }
        });
        this.mPicker = (NumberPicker)v.findViewById(R.id.number_picker);
        this.mPicker.setSetButton(this.mSet);
        this.mSet.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                double number = NumberPickerDialogFragment.this.mPicker.getEnteredNumber();
                if (NumberPickerDialogFragment.this.mMinNumber != null && NumberPickerDialogFragment.this.mMaxNumber != null && (number < (double)NumberPickerDialogFragment.this.mMinNumber.intValue() || number > (double)NumberPickerDialogFragment.this.mMaxNumber.intValue())) {
                    String errorText = String.format(NumberPickerDialogFragment.this.getString(R.string.min_max_error), NumberPickerDialogFragment.this.mMinNumber, NumberPickerDialogFragment.this.mMaxNumber);
                    NumberPickerDialogFragment.this.mPicker.getErrorView().setText(errorText);
                    NumberPickerDialogFragment.this.mPicker.getErrorView().show();
                    return;
                }
                if (NumberPickerDialogFragment.this.mMinNumber != null && number < (double)NumberPickerDialogFragment.this.mMinNumber.intValue()) {
                    String errorText = String.format(NumberPickerDialogFragment.this.getString(R.string.min_error), NumberPickerDialogFragment.this.mMinNumber);
                    NumberPickerDialogFragment.this.mPicker.getErrorView().setText(errorText);
                    NumberPickerDialogFragment.this.mPicker.getErrorView().show();
                    return;
                }
                if (NumberPickerDialogFragment.this.mMaxNumber != null && number > (double)NumberPickerDialogFragment.this.mMaxNumber.intValue()) {
                    String errorText = String.format(NumberPickerDialogFragment.this.getString(R.string.max_error), NumberPickerDialogFragment.this.mMaxNumber);
                    NumberPickerDialogFragment.this.mPicker.getErrorView().setText(errorText);
                    NumberPickerDialogFragment.this.mPicker.getErrorView().show();
                    return;
                }
                for (NumberPickerDialogHandler handler : NumberPickerDialogFragment.this.mNumberPickerDialogHandlers) {
                    handler.onDialogNumberSet(NumberPickerDialogFragment.this.mReference, NumberPickerDialogFragment.this.mPicker.getNumber(), NumberPickerDialogFragment.this.mPicker.getDecimal(), NumberPickerDialogFragment.this.mPicker.getIsNegative(), number);
                }
                FragmentActivity activity = NumberPickerDialogFragment.this.getActivity();
                Fragment fragment = NumberPickerDialogFragment.this.getTargetFragment();
                if (activity instanceof NumberPickerDialogHandler) {
                    NumberPickerDialogHandler act = (NumberPickerDialogHandler)activity;
                    act.onDialogNumberSet(NumberPickerDialogFragment.this.mReference, NumberPickerDialogFragment.this.mPicker.getNumber(), NumberPickerDialogFragment.this.mPicker.getDecimal(), NumberPickerDialogFragment.this.mPicker.getIsNegative(), number);
                } else if (fragment instanceof NumberPickerDialogHandler) {
                    NumberPickerDialogHandler frag = (NumberPickerDialogHandler)fragment;
                    frag.onDialogNumberSet(NumberPickerDialogFragment.this.mReference, NumberPickerDialogFragment.this.mPicker.getNumber(), NumberPickerDialogFragment.this.mPicker.getDecimal(), NumberPickerDialogFragment.this.mPicker.getIsNegative(), number);
                }
                NumberPickerDialogFragment.this.dismiss();
            }
        });
        this.mDividerOne = v.findViewById(R.id.divider_1);
        this.mDividerTwo = v.findViewById(R.id.divider_2);
        this.mDividerOne.setBackgroundColor(this.mDividerColor);
        this.mDividerTwo.setBackgroundColor(this.mDividerColor);
        this.mSet.setTextColor(this.mTextColor);
        this.mSet.setBackgroundResource(this.mButtonBackgroundResId);
        this.mCancel.setTextColor(this.mTextColor);
        this.mCancel.setBackgroundResource(this.mButtonBackgroundResId);
        this.mPicker.setTheme(this.mTheme);
        this.getDialog().getWindow().setBackgroundDrawableResource(this.mDialogBackgroundResId);
        this.mPicker.setDecimalVisibility(this.mDecimalVisibility);
        this.mPicker.setPlusMinusVisibility(this.mPlusMinusVisibility);
        this.mPicker.setLabelText(this.mLabelText);
        if (this.mMinNumber != null) {
            this.mPicker.setMin(this.mMinNumber);
        }
        if (this.mMaxNumber != null) {
            this.mPicker.setMax(this.mMaxNumber);
        }
        this.mPicker.setNumber(this.mCurrentNumber, this.mCurrentDecimal, this.mCurrentSign);
        return v;
    }

    public void setNumberPickerDialogHandlers(Vector<NumberPickerDialogHandler> handlers) {
        this.mNumberPickerDialogHandlers = handlers;
    }

    public static interface NumberPickerDialogHandler {
        public void onDialogNumberSet(int var1, int var2, double var3, boolean var5, double var6);
    }
}

