/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.numberpicker;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.widget.ZeroTopPaddingTextView;

public class NumberView
extends LinearLayout {
    private ZeroTopPaddingTextView mNumber;
    private ZeroTopPaddingTextView mDecimal;
    private ZeroTopPaddingTextView mDecimalSeperator;
    private ZeroTopPaddingTextView mMinusLabel;
    private final Typeface mAndroidClockMonoThin;
    private Typeface mOriginalNumberTypeface;
    private ColorStateList mTextColor;

    public NumberView(Context context) {
        this(context, null);
    }

    public NumberView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mAndroidClockMonoThin = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/AndroidClockMono-Thin.ttf");
        this.mTextColor = this.getResources().getColorStateList(R.color.dialog_text_color_holo_dark);
    }

    public void setTheme(int themeResId) {
        if (themeResId != -1) {
            TypedArray a = this.getContext().obtainStyledAttributes(themeResId, R.styleable.BetterPickersDialogFragment);
            this.mTextColor = a.getColorStateList(R.styleable.BetterPickersDialogFragment_bpTextColor);
        }
        this.restyleViews();
    }

    private void restyleViews() {
        if (this.mNumber != null) {
            this.mNumber.setTextColor(this.mTextColor);
        }
        if (this.mDecimal != null) {
            this.mDecimal.setTextColor(this.mTextColor);
        }
        if (this.mDecimalSeperator != null) {
            this.mDecimalSeperator.setTextColor(this.mTextColor);
        }
        if (this.mMinusLabel != null) {
            this.mMinusLabel.setTextColor(this.mTextColor);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mNumber = (ZeroTopPaddingTextView)this.findViewById(R.id.number);
        this.mDecimal = (ZeroTopPaddingTextView)this.findViewById(R.id.decimal);
        this.mDecimalSeperator = (ZeroTopPaddingTextView)this.findViewById(R.id.decimal_separator);
        this.mMinusLabel = (ZeroTopPaddingTextView)this.findViewById(R.id.minus_label);
        if (this.mNumber != null) {
            this.mOriginalNumberTypeface = this.mNumber.getTypeface();
        }
        if (this.mNumber != null) {
            this.mNumber.setTypeface(this.mAndroidClockMonoThin);
            this.mNumber.updatePadding();
        }
        if (this.mDecimal != null) {
            this.mDecimal.setTypeface(this.mAndroidClockMonoThin);
            this.mDecimal.updatePadding();
        }
        this.restyleViews();
    }

    public void setNumber(String numbersDigit, String decimalDigit, boolean showDecimal, boolean isNegative) {
        this.mMinusLabel.setVisibility(isNegative ? 0 : 8);
        if (this.mNumber != null) {
            if (numbersDigit.equals("")) {
                this.mNumber.setText("-");
                this.mNumber.setTypeface(this.mAndroidClockMonoThin);
                this.mNumber.setEnabled(false);
                this.mNumber.updatePadding();
                this.mNumber.setVisibility(0);
            } else if (showDecimal) {
                this.mNumber.setText(numbersDigit);
                this.mNumber.setTypeface(this.mOriginalNumberTypeface);
                this.mNumber.setEnabled(true);
                this.mNumber.updatePaddingForBoldDate();
                this.mNumber.setVisibility(0);
            } else {
                this.mNumber.setText(numbersDigit);
                this.mNumber.setTypeface(this.mAndroidClockMonoThin);
                this.mNumber.setEnabled(true);
                this.mNumber.updatePadding();
                this.mNumber.setVisibility(0);
            }
        }
        if (this.mDecimal != null) {
            if (decimalDigit.equals("")) {
                this.mDecimal.setVisibility(8);
            } else {
                this.mDecimal.setText(decimalDigit);
                this.mDecimal.setTypeface(this.mAndroidClockMonoThin);
                this.mDecimal.setEnabled(true);
                this.mDecimal.updatePadding();
                this.mDecimal.setVisibility(0);
            }
        }
        if (this.mDecimalSeperator != null) {
            this.mDecimalSeperator.setVisibility(showDecimal ? 0 : 8);
        }
    }
}

