/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.recurrencepicker;

import android.content.Context;
import android.content.res.Resources;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.TimeFormatException;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.recurrencepicker.EventRecurrence;

public class EventRecurrenceFormatter {
    private static int[] mMonthRepeatByDayOfWeekIds;
    private static String[][] mMonthRepeatByDayOfWeekStrs;

    public static String getRepeatString(Context context, Resources r, EventRecurrence recurrence, boolean includeEndString) {
        String endString = "";
        if (includeEndString) {
            StringBuilder sb = new StringBuilder();
            if (recurrence.until != null) {
                try {
                    Time t = new Time();
                    t.parse(recurrence.until);
                    String dateStr = DateUtils.formatDateTime((Context)context, (long)t.toMillis(false), (int)131072);
                    sb.append(r.getString(R.string.endByDate, new Object[]{dateStr}));
                }
                catch (TimeFormatException t) {
                    // empty catch block
                }
            }
            if (recurrence.count > 0) {
                sb.append(r.getQuantityString(R.plurals.endByCount, recurrence.count, new Object[]{recurrence.count}));
            }
            endString = sb.toString();
        }
        int interval = recurrence.interval <= 1 ? 1 : recurrence.interval;
        switch (recurrence.freq) {
            case 4: {
                return r.getQuantityString(R.plurals.daily, interval, new Object[]{interval}) + endString;
            }
            case 5: {
                String string2;
                if (recurrence.repeatsOnEveryWeekDay()) {
                    return r.getString(R.string.every_weekday) + endString;
                }
                int dayOfWeekLength = 20;
                if (recurrence.bydayCount == 1) {
                    dayOfWeekLength = 10;
                }
                StringBuilder days = new StringBuilder();
                if (recurrence.bydayCount > 0) {
                    int count = recurrence.bydayCount - 1;
                    for (int i = 0; i < count; ++i) {
                        days.append(EventRecurrenceFormatter.dayToString(recurrence.byday[i], dayOfWeekLength));
                        days.append(", ");
                    }
                    days.append(EventRecurrenceFormatter.dayToString(recurrence.byday[count], dayOfWeekLength));
                    string2 = days.toString();
                } else {
                    if (recurrence.startDate == null) {
                        return null;
                    }
                    int day = EventRecurrence.timeDay2Day(recurrence.startDate.weekDay);
                    string2 = EventRecurrenceFormatter.dayToString(day, 10);
                }
                return r.getQuantityString(R.plurals.weekly, interval, new Object[]{interval, string2}) + endString;
            }
            case 6: {
                if (recurrence.bydayCount == 1) {
                    if (recurrence.startDate == null) {
                        return null;
                    }
                    int weekday = recurrence.startDate.weekDay;
                    EventRecurrenceFormatter.cacheMonthRepeatStrings(r, weekday);
                    int dayNumber = (recurrence.startDate.monthDay - 1) / 7;
                    StringBuilder sb = new StringBuilder();
                    sb.append(r.getString(R.string.monthly));
                    sb.append(" (");
                    sb.append(mMonthRepeatByDayOfWeekStrs[weekday][dayNumber]);
                    sb.append(")");
                    sb.append(endString);
                    return sb.toString();
                }
                return r.getString(R.string.monthly) + endString;
            }
            case 7: {
                return r.getString(R.string.yearly_plain) + endString;
            }
        }
        return null;
    }

    private static void cacheMonthRepeatStrings(Resources r, int weekday) {
        if (mMonthRepeatByDayOfWeekIds == null) {
            mMonthRepeatByDayOfWeekIds = new int[7];
            EventRecurrenceFormatter.mMonthRepeatByDayOfWeekIds[0] = R.array.repeat_by_nth_sun;
            EventRecurrenceFormatter.mMonthRepeatByDayOfWeekIds[1] = R.array.repeat_by_nth_mon;
            EventRecurrenceFormatter.mMonthRepeatByDayOfWeekIds[2] = R.array.repeat_by_nth_tues;
            EventRecurrenceFormatter.mMonthRepeatByDayOfWeekIds[3] = R.array.repeat_by_nth_wed;
            EventRecurrenceFormatter.mMonthRepeatByDayOfWeekIds[4] = R.array.repeat_by_nth_thurs;
            EventRecurrenceFormatter.mMonthRepeatByDayOfWeekIds[5] = R.array.repeat_by_nth_fri;
            EventRecurrenceFormatter.mMonthRepeatByDayOfWeekIds[6] = R.array.repeat_by_nth_sat;
        }
        if (mMonthRepeatByDayOfWeekStrs == null) {
            mMonthRepeatByDayOfWeekStrs = new String[7][];
        }
        if (mMonthRepeatByDayOfWeekStrs[weekday] == null) {
            EventRecurrenceFormatter.mMonthRepeatByDayOfWeekStrs[weekday] = r.getStringArray(mMonthRepeatByDayOfWeekIds[weekday]);
        }
    }

    private static String dayToString(int day, int dayOfWeekLength) {
        return DateUtils.getDayOfWeekString((int)EventRecurrenceFormatter.dayToUtilDay(day), (int)dayOfWeekLength);
    }

    private static int dayToUtilDay(int day) {
        switch (day) {
            case 65536: {
                return 1;
            }
            case 131072: {
                return 2;
            }
            case 262144: {
                return 3;
            }
            case 524288: {
                return 4;
            }
            case 0x100000: {
                return 5;
            }
            case 0x200000: {
                return 6;
            }
            case 0x400000: {
                return 7;
            }
        }
        throw new IllegalArgumentException("bad day argument: " + day);
    }
}

