/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.timepicker;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.Log;
import com.codetroopers.betterpickers.timepicker.TimePickerDialogFragment;
import java.util.Vector;

public class TimePickerBuilder {
    private FragmentManager manager;
    private Integer styleResId;
    private Fragment targetFragment;
    private int mReference = -1;
    private Vector<TimePickerDialogFragment.TimePickerDialogHandler> mTimePickerDialogHandlers = new Vector();

    public TimePickerBuilder setFragmentManager(FragmentManager manager) {
        this.manager = manager;
        return this;
    }

    public TimePickerBuilder setStyleResId(int styleResId) {
        this.styleResId = styleResId;
        return this;
    }

    public TimePickerBuilder setTargetFragment(Fragment targetFragment) {
        this.targetFragment = targetFragment;
        return this;
    }

    public TimePickerBuilder setReference(int reference) {
        this.mReference = reference;
        return this;
    }

    public TimePickerBuilder addTimePickerDialogHandler(TimePickerDialogFragment.TimePickerDialogHandler handler) {
        this.mTimePickerDialogHandlers.add(handler);
        return this;
    }

    public TimePickerBuilder removeTimePickerDialogHandler(TimePickerDialogFragment.TimePickerDialogHandler handler) {
        this.mTimePickerDialogHandlers.remove(handler);
        return this;
    }

    public void show() {
        if (this.manager == null || this.styleResId == null) {
            Log.e((String)"TimePickerBuilder", (String)"setFragmentManager() and setStyleResId() must be called.");
            return;
        }
        FragmentTransaction ft = this.manager.beginTransaction();
        Fragment prev = this.manager.findFragmentByTag("time_dialog");
        if (prev != null) {
            ft.remove(prev);
        }
        ft.addToBackStack(null);
        TimePickerDialogFragment fragment = TimePickerDialogFragment.newInstance(this.mReference, this.styleResId);
        if (this.targetFragment != null) {
            fragment.setTargetFragment(this.targetFragment, 0);
        }
        fragment.setTimePickerDialogHandlers(this.mTimePickerDialogHandlers);
        fragment.show(ft, "time_dialog");
    }
}

