/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.timepicker;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.timepicker.TimePicker;
import java.util.Vector;

public class TimePickerDialogFragment
extends DialogFragment {
    private static final String REFERENCE_KEY = "TimePickerDialogFragment_ReferenceKey";
    private static final String THEME_RES_ID_KEY = "TimePickerDialogFragment_ThemeResIdKey";
    private Button mSet;
    private Button mCancel;
    private TimePicker mPicker;
    private int mReference = -1;
    private int mTheme = -1;
    private View mDividerOne;
    private View mDividerTwo;
    private int mDividerColor;
    private ColorStateList mTextColor;
    private int mButtonBackgroundResId;
    private int mDialogBackgroundResId;
    private Vector<TimePickerDialogHandler> mTimePickerDialogHandlers = new Vector();

    public static TimePickerDialogFragment newInstance(int reference, int themeResId) {
        TimePickerDialogFragment frag = new TimePickerDialogFragment();
        Bundle args = new Bundle();
        args.putInt(REFERENCE_KEY, reference);
        args.putInt(THEME_RES_ID_KEY, themeResId);
        frag.setArguments(args);
        return frag;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null && args.containsKey(REFERENCE_KEY)) {
            this.mReference = args.getInt(REFERENCE_KEY);
        }
        if (args != null && args.containsKey(THEME_RES_ID_KEY)) {
            this.mTheme = args.getInt(THEME_RES_ID_KEY);
        }
        this.setStyle(1, 0);
        this.mTextColor = this.getResources().getColorStateList(R.color.dialog_text_color_holo_dark);
        this.mButtonBackgroundResId = R.drawable.button_background_dark;
        this.mDividerColor = this.getResources().getColor(R.color.default_divider_color_dark);
        this.mDialogBackgroundResId = R.drawable.dialog_full_holo_dark;
        if (this.mTheme != -1) {
            TypedArray a = this.getActivity().getApplicationContext().obtainStyledAttributes(this.mTheme, R.styleable.BetterPickersDialogFragment);
            this.mTextColor = a.getColorStateList(R.styleable.BetterPickersDialogFragment_bpTextColor);
            this.mButtonBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpButtonBackground, this.mButtonBackgroundResId);
            this.mDividerColor = a.getColor(R.styleable.BetterPickersDialogFragment_bpDividerColor, this.mDividerColor);
            this.mDialogBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpDialogBackground, this.mDialogBackgroundResId);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.time_picker_dialog, null);
        this.mSet = (Button)v.findViewById(R.id.set_button);
        this.mCancel = (Button)v.findViewById(R.id.cancel_button);
        this.mCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TimePickerDialogFragment.this.dismiss();
            }
        });
        this.mPicker = (TimePicker)v.findViewById(R.id.time_picker);
        this.mPicker.setSetButton(this.mSet);
        this.mSet.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                for (TimePickerDialogHandler handler : TimePickerDialogFragment.this.mTimePickerDialogHandlers) {
                    handler.onDialogTimeSet(TimePickerDialogFragment.this.mReference, TimePickerDialogFragment.this.mPicker.getHours(), TimePickerDialogFragment.this.mPicker.getMinutes());
                }
                FragmentActivity activity = TimePickerDialogFragment.this.getActivity();
                Fragment fragment = TimePickerDialogFragment.this.getTargetFragment();
                if (activity instanceof TimePickerDialogHandler) {
                    TimePickerDialogHandler act = (TimePickerDialogHandler)activity;
                    act.onDialogTimeSet(TimePickerDialogFragment.this.mReference, TimePickerDialogFragment.this.mPicker.getHours(), TimePickerDialogFragment.this.mPicker.getMinutes());
                } else if (fragment instanceof TimePickerDialogHandler) {
                    TimePickerDialogHandler frag = (TimePickerDialogHandler)fragment;
                    frag.onDialogTimeSet(TimePickerDialogFragment.this.mReference, TimePickerDialogFragment.this.mPicker.getHours(), TimePickerDialogFragment.this.mPicker.getMinutes());
                }
                TimePickerDialogFragment.this.dismiss();
            }
        });
        this.mDividerOne = v.findViewById(R.id.divider_1);
        this.mDividerTwo = v.findViewById(R.id.divider_2);
        this.mDividerOne.setBackgroundColor(this.mDividerColor);
        this.mDividerTwo.setBackgroundColor(this.mDividerColor);
        this.mSet.setTextColor(this.mTextColor);
        this.mSet.setBackgroundResource(this.mButtonBackgroundResId);
        this.mCancel.setTextColor(this.mTextColor);
        this.mCancel.setBackgroundResource(this.mButtonBackgroundResId);
        this.mPicker.setTheme(this.mTheme);
        this.getDialog().getWindow().setBackgroundDrawableResource(this.mDialogBackgroundResId);
        return v;
    }

    public void setTimePickerDialogHandlers(Vector<TimePickerDialogHandler> handlers) {
        this.mTimePickerDialogHandlers = handlers;
    }

    public static interface TimePickerDialogHandler {
        public void onDialogTimeSet(int var1, int var2, int var3);
    }
}

