/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.timezonepicker;

import android.content.Context;
import android.text.Spannable;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.util.SparseArray;
import com.codetroopers.betterpickers.timezonepicker.TimeZonePickerUtils;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import java.util.TimeZone;

public class TimeZoneInfo
implements Comparable<TimeZoneInfo> {
    private static final int GMT_TEXT_COLOR = -7829368;
    private static final int DST_SYMBOL_COLOR = -4210753;
    private static final char SEPARATOR = ',';
    private static final String TAG = null;
    public static int NUM_OF_TRANSITIONS = 6;
    public static long time = System.currentTimeMillis() / 1000L;
    public static boolean is24HourFormat;
    private static final Spannable.Factory mSpannableFactory;
    TimeZone mTz;
    public String mTzId;
    int mRawoffset;
    public int[] mTransitions;
    public String mCountry;
    public int groupId;
    public String mDisplayName;
    private Time recycledTime = new Time();
    private static StringBuilder mSB;
    private static Formatter mFormatter;
    SparseArray<String> mLocalTimeCache = new SparseArray();
    long mLocalTimeCacheReferenceTime = 0L;
    private static long mGmtDisplayNameUpdateTime;
    private static SparseArray<CharSequence> mGmtDisplayNameCache;

    public TimeZoneInfo(TimeZone tz, String country) {
        this.mTz = tz;
        this.mTzId = tz.getID();
        this.mCountry = country;
        this.mRawoffset = tz.getRawOffset();
        try {
            this.mTransitions = TimeZoneInfo.getTransitions(tz, time);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException ignored) {
            ignored.printStackTrace();
        }
    }

    public String getLocalTime(long referenceTime) {
        this.recycledTime.timezone = TimeZone.getDefault().getID();
        this.recycledTime.set(referenceTime);
        int currYearDay = this.recycledTime.year * 366 + this.recycledTime.yearDay;
        this.recycledTime.timezone = this.mTzId;
        this.recycledTime.set(referenceTime);
        String localTimeStr = null;
        int hourMinute = this.recycledTime.hour * 60 + this.recycledTime.minute;
        if (this.mLocalTimeCacheReferenceTime != referenceTime) {
            this.mLocalTimeCacheReferenceTime = referenceTime;
            this.mLocalTimeCache.clear();
        } else {
            localTimeStr = (String)this.mLocalTimeCache.get(hourMinute);
        }
        if (localTimeStr == null) {
            String format = "%I:%M %p";
            if (currYearDay != this.recycledTime.year * 366 + this.recycledTime.yearDay) {
                format = is24HourFormat ? "%b %d %H:%M" : "%b %d %I:%M %p";
            } else if (is24HourFormat) {
                format = "%H:%M";
            }
            localTimeStr = this.recycledTime.format(format);
            this.mLocalTimeCache.put(hourMinute, (Object)localTimeStr);
        }
        return localTimeStr;
    }

    public int getLocalHr(long referenceTime) {
        this.recycledTime.timezone = this.mTzId;
        this.recycledTime.set(referenceTime);
        return this.recycledTime.hour;
    }

    public int getNowOffsetMillis() {
        return this.mTz.getOffset(System.currentTimeMillis());
    }

    public synchronized CharSequence getGmtDisplayName(Context context) {
        long nowMinute = System.currentTimeMillis() / 60000L;
        long now = nowMinute * 60000L;
        int gmtOffset = this.mTz.getOffset(now);
        boolean hasFutureDST = this.mTz.useDaylightTime();
        int cacheKey = hasFutureDST ? (int)((long)gmtOffset + 129600000L) : (int)((long)gmtOffset - 129600000L);
        CharSequence displayName = null;
        if (mGmtDisplayNameUpdateTime != nowMinute) {
            mGmtDisplayNameUpdateTime = nowMinute;
            mGmtDisplayNameCache.clear();
        } else {
            displayName = (CharSequence)mGmtDisplayNameCache.get(cacheKey);
        }
        if (displayName == null) {
            mSB.setLength(0);
            int flags = 524288;
            flags |= 1;
            if (is24HourFormat) {
                flags |= 0x80;
            }
            DateUtils.formatDateRange((Context)context, (Formatter)mFormatter, (long)now, (long)now, (int)flags, (String)this.mTzId);
            mSB.append("  ");
            int gmtStart = mSB.length();
            TimeZonePickerUtils.appendGmtOffset(mSB, gmtOffset);
            int gmtEnd = mSB.length();
            int symbolStart = 0;
            int symbolEnd = 0;
            if (hasFutureDST) {
                mSB.append(' ');
                symbolStart = mSB.length();
                mSB.append(TimeZonePickerUtils.getDstSymbol());
                symbolEnd = mSB.length();
            }
            Spannable spannableText = mSpannableFactory.newSpannable((CharSequence)mSB);
            spannableText.setSpan((Object)new ForegroundColorSpan(-7829368), gmtStart, gmtEnd, 33);
            if (hasFutureDST) {
                spannableText.setSpan((Object)new ForegroundColorSpan(-4210753), symbolStart, symbolEnd, 33);
            }
            displayName = spannableText;
            mGmtDisplayNameCache.put(cacheKey, (Object)displayName);
        }
        return displayName;
    }

    private static int[] getTransitions(TimeZone tz, long time) throws IllegalAccessException, NoSuchFieldException {
        Class<?> zoneInfoClass = tz.getClass();
        Field mTransitionsField = zoneInfoClass.getDeclaredField("mTransitions");
        mTransitionsField.setAccessible(true);
        int[] objTransitions = (int[])mTransitionsField.get(tz);
        int[] transitions = null;
        if (objTransitions.length != 0) {
            transitions = new int[NUM_OF_TRANSITIONS];
            int numOfTransitions = 0;
            for (int i = 0; i < objTransitions.length; ++i) {
                if ((long)objTransitions[i] < time) continue;
                transitions[numOfTransitions++] = objTransitions[i];
                if (numOfTransitions == NUM_OF_TRANSITIONS) break;
            }
        }
        return transitions;
    }

    public boolean hasSameRules(TimeZoneInfo tzi) {
        return this.mRawoffset == tzi.mRawoffset && Arrays.equals(this.mTransitions, tzi.mTransitions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String country = this.mCountry;
        TimeZone tz = this.mTz;
        sb.append(this.mTzId);
        sb.append(',');
        sb.append(tz.getDisplayName(false, 1));
        sb.append(',');
        sb.append(tz.getDisplayName(false, 0));
        sb.append(',');
        if (tz.useDaylightTime()) {
            sb.append(tz.getDisplayName(true, 1));
            sb.append(',');
            sb.append(tz.getDisplayName(true, 0));
        } else {
            sb.append(',');
        }
        sb.append(',');
        sb.append((float)tz.getRawOffset() / 3600000.0f);
        sb.append(',');
        sb.append((float)tz.getDSTSavings() / 3600000.0f);
        sb.append(',');
        sb.append(country);
        sb.append(',');
        sb.append(this.getLocalTime(1357041600000L));
        sb.append(',');
        sb.append(this.getLocalTime(1363348800000L));
        sb.append(',');
        sb.append(this.getLocalTime(1372680000000L));
        sb.append(',');
        sb.append(this.getLocalTime(1383307200000L));
        sb.append(',');
        sb.append('\n');
        return sb.toString();
    }

    private static String formatTime(DateFormat df, int s) {
        long ms = (long)s * 1000L;
        return df.format(new Date(ms));
    }

    @Override
    public int compareTo(TimeZoneInfo other) {
        if (this.getNowOffsetMillis() != other.getNowOffsetMillis()) {
            return other.getNowOffsetMillis() < this.getNowOffsetMillis() ? -1 : 1;
        }
        if (this.mCountry == null && other.mCountry != null) {
            return 1;
        }
        if (other.mCountry == null) {
            return -1;
        }
        int diff = this.mCountry.compareTo(other.mCountry);
        if (diff != 0) {
            return diff;
        }
        if (Arrays.equals(this.mTransitions, other.mTransitions)) {
            Log.e((String)TAG, (String)("Not expected to be comparing tz with the same country, same offset, same dst, same transitions:\n" + this.toString() + "\n" + other.toString()));
        }
        if (this.mDisplayName != null && other.mDisplayName != null) {
            return this.mDisplayName.compareTo(other.mDisplayName);
        }
        return this.mTz.getDisplayName(Locale.getDefault()).compareTo(other.mTz.getDisplayName(Locale.getDefault()));
    }

    static {
        mSpannableFactory = Spannable.Factory.getInstance();
        mSB = new StringBuilder(50);
        mFormatter = new Formatter(mSB, Locale.getDefault());
        mGmtDisplayNameCache = new SparseArray();
    }
}

