/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.timezonepicker;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.codetroopers.betterpickers.timezonepicker.TimeZoneInfo;
import com.codetroopers.betterpickers.timezonepicker.TimeZonePickerView;

public class TimeZonePickerDialog
extends DialogFragment
implements TimeZonePickerView.OnTimeZoneSetListener {
    public static final String BUNDLE_START_TIME_MILLIS = "bundle_event_start_time";
    public static final String BUNDLE_TIME_ZONE = "bundle_event_time_zone";
    private static final String KEY_HAS_RESULTS = "has_results";
    private static final String KEY_LAST_FILTER_STRING = "last_filter_string";
    private static final String KEY_LAST_FILTER_TYPE = "last_filter_type";
    private static final String KEY_LAST_FILTER_TIME = "last_filter_time";
    private static final String KEY_HIDE_FILTER_SEARCH = "hide_filter_search";
    private OnTimeZoneSetListener mTimeZoneSetListener;
    private TimeZonePickerView mView;
    private boolean mHasCachedResults = false;

    public void setOnTimeZoneSetListener(OnTimeZoneSetListener l) {
        this.mTimeZoneSetListener = l;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        long timeMillis = 0L;
        String timeZone = null;
        Bundle b = this.getArguments();
        if (b != null) {
            timeMillis = b.getLong(BUNDLE_START_TIME_MILLIS);
            timeZone = b.getString(BUNDLE_TIME_ZONE);
        }
        boolean hideFilterSearch = false;
        if (savedInstanceState != null) {
            hideFilterSearch = savedInstanceState.getBoolean(KEY_HIDE_FILTER_SEARCH);
        }
        this.mView = new TimeZonePickerView((Context)this.getActivity(), null, timeZone, timeMillis, this, hideFilterSearch);
        if (savedInstanceState != null && savedInstanceState.getBoolean(KEY_HAS_RESULTS, false)) {
            this.mView.showFilterResults(savedInstanceState.getInt(KEY_LAST_FILTER_TYPE), savedInstanceState.getString(KEY_LAST_FILTER_STRING), savedInstanceState.getInt(KEY_LAST_FILTER_TIME));
        }
        return this.mView;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(KEY_HAS_RESULTS, this.mView != null && this.mView.hasResults());
        if (this.mView != null) {
            outState.putInt(KEY_LAST_FILTER_TYPE, this.mView.getLastFilterType());
            outState.putString(KEY_LAST_FILTER_STRING, this.mView.getLastFilterString());
            outState.putInt(KEY_LAST_FILTER_TIME, this.mView.getLastFilterTime());
            outState.putBoolean(KEY_HIDE_FILTER_SEARCH, this.mView.getHideFilterSearchOnStart());
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setSoftInputMode(16);
        return dialog;
    }

    @Override
    public void onTimeZoneSet(TimeZoneInfo tzi) {
        if (this.mTimeZoneSetListener != null) {
            this.mTimeZoneSetListener.onTimeZoneSet(tzi);
        }
        this.dismiss();
    }

    public static interface OnTimeZoneSetListener {
        public void onTimeZoneSet(TimeZoneInfo var1);
    }
}

