/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.booster.instrument;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.util.Log;
import android.view.SurfaceHolder;
import com.didiglobal.booster.instrument.CaughtCallback;
import com.didiglobal.booster.instrument.Constants;
import com.didiglobal.booster.instrument.Reflection;

public final class ShadowMediaPlayer
implements Constants {
    public static MediaPlayer newMediaPlayer() {
        return ShadowMediaPlayer.workaround(new MediaPlayer());
    }

    public static MediaPlayer create(Context context, Uri uri) {
        return ShadowMediaPlayer.workaround(MediaPlayer.create((Context)context, (Uri)uri));
    }

    public static MediaPlayer create(Context context, Uri uri, SurfaceHolder holder) {
        return ShadowMediaPlayer.workaround(MediaPlayer.create((Context)context, (Uri)uri, (SurfaceHolder)holder));
    }

    public static MediaPlayer create(Context context, Uri uri, SurfaceHolder holder, AudioAttributes audioAttributes, int audioSessionId) {
        return ShadowMediaPlayer.workaround(MediaPlayer.create((Context)context, (Uri)uri, (SurfaceHolder)holder, (AudioAttributes)audioAttributes, (int)audioSessionId));
    }

    public static MediaPlayer create(Context context, int resid) {
        return ShadowMediaPlayer.workaround(MediaPlayer.create((Context)context, (int)resid));
    }

    public static MediaPlayer create(Context context, int resid, AudioAttributes audioAttributes, int audioSessionId) {
        return ShadowMediaPlayer.workaround(MediaPlayer.create((Context)context, (int)resid, (AudioAttributes)audioAttributes, (int)audioSessionId));
    }

    private static MediaPlayer workaround(MediaPlayer player) {
        try {
            Handler handler = ShadowMediaPlayer.getEventHandler(player);
            if (null == handler || !Reflection.setFieldValue((Object)handler, (String)"mCallback", (Object)new CaughtCallback(handler))) {
                Log.i((String)"booster", (String)"Hook MediaPlayer.mEventHandler.mCallback failed");
            }
        }
        catch (Throwable t) {
            Log.e((String)"booster", (String)"Hook MediaPlayer.mEventHandler.mCallback failed", (Throwable)t);
        }
        return player;
    }

    private static Handler getEventHandler(MediaPlayer player) {
        Handler handler = (Handler)Reflection.getFieldValue((Object)player, (String)"mEventHandler");
        if (null != handler) {
            return handler;
        }
        try {
            handler = (Handler)Reflection.getFieldValue((Object)player, Class.forName("android.media.MediaPlayer$EventHandler"));
            if (null != handler) {
                return handler;
            }
        }
        catch (ClassNotFoundException e) {
            Log.w((String)"booster", (String)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private ShadowMediaPlayer() {
    }
}

