/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.booster.instrument;

import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;

public abstract class Reflection {
    public static <T> T getStaticFieldValue(Class<?> klass, String name) {
        if (null != klass && null != name) {
            try {
                Field field = Reflection.getField(klass, name);
                if (null != field) {
                    field.setAccessible(true);
                    return (T)field.get(klass);
                }
            }
            catch (Throwable t) {
                Log.w((String)"booster", (String)("get field " + name + " of " + klass + " error"), (Throwable)t);
            }
        }
        return null;
    }

    public static boolean setStaticFieldValue(Class<?> klass, String name, Object value) {
        if (null != klass && null != name) {
            try {
                Field field = Reflection.getField(klass, name);
                if (null != field) {
                    field.setAccessible(true);
                    field.set(klass, value);
                    return true;
                }
            }
            catch (Throwable t) {
                Log.w((String)"booster", (String)("set field " + name + " of " + klass + " error"), (Throwable)t);
            }
        }
        return false;
    }

    public static <T> T getFieldValue(Object obj, String name) {
        if (null != obj && null != name) {
            try {
                Field field = Reflection.getField(obj.getClass(), name);
                if (null != field) {
                    field.setAccessible(true);
                    return (T)field.get(obj);
                }
            }
            catch (Throwable t) {
                Log.w((String)"booster", (String)("get field " + name + " of " + obj + " error"), (Throwable)t);
            }
        }
        return null;
    }

    public static <T> T getFieldValue(Object obj, Class<?> type) {
        if (null != obj && null != type) {
            try {
                Field field = Reflection.getField(obj.getClass(), type);
                if (null != field) {
                    field.setAccessible(true);
                    return (T)field.get(obj);
                }
            }
            catch (Throwable t) {
                Log.w((String)"booster", (String)("get field with type " + type + " of " + obj + " error"), (Throwable)t);
            }
        }
        return null;
    }

    public static boolean setFieldValue(Object obj, String name, Object value) {
        if (null != obj && null != name) {
            try {
                Field field = Reflection.getField(obj.getClass(), name);
                if (null != field) {
                    field.setAccessible(true);
                    field.set(obj, value);
                    return true;
                }
            }
            catch (Throwable t) {
                Log.w((String)"booster", (String)("set field " + name + " of " + obj + " error"), (Throwable)t);
            }
        }
        return false;
    }

    public static <T> T newInstance(String className, Object ... args) {
        try {
            return Reflection.newInstance(Class.forName(className), args);
        }
        catch (ClassNotFoundException e) {
            Log.w((String)"booster", (String)("new instance of " + className + " error"), (Throwable)e);
            return null;
        }
    }

    public static <T> T newInstance(Class<?> clazz, Object ... args) {
        Constructor<?>[] ctors;
        block2: for (Constructor<?> ctor : ctors = clazz.getDeclaredConstructors()) {
            Class<?>[] types = ctor.getParameterTypes();
            if (types.length != args.length) continue;
            for (int i = 0; i < types.length; ++i) {
                if (null != args[i] && !types[i].isAssignableFrom(args[i].getClass())) continue block2;
            }
            try {
                ctor.setAccessible(true);
                return (T)ctor.newInstance(args);
            }
            catch (Throwable t) {
                Log.w((String)"booster", (String)("Invoke constructor " + ctor + " error"), (Throwable)t);
                return null;
            }
        }
        return null;
    }

    public static <T> T invokeStaticMethod(Class<?> klass, String name) {
        return Reflection.invokeStaticMethod(klass, name, new Class[0], new Object[0]);
    }

    public static <T> T invokeStaticMethod(Class<?> klass, String name, Class[] types, Object[] args) {
        if (null != klass && null != name && null != types && null != args && types.length == args.length) {
            try {
                Method method = Reflection.getMethod(klass, name, types);
                if (null != method) {
                    method.setAccessible(true);
                    return (T)method.invoke(klass, args);
                }
            }
            catch (Throwable e) {
                Log.w((String)"booster", (String)("Invoke " + name + "(" + Arrays.toString(types) + ") of " + klass + " error"), (Throwable)e);
            }
        }
        return null;
    }

    public static <T> T invokeMethod(Object obj, String name) {
        return Reflection.invokeMethod(obj, name, new Class[0], new Object[0]);
    }

    public static <T> T invokeMethod(Object obj, String name, Class[] types, Object[] args) {
        if (null != obj && null != name && null != types && null != args && types.length == args.length) {
            try {
                Method method = Reflection.getMethod(obj.getClass(), name, types);
                if (null != method) {
                    method.setAccessible(true);
                    return (T)method.invoke(obj, args);
                }
            }
            catch (Throwable e) {
                Log.w((String)"booster", (String)("Invoke " + name + "(" + Arrays.toString(types) + ") of " + obj + " error"), (Throwable)e);
            }
        }
        return null;
    }

    public static Field getField(Class<?> klass, String name) {
        try {
            return klass.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            Class<?> parent = klass.getSuperclass();
            if (null == parent) {
                return null;
            }
            return Reflection.getField(parent, name);
        }
    }

    public static Field getField(Class<?> klass, Class<?> type) {
        Field[] fields = klass.getDeclaredFields();
        if (fields.length <= 0) {
            Class<?> parent = klass.getSuperclass();
            if (null == parent) {
                return null;
            }
            return Reflection.getField(parent, type);
        }
        for (Field field : fields) {
            if (field.getType() != type) continue;
            return field;
        }
        return null;
    }

    private static Method getMethod(Class<?> klass, String name, Class<?>[] types) {
        try {
            return klass.getDeclaredMethod(name, types);
        }
        catch (NoSuchMethodException e) {
            Class<?> parent = klass.getSuperclass();
            if (null == parent) {
                return null;
            }
            return Reflection.getMethod(parent, name, types);
        }
    }

    private Reflection() {
    }
}

