/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.flattener;

import com.elvishew.xlog.LogLevel;
import com.elvishew.xlog.flattener.Flattener;
import com.elvishew.xlog.flattener.Flattener2;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternFlattener
implements Flattener,
Flattener2 {
    private static final String PARAM = "[^{}]*";
    private static final Pattern PARAM_REGEX = Pattern.compile("\\{([^{}]*)\\}");
    private static final String PARAMETER_DATE = "d";
    private static final String PARAMETER_LEVEL_SHORT = "l";
    private static final String PARAMETER_LEVEL_LONG = "L";
    private static final String PARAMETER_TAG = "t";
    private static final String PARAMETER_MESSAGE = "m";
    static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private String pattern;
    private List<ParameterFiller> parameterFillers;

    public PatternFlattener(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("Pattern should not be null");
        }
        this.pattern = pattern;
        List<String> parameters = PatternFlattener.parsePattern(pattern);
        this.parameterFillers = PatternFlattener.parseParameters(parameters);
        if (this.parameterFillers.size() == 0) {
            throw new IllegalArgumentException("No recognizable parameter found in the pattern " + pattern);
        }
    }

    static List<String> parsePattern(String pattern) {
        ArrayList<String> parameters = new ArrayList<String>(4);
        Matcher matcher = PARAM_REGEX.matcher(pattern);
        while (matcher.find()) {
            parameters.add(matcher.group(1));
        }
        return parameters;
    }

    private static List<ParameterFiller> parseParameters(List<String> parameters) {
        ArrayList<ParameterFiller> parameterFillers = new ArrayList<ParameterFiller>(parameters.size());
        for (String parameter : parameters) {
            ParameterFiller parameterFiller = PatternFlattener.parseParameter(parameter);
            if (parameterFiller == null) continue;
            parameterFillers.add(parameterFiller);
        }
        return parameterFillers;
    }

    private static ParameterFiller parseParameter(String parameter) {
        String trimmedParameter;
        String wrappedParameter = "{" + parameter + "}";
        ParameterFiller parameterFiller = PatternFlattener.parseDateParameter(wrappedParameter, trimmedParameter = parameter.trim());
        if (parameterFiller != null) {
            return parameterFiller;
        }
        parameterFiller = PatternFlattener.parseLevelParameter(wrappedParameter, trimmedParameter);
        if (parameterFiller != null) {
            return parameterFiller;
        }
        parameterFiller = PatternFlattener.parseTagParameter(wrappedParameter, trimmedParameter);
        if (parameterFiller != null) {
            return parameterFiller;
        }
        parameterFiller = PatternFlattener.parseMessageParameter(wrappedParameter, trimmedParameter);
        if (parameterFiller != null) {
            return parameterFiller;
        }
        return null;
    }

    static DateFiller parseDateParameter(String wrappedParameter, String trimmedParameter) {
        if (trimmedParameter.startsWith("d ") && trimmedParameter.length() > PARAMETER_DATE.length() + 1) {
            String dateFormat = trimmedParameter.substring(PARAMETER_DATE.length() + 1);
            return new DateFiller(wrappedParameter, trimmedParameter, dateFormat);
        }
        if (trimmedParameter.equals(PARAMETER_DATE)) {
            return new DateFiller(wrappedParameter, trimmedParameter, DEFAULT_DATE_FORMAT);
        }
        return null;
    }

    static LevelFiller parseLevelParameter(String wrappedParameter, String trimmedParameter) {
        if (trimmedParameter.equals(PARAMETER_LEVEL_SHORT)) {
            return new LevelFiller(wrappedParameter, trimmedParameter, false);
        }
        if (trimmedParameter.equals(PARAMETER_LEVEL_LONG)) {
            return new LevelFiller(wrappedParameter, trimmedParameter, true);
        }
        return null;
    }

    static TagFiller parseTagParameter(String wrappedParameter, String trimmedParameter) {
        if (trimmedParameter.equals(PARAMETER_TAG)) {
            return new TagFiller(wrappedParameter, trimmedParameter);
        }
        return null;
    }

    static MessageFiller parseMessageParameter(String wrappedParameter, String trimmedParameter) {
        if (trimmedParameter.equals(PARAMETER_MESSAGE)) {
            return new MessageFiller(wrappedParameter, trimmedParameter);
        }
        return null;
    }

    @Override
    public CharSequence flatten(int logLevel, String tag, String message) {
        return this.flatten(System.currentTimeMillis(), logLevel, tag, message);
    }

    @Override
    public CharSequence flatten(long timeMillis, int logLevel, String tag, String message) {
        String flattenedLog = this.pattern;
        for (ParameterFiller parameterFiller : this.parameterFillers) {
            flattenedLog = parameterFiller.fill(flattenedLog, timeMillis, logLevel, tag, message);
        }
        return flattenedLog;
    }

    static abstract class ParameterFiller {
        String wrappedParameter;
        String trimmedParameter;

        ParameterFiller(String wrappedParameter, String trimmedParameter) {
            this.wrappedParameter = wrappedParameter;
            this.trimmedParameter = trimmedParameter;
        }

        protected abstract String fill(String var1, long var2, int var4, String var5, String var6);
    }

    static class MessageFiller
    extends ParameterFiller {
        MessageFiller(String wrappedParameter, String trimmedParameter) {
            super(wrappedParameter, trimmedParameter);
        }

        @Override
        protected String fill(String pattern, long timeMillis, int logLevel, String tag, String message) {
            return pattern.replace(this.wrappedParameter, message);
        }
    }

    static class TagFiller
    extends ParameterFiller {
        TagFiller(String wrappedParameter, String trimmedParameter) {
            super(wrappedParameter, trimmedParameter);
        }

        @Override
        protected String fill(String pattern, long timeMillis, int logLevel, String tag, String message) {
            return pattern.replace(this.wrappedParameter, tag);
        }
    }

    static class LevelFiller
    extends ParameterFiller {
        boolean useLongName;

        LevelFiller(String wrappedParameter, String trimmedParameter, boolean useLongName) {
            super(wrappedParameter, trimmedParameter);
            this.useLongName = useLongName;
        }

        @Override
        protected String fill(String pattern, long timeMillis, int logLevel, String tag, String message) {
            if (this.useLongName) {
                return pattern.replace(this.wrappedParameter, LogLevel.getLevelName(logLevel));
            }
            return pattern.replace(this.wrappedParameter, LogLevel.getShortLevelName(logLevel));
        }
    }

    static class DateFiller
    extends ParameterFiller {
        String dateFormat;
        private ThreadLocal<SimpleDateFormat> threadLocalDateFormat = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(DateFiller.this.dateFormat, Locale.US);
            }
        };

        DateFiller(String wrappedParameter, String trimmedParameter, String dateFormat) {
            super(wrappedParameter, trimmedParameter);
            this.dateFormat = dateFormat;
            try {
                this.threadLocalDateFormat.get().format(new Date());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Bad date pattern: " + dateFormat, e);
            }
        }

        @Override
        protected String fill(String pattern, long timeMillis, int logLevel, String tag, String message) {
            return pattern.replace(this.wrappedParameter, this.threadLocalDateFormat.get().format(new Date(timeMillis)));
        }
    }
}

