/*
 * Decompiled with CFR 0.152.
 */
package com.elvishew.xlog.printer.file;

import com.elvishew.xlog.flattener.Flattener;
import com.elvishew.xlog.flattener.Flattener2;
import com.elvishew.xlog.internal.DefaultsFactory;
import com.elvishew.xlog.internal.Platform;
import com.elvishew.xlog.internal.printer.file.backup.BackupStrategyWrapper;
import com.elvishew.xlog.internal.printer.file.backup.BackupUtil;
import com.elvishew.xlog.printer.Printer;
import com.elvishew.xlog.printer.file.backup.BackupStrategy;
import com.elvishew.xlog.printer.file.backup.BackupStrategy2;
import com.elvishew.xlog.printer.file.clean.CleanStrategy;
import com.elvishew.xlog.printer.file.naming.FileNameGenerator;
import com.elvishew.xlog.printer.file.writer.Writer;
import java.io.File;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class FilePrinter
implements Printer {
    private static final boolean USE_WORKER = true;
    private final String folderPath;
    private final FileNameGenerator fileNameGenerator;
    private final BackupStrategy2 backupStrategy;
    private final CleanStrategy cleanStrategy;
    private Flattener2 flattener;
    private Writer writer;
    private volatile Worker worker;

    FilePrinter(Builder builder) {
        this.folderPath = builder.folderPath;
        this.fileNameGenerator = builder.fileNameGenerator;
        this.backupStrategy = builder.backupStrategy;
        this.cleanStrategy = builder.cleanStrategy;
        this.flattener = builder.flattener;
        this.writer = builder.writer;
        this.worker = new Worker();
        this.checkLogFolder();
    }

    private void checkLogFolder() {
        File folder = new File(this.folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    @Override
    public void println(int logLevel, String tag, String msg) {
        long timeMillis = System.currentTimeMillis();
        if (!this.worker.isStarted()) {
            this.worker.start();
        }
        this.worker.enqueue(new LogItem(timeMillis, logLevel, tag, msg));
    }

    private void doPrintln(long timeMillis, int logLevel, String tag, String msg) {
        File lastFile;
        boolean isWriterClosed;
        String lastFileName = this.writer.getOpenedFileName();
        boolean bl = isWriterClosed = !this.writer.isOpened();
        if (lastFileName == null || isWriterClosed || this.fileNameGenerator.isFileNameChangeable()) {
            String newFileName = this.fileNameGenerator.generateFileName(logLevel, System.currentTimeMillis());
            if (newFileName == null || newFileName.trim().length() == 0) {
                Platform.get().error("File name should not be empty, ignore log: " + msg);
                return;
            }
            if (!newFileName.equals(lastFileName) || isWriterClosed) {
                this.writer.close();
                this.cleanLogFilesIfNecessary();
                if (!this.writer.open(new File(this.folderPath, newFileName))) {
                    return;
                }
                lastFileName = newFileName;
            }
        }
        if (this.backupStrategy.shouldBackup(lastFile = this.writer.getOpenedFile())) {
            this.writer.close();
            BackupUtil.backup(lastFile, this.backupStrategy);
            if (!this.writer.open(new File(this.folderPath, lastFileName))) {
                return;
            }
        }
        String flattenedLog = this.flattener.flatten(timeMillis, logLevel, tag, msg).toString();
        this.writer.appendLog(flattenedLog);
    }

    private void cleanLogFilesIfNecessary() {
        File logDir = new File(this.folderPath);
        File[] files = logDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!this.cleanStrategy.shouldClean(file)) continue;
            file.delete();
        }
    }

    private class Worker
    implements Runnable {
        private BlockingQueue<LogItem> logs = new LinkedBlockingQueue<LogItem>();
        private volatile boolean started;

        private Worker() {
        }

        void enqueue(LogItem log) {
            try {
                this.logs.put(log);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isStarted() {
            Worker worker = this;
            synchronized (worker) {
                return this.started;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() {
            Worker worker = this;
            synchronized (worker) {
                if (this.started) {
                    return;
                }
                new Thread(this).start();
                this.started = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LogItem log;
                while ((log = this.logs.take()) != null) {
                    FilePrinter.this.doPrintln(log.timeMillis, log.level, log.tag, log.msg);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Worker worker = this;
                synchronized (worker) {
                    this.started = false;
                }
            }
        }
    }

    private static class LogItem {
        long timeMillis;
        int level;
        String tag;
        String msg;

        LogItem(long timeMillis, int level, String tag, String msg) {
            this.timeMillis = timeMillis;
            this.level = level;
            this.tag = tag;
            this.msg = msg;
        }
    }

    public static class Builder {
        String folderPath;
        FileNameGenerator fileNameGenerator;
        BackupStrategy2 backupStrategy;
        CleanStrategy cleanStrategy;
        Flattener2 flattener;
        Writer writer;

        public Builder(String folderPath) {
            this.folderPath = folderPath;
        }

        public Builder fileNameGenerator(FileNameGenerator fileNameGenerator) {
            this.fileNameGenerator = fileNameGenerator;
            return this;
        }

        public Builder backupStrategy(BackupStrategy backupStrategy) {
            if (!(backupStrategy instanceof BackupStrategy2)) {
                backupStrategy = new BackupStrategyWrapper(backupStrategy);
            }
            this.backupStrategy = (BackupStrategy2)backupStrategy;
            BackupUtil.verifyBackupStrategy(this.backupStrategy);
            return this;
        }

        public Builder cleanStrategy(CleanStrategy cleanStrategy) {
            this.cleanStrategy = cleanStrategy;
            return this;
        }

        @Deprecated
        public Builder logFlattener(final Flattener flattener) {
            return this.flattener(new Flattener2(){

                @Override
                public CharSequence flatten(long timeMillis, int logLevel, String tag, String message) {
                    return flattener.flatten(logLevel, tag, message);
                }
            });
        }

        public Builder flattener(Flattener2 flattener) {
            this.flattener = flattener;
            return this;
        }

        public Builder writer(Writer writer) {
            this.writer = writer;
            return this;
        }

        public FilePrinter build() {
            this.fillEmptyFields();
            return new FilePrinter(this);
        }

        private void fillEmptyFields() {
            if (this.fileNameGenerator == null) {
                this.fileNameGenerator = DefaultsFactory.createFileNameGenerator();
            }
            if (this.backupStrategy == null) {
                this.backupStrategy = DefaultsFactory.createBackupStrategy();
            }
            if (this.cleanStrategy == null) {
                this.cleanStrategy = DefaultsFactory.createCleanStrategy();
            }
            if (this.flattener == null) {
                this.flattener = DefaultsFactory.createFlattener2();
            }
            if (this.writer == null) {
                this.writer = DefaultsFactory.createWriter();
            }
        }
    }
}

