/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import com.evernote.android.job.Job;
import com.evernote.android.job.JobCreator;
import com.evernote.android.job.util.JobCat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.vrallev.android.cat.CatLog;

class JobCreatorHolder {
    private static final CatLog CAT = new JobCat("JobCreatorHolder");
    private final List<JobCreator> mJobCreators = new ArrayList<JobCreator>();
    private final Object mMonitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobCreator(JobCreator creator) {
        Object object = this.mMonitor;
        synchronized (object) {
            this.mJobCreators.add(creator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobCreator(JobCreator creator) {
        Object object = this.mMonitor;
        synchronized (object) {
            this.mJobCreators.remove(creator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job createJob(String tag) {
        ArrayList<JobCreator> jobCreators = null;
        JobCreator singleJobCreator = null;
        Iterator<JobCreator> iterator = this.mMonitor;
        synchronized (iterator) {
            int count = this.mJobCreators.size();
            if (count == 0) {
                CAT.w("no JobCreator added");
                return null;
            }
            if (count == 1) {
                singleJobCreator = this.mJobCreators.get(0);
            } else {
                jobCreators = new ArrayList<JobCreator>(this.mJobCreators);
            }
        }
        if (singleJobCreator != null) {
            return singleJobCreator.create(tag);
        }
        if (jobCreators != null) {
            for (JobCreator jobCreator : jobCreators) {
                Job job = jobCreator.create(tag);
                if (job == null) continue;
                return job;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.mMonitor;
        synchronized (object) {
            return this.mJobCreators.isEmpty();
        }
    }
}

