/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import android.content.Context;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.LruCache;
import android.util.SparseArray;
import com.evernote.android.job.Job;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.WakeLockUtil;
import com.evernote.android.job.util.JobCat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.vrallev.android.cat.CatLog;

class JobExecutor {
    private static final CatLog CAT = new JobCat("JobExecutor");
    private static final long WAKE_LOCK_TIMEOUT = TimeUnit.MINUTES.toMillis(3L);
    private final ExecutorService mExecutorService = Executors.newCachedThreadPool();
    private final SparseArray<Job> mJobs = new SparseArray();
    private final LruCache<Integer, Job> mFinishedJobsCache = new LruCache(20);

    public synchronized Future<Job.Result> execute(@NonNull Context context, @NonNull JobRequest request, @Nullable Job job) {
        if (job == null) {
            CAT.w("JobCreator returned null for tag %s", new Object[]{request.getTag()});
            return null;
        }
        if (job.isFinished()) {
            throw new IllegalStateException("Job for tag %s was already run, a creator should always create a new Job instance");
        }
        job.setContext(context).setRequest(request);
        CAT.i("Executing %s, context %s", new Object[]{request, context.getClass().getSimpleName()});
        this.mJobs.put(request.getJobId(), (Object)job);
        return this.mExecutorService.submit(new JobCallable(job));
    }

    public synchronized Job getJob(int jobId) {
        Job job = (Job)this.mJobs.get(jobId);
        return job != null ? job : (Job)this.mFinishedJobsCache.get((Object)jobId);
    }

    public synchronized Set<Job> getAllJobs() {
        return this.getAllJobsForTag(null);
    }

    public synchronized Set<Job> getAllJobsForTag(String tag) {
        HashSet<Job> result = new HashSet<Job>();
        for (int i = 0; i < this.mJobs.size(); ++i) {
            Job job = (Job)this.mJobs.valueAt(i);
            if (tag != null && !tag.equals(job.getParams().getTag())) continue;
            result.add(job);
        }
        Map snapshot = this.mFinishedJobsCache.snapshot();
        for (Job job : snapshot.values()) {
            if (tag != null && !tag.equals(job.getParams().getTag())) continue;
            result.add(job);
        }
        return result;
    }

    private synchronized void markJobAsFinished(Job job) {
        int id = job.getParams().getId();
        this.mJobs.remove(id);
        this.mFinishedJobsCache.put((Object)id, (Object)job);
    }

    private final class JobCallable
    implements Callable<Job.Result> {
        private final Job mJob;
        private final PowerManager.WakeLock mWakeLock;

        private JobCallable(Job job) {
            this.mJob = job;
            Context context = this.mJob.getContext();
            this.mWakeLock = WakeLockUtil.acquireWakeLock(context, "JobExecutor", WAKE_LOCK_TIMEOUT);
        }

        @Override
        public Job.Result call() throws Exception {
            Job.Result result;
            try {
                WakeLockUtil.acquireWakeLock(this.mJob.getContext(), this.mWakeLock, WAKE_LOCK_TIMEOUT);
                result = this.runJob();
            }
            catch (Throwable throwable) {
                JobExecutor.this.markJobAsFinished(this.mJob);
                if (this.mWakeLock == null || !this.mWakeLock.isHeld()) {
                    CAT.w("Wake lock was not held after job %s was done. The job took too long to complete. This could have unintended side effects on your app.", new Object[]{this.mJob});
                }
                WakeLockUtil.releaseWakeLock(this.mWakeLock);
                throw throwable;
            }
            JobExecutor.this.markJobAsFinished(this.mJob);
            if (this.mWakeLock == null || !this.mWakeLock.isHeld()) {
                CAT.w("Wake lock was not held after job %s was done. The job took too long to complete. This could have unintended side effects on your app.", new Object[]{this.mJob});
            }
            WakeLockUtil.releaseWakeLock(this.mWakeLock);
            return result;
        }

        private Job.Result runJob() {
            Job.Result result;
            try {
                result = this.mJob.runJob();
                CAT.i("Finished %s", new Object[]{this.mJob});
                this.handleResult(result);
            }
            catch (Throwable t) {
                CAT.e(t, "Crashed %s", new Object[]{this.mJob});
                result = this.mJob.getResult();
            }
            return result;
        }

        private void handleResult(Job.Result result) {
            JobRequest request = this.mJob.getParams().getRequest();
            if (!request.isPeriodic() && Job.Result.RESCHEDULE.equals((Object)result)) {
                int newJobId = request.reschedule(true);
                this.mJob.onReschedule(newJobId);
            } else if (request.isPeriodic() && !Job.Result.SUCCESS.equals((Object)result)) {
                request.incNumFailures();
            }
        }
    }
}

