/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import android.app.Service;
import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.evernote.android.job.Job;
import com.evernote.android.job.JobExecutor;
import com.evernote.android.job.JobManager;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.JobApi;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.JobUtil;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.vrallev.android.cat.CatLog;

public interface JobProxy {
    public void plantOneOff(JobRequest var1);

    public void plantPeriodic(JobRequest var1);

    public void cancel(int var1);

    public boolean isPlatformJobScheduled(JobRequest var1);

    public static final class Common {
        private final Context mContext;
        private final int mJobId;
        private final CatLog mCat;
        private final JobManager mJobManager;

        private static long checkedAdd(long a, long b) {
            long result = a + b;
            return Common.checkNoOverflow(result, (a ^ b) < 0L | (a ^ result) >= 0L);
        }

        private static long checkNoOverflow(long result, boolean condition) {
            return condition ? result : Long.MAX_VALUE;
        }

        public static long getStartMs(JobRequest request) {
            return Common.checkedAdd(request.getStartMs(), request.getBackoffOffset());
        }

        public static long getEndMs(JobRequest request) {
            return Common.checkedAdd(request.getEndMs(), request.getBackoffOffset());
        }

        public static long getAverageDelayMs(JobRequest request) {
            return Common.checkedAdd(Common.getStartMs(request), (Common.getEndMs(request) - Common.getStartMs(request)) / 2L);
        }

        public Common(@NonNull Service service, int jobId) {
            this((Context)service, service.getClass().getSimpleName(), jobId);
        }

        Common(@NonNull Context context, String loggingTag, int jobId) {
            this.mContext = context;
            this.mJobId = jobId;
            this.mCat = new JobCat(loggingTag);
            this.mJobManager = JobManager.create(context);
        }

        public JobRequest getPendingRequest(boolean cleanUpOrphanedJob) {
            boolean periodic;
            JobRequest request = this.mJobManager.getJobRequest(this.mJobId, true);
            Job job = this.mJobManager.getJob(this.mJobId);
            boolean bl = periodic = request != null && request.isPeriodic();
            if (job != null && !job.isFinished()) {
                this.mCat.d("Job %d is already running, %s", new Object[]{this.mJobId, request});
                return null;
            }
            if (job != null && !periodic) {
                this.mCat.d("Job %d already finished, %s", new Object[]{this.mJobId, request});
                this.cleanUpOrphanedJob(cleanUpOrphanedJob);
                return null;
            }
            if (job != null && System.currentTimeMillis() - job.getFinishedTimeStamp() < 2000L) {
                this.mCat.d("Job %d is periodic and just finished, %s", new Object[]{this.mJobId, request});
                return null;
            }
            if (request != null && request.isTransient()) {
                this.mCat.d("Request %d is transient, %s", new Object[]{this.mJobId, request});
                return null;
            }
            if (request == null) {
                this.mCat.d("Request for ID %d was null", new Object[]{this.mJobId});
                this.cleanUpOrphanedJob(cleanUpOrphanedJob);
                return null;
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public Job.Result executeJobRequest(@NonNull JobRequest request) {
            long waited = System.currentTimeMillis() - request.getScheduledAt();
            String timeWindow = request.isPeriodic() ? "interval " + JobUtil.timeToString(request.getIntervalMs()) : (JobApi.V_14.equals((Object)request.getJobApi()) ? "delay " + JobUtil.timeToString(Common.getAverageDelayMs(request)) : String.format(Locale.US, "start %s, end %s", JobUtil.timeToString(Common.getStartMs(request)), JobUtil.timeToString(Common.getEndMs(request))));
            if (Looper.myLooper() == Looper.getMainLooper()) {
                this.mCat.w("Running JobRequest on a main thread, this could cause stutter or ANR in your app.");
            }
            this.mCat.d("Run job, %s, waited %s, %s", new Object[]{request, JobUtil.timeToString(waited), timeWindow});
            JobExecutor jobExecutor = this.mJobManager.getJobExecutor();
            Job job = null;
            try {
                Future<Job.Result> future;
                job = this.mJobManager.getJobCreatorHolder().createJob(request.getTag());
                if (!request.isPeriodic()) {
                    request.setTransient(true);
                }
                if ((future = jobExecutor.execute(this.mContext, request, job)) == null) {
                    Job.Result result = Job.Result.FAILURE;
                    return result;
                }
                Job.Result result = future.get();
                this.mCat.d("Finished job, %s %s", new Object[]{request, result});
                Job.Result result2 = result;
                return result2;
            }
            catch (InterruptedException | ExecutionException e) {
                this.mCat.e((Throwable)e);
                if (job != null) {
                    job.cancel();
                    this.mCat.e("Canceled %s", new Object[]{request});
                }
                Job.Result result = Job.Result.FAILURE;
                return result;
            }
            finally {
                if (!request.isPeriodic()) {
                    this.mJobManager.getJobStorage().remove(request);
                }
            }
        }

        private void cleanUpOrphanedJob(boolean cleanUp) {
            if (cleanUp) {
                Common.cleanUpOrphanedJob(this.mContext, this.mJobId);
            }
        }

        public static void cleanUpOrphanedJob(Context context, int jobId) {
            for (JobApi jobApi : JobApi.values()) {
                if (!jobApi.isSupported(context)) continue;
                jobApi.getCachedProxy(context).cancel(jobId);
            }
        }
    }
}

