/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.Nullable;
import android.support.v4.util.LruCache;
import android.text.TextUtils;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.JobCat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.vrallev.android.cat.CatLog;

class JobStorage {
    private static final CatLog CAT = new JobCat("JobStorage");
    private static final String JOB_ID_COUNTER = "JOB_ID_COUNTER";
    public static final String PREF_FILE_NAME = "evernote_jobs";
    public static final String DATABASE_NAME = "evernote_jobs.db";
    public static final int DATABASE_VERSION = 2;
    public static final String JOB_TABLE_NAME = "jobs";
    public static final String COLUMN_ID = "_id";
    public static final String COLUMN_TAG = "tag";
    public static final String COLUMN_START_MS = "startMs";
    public static final String COLUMN_END_MS = "endMs";
    public static final String COLUMN_BACKOFF_MS = "backoffMs";
    public static final String COLUMN_BACKOFF_POLICY = "backoffPolicy";
    public static final String COLUMN_INTERVAL_MS = "intervalMs";
    public static final String COLUMN_REQUIREMENTS_ENFORCED = "requirementsEnforced";
    public static final String COLUMN_REQUIRES_CHARGING = "requiresCharging";
    public static final String COLUMN_REQUIRES_DEVICE_IDLE = "requiresDeviceIdle";
    public static final String COLUMN_EXACT = "exact";
    public static final String COLUMN_NETWORK_TYPE = "networkType";
    public static final String COLUMN_EXTRAS = "extras";
    public static final String COLUMN_PERSISTED = "persisted";
    public static final String COLUMN_NUM_FAILURES = "numFailures";
    public static final String COLUMN_SCHEDULED_AT = "scheduledAt";
    public static final String COLUMN_TRANSIENT = "isTransient";
    private static final int CACHE_SIZE = 30;
    private final SharedPreferences mPreferences;
    private final JobCacheId mCacheId;
    private final AtomicInteger mJobCounter;
    private final JobOpenHelper mDbHelper;
    private SQLiteDatabase mDatabase;

    public JobStorage(Context context) {
        this.mPreferences = context.getSharedPreferences(PREF_FILE_NAME, 0);
        this.mCacheId = new JobCacheId();
        int lastJobId = this.mPreferences.getInt(JOB_ID_COUNTER, 0);
        this.mJobCounter = new AtomicInteger(lastJobId);
        this.mDbHelper = new JobOpenHelper(context);
    }

    public synchronized void put(JobRequest request) {
        this.updateRequestInCache(request);
        this.store(request);
    }

    public synchronized void update(JobRequest request, ContentValues contentValues) {
        this.updateRequestInCache(request);
        try {
            this.getDatabase().update(JOB_TABLE_NAME, contentValues, "_id=?", new String[]{String.valueOf(request.getJobId())});
        }
        catch (Exception e) {
            CAT.e((Throwable)e, "could not update %s", new Object[]{request});
        }
    }

    private void updateRequestInCache(JobRequest request) {
        this.mCacheId.put(request.getJobId(), request);
    }

    public synchronized JobRequest get(int id) {
        return (JobRequest)this.mCacheId.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set<JobRequest> getAllJobRequests(@Nullable String tag, boolean includeTransient) {
        HashSet<JobRequest> result = new HashSet<JobRequest>();
        try (Cursor cursor = null;){
            String[] args;
            String where;
            if (TextUtils.isEmpty((CharSequence)tag)) {
                where = includeTransient ? null : "isTransient<=0";
                args = null;
            } else {
                where = includeTransient ? "" : "isTransient<=0 AND ";
                where = where + "tag=?";
                args = new String[]{tag};
            }
            cursor = this.getDatabase().query(JOB_TABLE_NAME, null, where, args, null, null, null);
            HashMap cachedRequests = new HashMap(this.mCacheId.snapshot());
            while (cursor.moveToNext()) {
                Integer id = cursor.getInt(cursor.getColumnIndex(COLUMN_ID));
                if (cachedRequests.containsKey(id)) {
                    result.add((JobRequest)cachedRequests.get(id));
                    continue;
                }
                result.add(JobRequest.fromCursor(cursor));
            }
        }
        return result;
    }

    public synchronized void remove(JobRequest request) {
        this.mCacheId.remove(request.getJobId());
        try {
            this.getDatabase().delete(JOB_TABLE_NAME, "_id=?", new String[]{String.valueOf(request.getJobId())});
        }
        catch (Exception e) {
            CAT.e((Throwable)e, "could not delete %s", new Object[]{request});
        }
    }

    public synchronized int nextJobId() {
        int id = this.mJobCounter.incrementAndGet();
        this.mPreferences.edit().putInt(JOB_ID_COUNTER, id).apply();
        return id;
    }

    private void store(JobRequest request) {
        try {
            ContentValues contentValues = request.toContentValues();
            this.getDatabase().insert(JOB_TABLE_NAME, null, contentValues);
        }
        catch (Exception e) {
            CAT.e((Throwable)e, "could not store %s", new Object[]{request});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobRequest load(int id, boolean includeTransient) {
        try (Cursor cursor = null;){
            String where = "_id=?";
            if (!includeTransient) {
                where = where + " AND isTransient<=0";
            }
            if ((cursor = this.getDatabase().query(JOB_TABLE_NAME, null, where, new String[]{String.valueOf(id)}, null, null, null)).moveToFirst()) {
                JobRequest jobRequest = JobRequest.fromCursor(cursor);
                return jobRequest;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLiteDatabase getDatabase() {
        if (this.mDatabase == null) {
            JobStorage jobStorage = this;
            synchronized (jobStorage) {
                if (this.mDatabase == null) {
                    this.mDatabase = this.mDbHelper.getWritableDatabase();
                }
            }
        }
        return this.mDatabase;
    }

    private class JobOpenHelper
    extends SQLiteOpenHelper {
        public JobOpenHelper(Context context) {
            super(context, JobStorage.DATABASE_NAME, null, 2);
        }

        public void onCreate(SQLiteDatabase db) {
            this.createJobTable(db);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            if (oldVersion == 1 && newVersion == 2) {
                this.upgradeFrom1To2(db);
            }
        }

        private void createJobTable(SQLiteDatabase db) {
            db.execSQL("create table jobs (_id integer primary key, tag text not null, startMs integer, endMs integer, backoffMs integer, backoffPolicy text not null, intervalMs integer, requirementsEnforced integer, requiresCharging integer, requiresDeviceIdle integer, exact integer, networkType text not null, extras text, persisted integer, numFailures integer, scheduledAt integer, isTransient integer);");
        }

        private void upgradeFrom1To2(SQLiteDatabase db) {
            db.execSQL("alter table jobs add column isTransient integer;");
        }
    }

    private class JobCacheId
    extends LruCache<Integer, JobRequest> {
        public JobCacheId() {
            super(30);
        }

        protected JobRequest create(Integer id) {
            return JobStorage.this.load(id, true);
        }
    }
}

