/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.gcm;

import android.content.Context;
import android.support.annotation.NonNull;
import com.evernote.android.job.JobProxy;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.gcm.PlatformGcmService;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.JobUtil;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.OneoffTask;
import com.google.android.gms.gcm.PeriodicTask;
import com.google.android.gms.gcm.Task;
import net.vrallev.android.cat.CatLog;

public class JobProxyGcm
implements JobProxy {
    private static final CatLog CAT = new JobCat("JobProxyGcm");
    private final GcmNetworkManager mGcmNetworkManager;

    public JobProxyGcm(Context context) {
        this.mGcmNetworkManager = GcmNetworkManager.getInstance((Context)context);
    }

    @Override
    public void plantOneOff(JobRequest request) {
        long startSeconds = JobProxy.Common.getStartMs(request) / 1000L;
        long endSeconds = Math.max(JobProxy.Common.getEndMs(request) / 1000L, startSeconds + 1L);
        OneoffTask task = new OneoffTask.Builder().setTag(this.createTag(request)).setService(PlatformGcmService.class).setUpdateCurrent(true).setExecutionWindow(startSeconds, endSeconds).setRequiredNetwork(this.convertNetworkType(request.requiredNetworkType())).setPersisted(request.isPersisted()).setRequiresCharging(request.requiresCharging()).build();
        this.mGcmNetworkManager.schedule((Task)task);
        CAT.d("Scheduled OneoffTask, %s, start %s, end %s", new Object[]{request, JobUtil.timeToString(JobProxy.Common.getStartMs(request)), JobUtil.timeToString(JobProxy.Common.getEndMs(request))});
    }

    @Override
    public void plantPeriodic(JobRequest request) {
        PeriodicTask task = new PeriodicTask.Builder().setTag(this.createTag(request)).setService(PlatformGcmService.class).setUpdateCurrent(true).setPeriod(request.getIntervalMs() / 1000L).setRequiredNetwork(this.convertNetworkType(request.requiredNetworkType())).setPersisted(request.isPersisted()).setRequiresCharging(request.requiresCharging()).build();
        this.mGcmNetworkManager.schedule((Task)task);
        CAT.d("Scheduled PeriodicTask, %s, interval %s", new Object[]{request, JobUtil.timeToString(request.getIntervalMs())});
    }

    @Override
    public void cancel(int jobId) {
        this.mGcmNetworkManager.cancelTask(this.createTag(jobId), PlatformGcmService.class);
    }

    @Override
    public boolean isPlatformJobScheduled(JobRequest request) {
        return true;
    }

    protected String createTag(JobRequest request) {
        return this.createTag(request.getJobId());
    }

    protected String createTag(int jobId) {
        return String.valueOf(jobId);
    }

    protected int convertNetworkType(@NonNull JobRequest.NetworkType networkType) {
        switch (networkType) {
            case ANY: {
                return 2;
            }
            case CONNECTED: {
                return 0;
            }
            case UNMETERED: {
                return 1;
            }
        }
        throw new IllegalStateException("not implemented");
    }
}

