/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import com.evernote.android.job.gcm.PlatformGcmService;
import com.evernote.android.job.util.JobApi;
import com.google.android.gms.common.GoogleApiAvailability;
import java.util.List;
import net.vrallev.android.cat.Cat;

final class GcmAvailableHelper {
    private static final String ACTION_TASK_READY = "com.google.android.gms.gcm.ACTION_TASK_READY";
    private static final String GCM_PERMISSION = "com.google.android.gms.permission.BIND_NETWORK_TASK_SERVICE";
    private static final boolean GCM_IN_CLASSPATH;
    private static int gcmServiceAvailable;

    public static boolean isGcmApiSupported(Context context) {
        try {
            return GCM_IN_CLASSPATH && GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context) == 0 && GcmAvailableHelper.isGcmServiceRegistered(context) == 0;
        }
        catch (Throwable t) {
            Cat.w((Throwable)t);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int isGcmServiceRegistered(Context context) {
        if (gcmServiceAvailable >= 0) return gcmServiceAvailable;
        Class<JobApi> clazz = JobApi.class;
        synchronized (JobApi.class) {
            if (gcmServiceAvailable >= 0) return gcmServiceAvailable;
            Intent intent = new Intent(context, PlatformGcmService.class);
            List resolveInfos = context.getPackageManager().queryIntentServices(intent, 0);
            if (!GcmAvailableHelper.hasPermission(resolveInfos)) {
                gcmServiceAvailable = 1;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return gcmServiceAvailable;
            }
            intent = new Intent(ACTION_TASK_READY);
            intent.setPackage(context.getPackageName());
            resolveInfos = context.getPackageManager().queryIntentServices(intent, 0);
            if (!GcmAvailableHelper.hasPermission(resolveInfos)) {
                gcmServiceAvailable = 1;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return gcmServiceAvailable;
            }
            gcmServiceAvailable = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return gcmServiceAvailable;
        }
    }

    private static boolean hasPermission(List<ResolveInfo> resolveInfos) {
        if (resolveInfos == null || resolveInfos.isEmpty()) {
            return false;
        }
        for (ResolveInfo info : resolveInfos) {
            if (info.serviceInfo == null || !GCM_PERMISSION.equals(info.serviceInfo.permission) || !info.serviceInfo.exported) continue;
            return true;
        }
        return false;
    }

    private GcmAvailableHelper() {
    }

    static {
        boolean gcmInClasspath;
        gcmServiceAvailable = -1;
        try {
            Class.forName("com.google.android.gms.gcm.GcmNetworkManager");
            gcmInClasspath = true;
        }
        catch (Throwable t) {
            gcmInClasspath = false;
        }
        GCM_IN_CLASSPATH = gcmInClasspath;
    }
}

