/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.util;

import android.content.Context;
import android.os.Build;
import com.evernote.android.job.JobProxy;
import com.evernote.android.job.gcm.JobProxyGcm;
import com.evernote.android.job.util.GcmAvailableHelper;
import com.evernote.android.job.v14.JobProxy14;
import com.evernote.android.job.v21.JobProxy21;

public enum JobApi {
    V_21,
    V_14,
    GCM;

    private JobProxy mCachedProxy;

    public boolean isSupported(Context context) {
        switch (this) {
            case V_21: {
                return Build.VERSION.SDK_INT >= 21;
            }
            case V_14: {
                return true;
            }
            case GCM: {
                return GcmAvailableHelper.isGcmApiSupported(context);
            }
        }
        throw new IllegalStateException("not implemented");
    }

    public JobProxy createProxy(Context context) {
        switch (this) {
            case V_21: {
                return new JobProxy21(context);
            }
            case V_14: {
                return new JobProxy14(context);
            }
            case GCM: {
                return new JobProxyGcm(context);
            }
        }
        throw new IllegalStateException("not implemented");
    }

    public synchronized JobProxy getCachedProxy(Context context) {
        if (this.mCachedProxy == null) {
            this.mCachedProxy = this.createProxy(context);
        }
        return this.mCachedProxy;
    }

    public static JobApi getDefault(Context context) {
        if (V_21.isSupported(context)) {
            return V_21;
        }
        if (GCM.isSupported(context)) {
            return GCM;
        }
        return V_14;
    }
}

