/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.v14;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.Nullable;
import com.evernote.android.job.JobProxy;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.JobUtil;
import com.evernote.android.job.v14.PlatformAlarmReceiver;
import net.vrallev.android.cat.CatLog;

public class JobProxy14
implements JobProxy {
    private static final CatLog CAT = new JobCat("JobProxy14");
    private final Context mContext;
    private AlarmManager mAlarmManager;

    public JobProxy14(Context context) {
        this.mContext = context;
    }

    @Override
    public void plantOneOff(JobRequest request) {
        PendingIntent pendingIntent = this.getPendingIntent(request, false);
        this.setAlarm(request, System.currentTimeMillis() + JobProxy.Common.getAverageDelayMs(request), pendingIntent);
        CAT.d("Scheduled alarm, %s, delay %s, exact %b", new Object[]{request, JobUtil.timeToString(JobProxy.Common.getAverageDelayMs(request)), request.isExact()});
    }

    @Override
    public void plantPeriodic(JobRequest request) {
        PendingIntent pendingIntent = this.getPendingIntent(request, true);
        AlarmManager alarmManager = this.getAlarmManager();
        if (alarmManager != null) {
            alarmManager.setRepeating(0, System.currentTimeMillis() + request.getIntervalMs(), request.getIntervalMs(), pendingIntent);
        }
        CAT.d("Scheduled repeating alarm, %s, interval %s", new Object[]{request, JobUtil.timeToString(request.getIntervalMs())});
    }

    @Override
    public void cancel(int jobId) {
        AlarmManager alarmManager = this.getAlarmManager();
        if (alarmManager != null) {
            try {
                alarmManager.cancel(this.getPendingIntent(jobId, this.createPendingIntentFlags(true)));
                alarmManager.cancel(this.getPendingIntent(jobId, this.createPendingIntentFlags(false)));
            }
            catch (Exception e) {
                CAT.e((Throwable)e);
            }
        }
    }

    @Override
    public boolean isPlatformJobScheduled(JobRequest request) {
        PendingIntent pendingIntent = this.getPendingIntent(request, 0x20000000);
        return pendingIntent != null;
    }

    protected int createPendingIntentFlags(boolean repeating) {
        int flags = 0x8000000;
        if (!repeating) {
            flags |= 0x40000000;
        }
        return flags;
    }

    protected PendingIntent getPendingIntent(JobRequest request, boolean repeating) {
        return this.getPendingIntent(request, this.createPendingIntentFlags(repeating));
    }

    protected PendingIntent getPendingIntent(JobRequest request, int flags) {
        return this.getPendingIntent(request.getJobId(), flags);
    }

    protected PendingIntent getPendingIntent(int jobId, int flags) {
        Intent intent = PlatformAlarmReceiver.createIntent(this.mContext, jobId);
        try {
            return PendingIntent.getBroadcast((Context)this.mContext, (int)jobId, (Intent)intent, (int)flags);
        }
        catch (Exception e) {
            CAT.e((Throwable)e);
            return null;
        }
    }

    protected void setAlarm(JobRequest request, long triggerAtMillis, PendingIntent pendingIntent) {
        AlarmManager alarmManager = this.getAlarmManager();
        if (alarmManager == null) {
            return;
        }
        try {
            if (request.isExact()) {
                if (Build.VERSION.SDK_INT >= 23) {
                    alarmManager.setExactAndAllowWhileIdle(0, triggerAtMillis, pendingIntent);
                } else if (Build.VERSION.SDK_INT >= 19) {
                    alarmManager.setExact(0, triggerAtMillis, pendingIntent);
                } else {
                    alarmManager.set(0, triggerAtMillis, pendingIntent);
                }
            } else {
                alarmManager.set(1, triggerAtMillis, pendingIntent);
            }
        }
        catch (Exception e) {
            CAT.e((Throwable)e);
        }
    }

    @Nullable
    protected AlarmManager getAlarmManager() {
        if (this.mAlarmManager == null) {
            this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        }
        if (this.mAlarmManager == null) {
            CAT.e("AlarmManager is null");
        }
        return this.mAlarmManager;
    }
}

