/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.support.v4.content.WakefulBroadcastReceiver;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.Device;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.support.PersistableBundleCompat;
import java.lang.ref.WeakReference;
import net.vrallev.android.cat.CatLog;

public abstract class Job {
    private static final CatLog CAT = new JobCat("Job");
    private Params mParams;
    private WeakReference<Context> mContextReference;
    private Context mApplicationContext;
    private boolean mCanceled;
    private long mFinishedTimeStamp = -1L;
    private Result mResult = Result.FAILURE;

    @NonNull
    @WorkerThread
    protected abstract Result onRunJob(Params var1);

    final Result runJob() {
        try {
            this.mResult = this.meetsRequirements() ? this.onRunJob(this.getParams()) : (this.getParams().isPeriodic() ? Result.FAILURE : Result.RESCHEDULE);
            Result result = this.mResult;
            return result;
        }
        finally {
            this.mFinishedTimeStamp = System.currentTimeMillis();
        }
    }

    @WorkerThread
    protected void onReschedule(int newJobId) {
    }

    private boolean meetsRequirements() {
        if (!this.getParams().getRequest().requirementsEnforced()) {
            return true;
        }
        if (!this.isRequirementChargingMet()) {
            CAT.w("Job requires charging, reschedule");
            return false;
        }
        if (!this.isRequirementDeviceIdleMet()) {
            CAT.w("Job requires device to be idle, reschedule");
            return false;
        }
        if (!this.isRequirementNetworkTypeMet()) {
            CAT.w("Job requires network to be %s, but was %s", new Object[]{this.getParams().getRequest().requiredNetworkType(), Device.getNetworkType(this.getContext())});
            return false;
        }
        return true;
    }

    protected boolean isRequirementChargingMet() {
        return !this.getParams().getRequest().requiresCharging() || Device.isCharging(this.getContext());
    }

    protected boolean isRequirementDeviceIdleMet() {
        return !this.getParams().getRequest().requiresDeviceIdle() || Device.isIdle(this.getContext());
    }

    protected boolean isRequirementNetworkTypeMet() {
        JobRequest.NetworkType requirement = this.getParams().getRequest().requiredNetworkType();
        switch (requirement) {
            case ANY: {
                return true;
            }
            case UNMETERED: {
                JobRequest.NetworkType current = Device.getNetworkType(this.getContext());
                return JobRequest.NetworkType.UNMETERED.equals((Object)current);
            }
            case CONNECTED: {
                JobRequest.NetworkType current = Device.getNetworkType(this.getContext());
                return !JobRequest.NetworkType.ANY.equals((Object)current);
            }
        }
        throw new IllegalStateException("not implemented");
    }

    final Job setRequest(JobRequest request) {
        this.mParams = new Params(request);
        return this;
    }

    @NonNull
    protected final Params getParams() {
        return this.mParams;
    }

    final Job setContext(Context context) {
        this.mContextReference = new WeakReference<Context>(context);
        this.mApplicationContext = context.getApplicationContext();
        return this;
    }

    @NonNull
    protected final Context getContext() {
        Context context = (Context)this.mContextReference.get();
        return context == null ? this.mApplicationContext : context;
    }

    public final void cancel() {
        if (!this.isFinished()) {
            this.mCanceled = true;
        }
    }

    protected final boolean isCanceled() {
        return this.mCanceled;
    }

    public final boolean isFinished() {
        return this.mFinishedTimeStamp > 0L;
    }

    final long getFinishedTimeStamp() {
        return this.mFinishedTimeStamp;
    }

    final Result getResult() {
        return this.mResult;
    }

    protected ComponentName startWakefulService(@NonNull Intent intent) {
        return WakefulBroadcastReceiver.startWakefulService((Context)this.getContext(), (Intent)intent);
    }

    public static boolean completeWakefulIntent(@NonNull Intent intent) {
        try {
            return WakefulBroadcastReceiver.completeWakefulIntent((Intent)intent);
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        return this.mParams.equals(job.mParams);
    }

    public int hashCode() {
        return this.mParams.hashCode();
    }

    public String toString() {
        return "job{id=" + this.mParams.getId() + ", finished=" + this.isFinished() + ", result=" + (Object)((Object)this.mResult) + ", canceled=" + this.mCanceled + ", periodic=" + this.mParams.isPeriodic() + ", class=" + this.getClass().getSimpleName() + ", tag=" + this.mParams.getTag() + '}';
    }

    protected static final class Params {
        private final JobRequest mRequest;
        private PersistableBundleCompat mExtras;

        private Params(@NonNull JobRequest request) {
            this.mRequest = request;
        }

        public int getId() {
            return this.mRequest.getJobId();
        }

        public String getTag() {
            return this.mRequest.getTag();
        }

        public boolean isPeriodic() {
            return this.mRequest.isPeriodic();
        }

        public boolean isExact() {
            return this.mRequest.isExact();
        }

        public boolean isPersisted() {
            return this.mRequest.isPersisted();
        }

        public long getStartMs() {
            return this.mRequest.getStartMs();
        }

        public long getEndMs() {
            return this.mRequest.getEndMs();
        }

        public long getIntervalMs() {
            return this.mRequest.getIntervalMs();
        }

        public long getBackoffMs() {
            return this.mRequest.getBackoffMs();
        }

        public JobRequest.BackoffPolicy getBackoffPolicy() {
            return this.mRequest.getBackoffPolicy();
        }

        public boolean requiresCharging() {
            return this.mRequest.requiresCharging();
        }

        public boolean requiresDeviceIdle() {
            return this.mRequest.requiresDeviceIdle();
        }

        public JobRequest.NetworkType requiredNetworkType() {
            return this.mRequest.requiredNetworkType();
        }

        public boolean requirementsEnforced() {
            return this.mRequest.requirementsEnforced();
        }

        public int getFailureCount() {
            return this.mRequest.getNumFailures();
        }

        @NonNull
        public PersistableBundleCompat getExtras() {
            if (this.mExtras == null) {
                this.mExtras = this.mRequest.getExtras();
                if (this.mExtras == null) {
                    this.mExtras = new PersistableBundleCompat();
                }
            }
            return this.mExtras;
        }

        JobRequest getRequest() {
            return this.mRequest;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Params params = (Params)o;
            return this.mRequest.equals(params.mRequest);
        }

        public int hashCode() {
            return this.mRequest.hashCode();
        }
    }

    public static enum Result {
        SUCCESS,
        FAILURE,
        RESCHEDULE;

    }
}

