/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.PowerManager;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.evernote.android.job.Job;
import com.evernote.android.job.JobCreator;
import com.evernote.android.job.JobCreatorHolder;
import com.evernote.android.job.JobExecutor;
import com.evernote.android.job.JobProxy;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.JobStorage;
import com.evernote.android.job.WakeLockUtil;
import com.evernote.android.job.util.JobApi;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.JobPreconditions;
import com.evernote.android.job.util.JobUtil;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.vrallev.android.cat.Cat;
import net.vrallev.android.cat.CatGlobal;
import net.vrallev.android.cat.CatLog;

public final class JobManager {
    private static final String PACKAGE = JobManager.class.getPackage().getName();
    private static final CatLog CAT = new JobCat("JobManager");
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile JobManager instance;
    private final Context mContext;
    private final JobCreatorHolder mJobCreatorHolder;
    private final JobStorage mJobStorage;
    private final JobExecutor mJobExecutor;
    private JobApi mApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JobManager create(@NonNull Context context) {
        if (instance != null) return instance;
        Class<JobManager> clazz = JobManager.class;
        synchronized (JobManager.class) {
            if (instance != null) return instance;
            JobPreconditions.checkNotNull(context, "Context cannot be null");
            CatGlobal.setDefaultCatLogPackage((String)PACKAGE, (CatLog)new JobCat());
            if (context.getApplicationContext() != null) {
                context = context.getApplicationContext();
            }
            instance = new JobManager(context);
            if (!JobUtil.hasWakeLockPermission(context)) {
                Cat.w((String)"No wake lock permission");
            }
            if (JobUtil.hasBootPermission(context)) return instance;
            Cat.w((String)"No boot permission");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static JobManager create(Context context, JobCreator jobCreator) {
        Class<JobManager> clazz = JobManager.class;
        synchronized (JobManager.class) {
            boolean addJobCreator = instance == null;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            JobManager.create(context);
            if (addJobCreator) {
                instance.addJobCreator(jobCreator);
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JobManager instance() {
        if (instance != null) return instance;
        Class<JobManager> clazz = JobManager.class;
        synchronized (JobManager.class) {
            if (instance != null) return instance;
            throw new IllegalStateException("You need to call create() at least once to create the singleton");
        }
    }

    private JobManager(Context context) {
        this.mContext = context;
        this.mJobCreatorHolder = new JobCreatorHolder();
        this.mJobStorage = new JobStorage(context);
        this.mJobExecutor = new JobExecutor();
        this.setJobProxy(JobApi.getDefault(this.mContext));
        this.rescheduleTasksIfNecessary();
    }

    protected void setJobProxy(JobApi api) {
        this.mApi = api;
    }

    public void schedule(JobRequest request) {
        if (this.mJobCreatorHolder.isEmpty()) {
            CAT.w("you haven't registered a JobCreator with addJobCreator(), it's likely that your job never will be executed");
        }
        if (request.isUpdateCurrent()) {
            this.cancelAllForTag(request.getTag());
        }
        JobProxy.Common.cleanUpOrphanedJob(this.mContext, request.getJobId());
        request.setScheduledAt(System.currentTimeMillis());
        this.mJobStorage.put(request);
        JobProxy proxy = this.getJobProxy(request);
        if (request.isPeriodic()) {
            proxy.plantPeriodic(request);
        } else {
            proxy.plantOneOff(request);
        }
    }

    public JobRequest getJobRequest(int jobId) {
        return this.getJobRequest(jobId, false);
    }

    JobRequest getJobRequest(int jobId, boolean includeTransient) {
        JobRequest jobRequest = this.mJobStorage.get(jobId);
        if (!includeTransient && jobRequest != null && jobRequest.isTransient()) {
            return null;
        }
        return jobRequest;
    }

    @NonNull
    public Set<JobRequest> getAllJobRequests() {
        return this.mJobStorage.getAllJobRequests(null, false);
    }

    public Set<JobRequest> getAllJobRequestsForTag(@NonNull String tag) {
        return this.mJobStorage.getAllJobRequests(tag, false);
    }

    public Job getJob(int jobId) {
        return this.mJobExecutor.getJob(jobId);
    }

    @NonNull
    public Set<Job> getAllJobs() {
        return this.mJobExecutor.getAllJobs();
    }

    @NonNull
    public Set<Job> getAllJobsForTag(@NonNull String tag) {
        return this.mJobExecutor.getAllJobsForTag(tag);
    }

    public void forceApi(@NonNull JobApi api) {
        this.setJobProxy(JobPreconditions.checkNotNull(api));
        CAT.w("Changed API to %s", new Object[]{api});
    }

    public JobApi getApi() {
        return this.mApi;
    }

    public boolean cancel(int jobId) {
        boolean result = this.cancelInner(this.getJobRequest(jobId, true)) | this.cancelInner(this.getJob(jobId));
        JobProxy.Common.cleanUpOrphanedJob(this.mContext, jobId);
        return result;
    }

    public int cancelAll() {
        return this.cancelAllInner(null);
    }

    public int cancelAllForTag(@NonNull String tag) {
        return this.cancelAllInner(tag);
    }

    private boolean cancelInner(@Nullable JobRequest request) {
        if (request != null) {
            CAT.i("Found pending job %s, canceling", new Object[]{request});
            this.getJobProxy(request).cancel(request.getJobId());
            this.getJobStorage().remove(request);
            return true;
        }
        return false;
    }

    private boolean cancelInner(@Nullable Job job) {
        if (job != null && !job.isFinished() && !job.isCanceled()) {
            CAT.i("Cancel running %s", new Object[]{job});
            job.cancel();
            return true;
        }
        return false;
    }

    private int cancelAllInner(@Nullable String tag) {
        int canceled = 0;
        Set<JobRequest> requests = this.mJobStorage.getAllJobRequests(tag, true);
        for (JobRequest request : requests) {
            if (!this.cancelInner(request)) continue;
            ++canceled;
        }
        Set<Job> jobs = TextUtils.isEmpty((CharSequence)tag) ? this.getAllJobs() : this.getAllJobsForTag(tag);
        for (Job job : jobs) {
            if (!this.cancelInner(job)) continue;
            ++canceled;
        }
        return canceled;
    }

    public void setVerbose(boolean verbose) {
        CatGlobal.setPackageEnabled((String)PACKAGE, (boolean)verbose);
    }

    public void addJobCreator(JobCreator jobCreator) {
        this.mJobCreatorHolder.addJobCreator(jobCreator);
    }

    public void removeJobCreator(JobCreator jobCreator) {
        this.mJobCreatorHolder.removeJobCreator(jobCreator);
    }

    JobStorage getJobStorage() {
        return this.mJobStorage;
    }

    JobExecutor getJobExecutor() {
        return this.mJobExecutor;
    }

    JobCreatorHolder getJobCreatorHolder() {
        return this.mJobCreatorHolder;
    }

    Context getContext() {
        return this.mContext;
    }

    private JobProxy getJobProxy(JobRequest request) {
        return request.getJobApi().getCachedProxy(this.mContext);
    }

    private void rescheduleTasksIfNecessary() {
        final PowerManager.WakeLock wakeLock = WakeLockUtil.acquireWakeLock(this.mContext, JobManager.class.getName(), TimeUnit.MINUTES.toMillis(1L));
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SystemClock.sleep((long)10000L);
                    Set<JobRequest> requests = JobManager.this.mJobStorage.getAllJobRequests(null, true);
                    int rescheduledCount = 0;
                    for (JobRequest request : requests) {
                        boolean reschedule;
                        if (request.isTransient()) {
                            Job job = JobManager.this.getJob(request.getJobId());
                            reschedule = job == null;
                        } else {
                            boolean bl = reschedule = !JobManager.this.getJobProxy(request).isPlatformJobScheduled(request);
                        }
                        if (!reschedule) continue;
                        request.cancelAndEdit().build().schedule();
                        ++rescheduledCount;
                    }
                    CAT.d("Reschedule %d jobs of %d jobs", new Object[]{rescheduledCount, requests.size()});
                }
                finally {
                    WakeLockUtil.releaseWakeLock(wakeLock);
                }
            }
        }.start();
    }
}

