/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import android.content.ContentValues;
import android.database.Cursor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.evernote.android.job.JobManager;
import com.evernote.android.job.util.JobApi;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.JobPreconditions;
import com.evernote.android.job.util.JobUtil;
import com.evernote.android.job.util.support.PersistableBundleCompat;
import java.util.concurrent.TimeUnit;
import net.vrallev.android.cat.Cat;
import net.vrallev.android.cat.CatLog;

public final class JobRequest {
    public static final long DEFAULT_BACKOFF_MS = 30000L;
    public static final BackoffPolicy DEFAULT_BACKOFF_POLICY = BackoffPolicy.EXPONENTIAL;
    public static final NetworkType DEFAULT_NETWORK_TYPE = NetworkType.ANY;
    private static final long WINDOW_THRESHOLD_WARNING = 0x2AAAAAAAAAAAAAAAL;
    private static final long WINDOW_THRESHOLD_MAX = 0x5555555555555554L;
    private static final CatLog CAT = new JobCat("JobRequest");
    private final Builder mBuilder;
    private final JobApi mJobApi;
    private int mNumFailures;
    private long mScheduledAt;
    private boolean mTransient;

    private JobRequest(Builder builder) {
        this.mBuilder = builder;
        this.mJobApi = builder.mExact ? JobApi.V_14 : JobManager.instance().getApi();
    }

    public int getJobId() {
        return this.mBuilder.mId;
    }

    @NonNull
    public String getTag() {
        return this.mBuilder.mTag;
    }

    public long getStartMs() {
        return this.mBuilder.mStartMs;
    }

    public long getEndMs() {
        return this.mBuilder.mEndMs;
    }

    public BackoffPolicy getBackoffPolicy() {
        return this.mBuilder.mBackoffPolicy;
    }

    public long getBackoffMs() {
        return this.mBuilder.mBackoffMs;
    }

    public boolean isPeriodic() {
        return this.getIntervalMs() > 0L;
    }

    public long getIntervalMs() {
        return this.mBuilder.mIntervalMs;
    }

    public boolean requirementsEnforced() {
        return this.mBuilder.mRequirementsEnforced;
    }

    public boolean requiresCharging() {
        return this.mBuilder.mRequiresCharging;
    }

    public boolean requiresDeviceIdle() {
        return this.mBuilder.mRequiresDeviceIdle;
    }

    public NetworkType requiredNetworkType() {
        return this.mBuilder.mNetworkType;
    }

    public PersistableBundleCompat getExtras() {
        if (this.mBuilder.mExtras == null && !TextUtils.isEmpty((CharSequence)this.mBuilder.mExtrasXml)) {
            this.mBuilder.mExtras = PersistableBundleCompat.fromXml(this.mBuilder.mExtrasXml);
        }
        return this.mBuilder.mExtras;
    }

    public boolean isPersisted() {
        return this.mBuilder.mPersisted;
    }

    public boolean isUpdateCurrent() {
        return this.mBuilder.mUpdateCurrent;
    }

    public boolean isExact() {
        return this.mBuilder.mExact;
    }

    long getBackoffOffset() {
        long offset;
        if (this.isPeriodic()) {
            return 0L;
        }
        switch (this.getBackoffPolicy()) {
            case LINEAR: {
                offset = (long)this.mNumFailures * this.getBackoffMs();
                break;
            }
            case EXPONENTIAL: {
                if (this.mNumFailures == 0) {
                    offset = 0L;
                    break;
                }
                offset = (long)((double)this.getBackoffMs() * Math.pow(2.0, this.mNumFailures - 1));
                break;
            }
            default: {
                throw new IllegalStateException("not implemented");
            }
        }
        return Math.min(offset, TimeUnit.HOURS.toMillis(5L));
    }

    JobApi getJobApi() {
        return this.mJobApi;
    }

    void setScheduledAt(long timeStamp) {
        this.mScheduledAt = timeStamp;
    }

    long getScheduledAt() {
        return this.mScheduledAt;
    }

    int getNumFailures() {
        return this.mNumFailures;
    }

    boolean isTransient() {
        return this.mTransient;
    }

    public int schedule() {
        JobManager.instance().schedule(this);
        return this.getJobId();
    }

    public Builder cancelAndEdit() {
        JobManager.instance().cancel(this.getJobId());
        Builder builder = new Builder(this, false);
        this.mTransient = false;
        if (!this.isPeriodic()) {
            long offset = System.currentTimeMillis() - this.mScheduledAt;
            long minValue = 1L;
            builder.setExecutionWindow(Math.max(minValue, this.getStartMs() - offset), Math.max(minValue, this.getEndMs() - offset));
        }
        return builder;
    }

    int reschedule(boolean failure) {
        JobRequest newRequest = new Builder(this, true).build();
        if (failure) {
            newRequest.mNumFailures = this.mNumFailures + 1;
        }
        return newRequest.schedule();
    }

    void incNumFailures() {
        ++this.mNumFailures;
        ContentValues contentValues = new ContentValues();
        contentValues.put("numFailures", Integer.valueOf(this.mNumFailures));
        JobManager.instance().getJobStorage().update(this, contentValues);
    }

    void setTransient(boolean isTransient) {
        this.mTransient = isTransient;
        ContentValues contentValues = new ContentValues();
        contentValues.put("isTransient", Boolean.valueOf(this.mTransient));
        JobManager.instance().getJobStorage().update(this, contentValues);
    }

    ContentValues toContentValues() {
        ContentValues contentValues = new ContentValues();
        this.mBuilder.fillContentValues(contentValues);
        contentValues.put("numFailures", Integer.valueOf(this.mNumFailures));
        contentValues.put("scheduledAt", Long.valueOf(this.mScheduledAt));
        contentValues.put("isTransient", Boolean.valueOf(this.mTransient));
        return contentValues;
    }

    static JobRequest fromCursor(Cursor cursor) throws Exception {
        JobRequest request = new Builder(cursor).build();
        request.mNumFailures = cursor.getInt(cursor.getColumnIndex("numFailures"));
        request.mScheduledAt = cursor.getLong(cursor.getColumnIndex("scheduledAt"));
        request.mTransient = cursor.getInt(cursor.getColumnIndex("isTransient")) > 0;
        JobPreconditions.checkArgumentNonnegative(request.mNumFailures, "failure count can't be negative");
        JobPreconditions.checkArgumentNonnegative(request.mScheduledAt, "scheduled at can't be negative");
        return request;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobRequest request = (JobRequest)o;
        return this.mBuilder.equals(request.mBuilder);
    }

    public int hashCode() {
        return this.mBuilder.hashCode();
    }

    public String toString() {
        return "request{id=" + this.getJobId() + ", tag=" + this.getTag() + '}';
    }

    public static enum NetworkType {
        ANY,
        CONNECTED,
        UNMETERED;

    }

    public static enum BackoffPolicy {
        LINEAR,
        EXPONENTIAL;

    }

    public static final class Builder {
        private final int mId;
        private final String mTag;
        private long mStartMs;
        private long mEndMs;
        private long mBackoffMs;
        private BackoffPolicy mBackoffPolicy;
        private long mIntervalMs;
        private boolean mRequirementsEnforced;
        private boolean mRequiresCharging;
        private boolean mRequiresDeviceIdle;
        private boolean mExact;
        private NetworkType mNetworkType;
        private PersistableBundleCompat mExtras;
        private String mExtrasXml;
        private boolean mPersisted;
        private boolean mUpdateCurrent;

        public Builder(@NonNull String tag) {
            this.mTag = JobPreconditions.checkNotEmpty(tag);
            this.mId = JobManager.instance().getJobStorage().nextJobId();
            this.mStartMs = -1L;
            this.mEndMs = -1L;
            this.mBackoffMs = 30000L;
            this.mBackoffPolicy = DEFAULT_BACKOFF_POLICY;
            this.mNetworkType = DEFAULT_NETWORK_TYPE;
        }

        private Builder(JobRequest request, boolean createId) {
            this.mId = createId ? JobManager.instance().getJobStorage().nextJobId() : request.getJobId();
            this.mTag = request.getTag();
            this.mStartMs = request.getStartMs();
            this.mEndMs = request.getEndMs();
            this.mBackoffMs = request.getBackoffMs();
            this.mBackoffPolicy = request.getBackoffPolicy();
            this.mIntervalMs = request.getIntervalMs();
            this.mRequirementsEnforced = request.requirementsEnforced();
            this.mRequiresCharging = request.requiresCharging();
            this.mRequiresDeviceIdle = request.requiresDeviceIdle();
            this.mExact = request.isExact();
            this.mNetworkType = request.requiredNetworkType();
            this.mExtras = ((JobRequest)request).mBuilder.mExtras;
            this.mExtrasXml = ((JobRequest)request).mBuilder.mExtrasXml;
            this.mPersisted = request.isPersisted();
        }

        private Builder(Cursor cursor) throws Exception {
            this.mId = cursor.getInt(cursor.getColumnIndex("_id"));
            this.mTag = cursor.getString(cursor.getColumnIndex("tag"));
            this.mStartMs = cursor.getLong(cursor.getColumnIndex("startMs"));
            this.mEndMs = cursor.getLong(cursor.getColumnIndex("endMs"));
            this.mBackoffMs = cursor.getLong(cursor.getColumnIndex("backoffMs"));
            try {
                this.mBackoffPolicy = BackoffPolicy.valueOf(cursor.getString(cursor.getColumnIndex("backoffPolicy")));
            }
            catch (Throwable t) {
                CAT.e(t);
                this.mBackoffPolicy = DEFAULT_BACKOFF_POLICY;
            }
            this.mIntervalMs = cursor.getLong(cursor.getColumnIndex("intervalMs"));
            this.mRequirementsEnforced = cursor.getInt(cursor.getColumnIndex("requirementsEnforced")) > 0;
            this.mRequiresCharging = cursor.getInt(cursor.getColumnIndex("requiresCharging")) > 0;
            this.mRequiresDeviceIdle = cursor.getInt(cursor.getColumnIndex("requiresDeviceIdle")) > 0;
            this.mExact = cursor.getInt(cursor.getColumnIndex("exact")) > 0;
            try {
                this.mNetworkType = NetworkType.valueOf(cursor.getString(cursor.getColumnIndex("networkType")));
            }
            catch (Throwable t) {
                CAT.e(t);
                this.mNetworkType = DEFAULT_NETWORK_TYPE;
            }
            this.mExtrasXml = cursor.getString(cursor.getColumnIndex("extras"));
            this.mPersisted = cursor.getInt(cursor.getColumnIndex("persisted")) > 0;
        }

        private void fillContentValues(ContentValues contentValues) {
            contentValues.put("_id", Integer.valueOf(this.mId));
            contentValues.put("tag", this.mTag);
            contentValues.put("startMs", Long.valueOf(this.mStartMs));
            contentValues.put("endMs", Long.valueOf(this.mEndMs));
            contentValues.put("backoffMs", Long.valueOf(this.mBackoffMs));
            contentValues.put("backoffPolicy", this.mBackoffPolicy.toString());
            contentValues.put("intervalMs", Long.valueOf(this.mIntervalMs));
            contentValues.put("requirementsEnforced", Boolean.valueOf(this.mRequirementsEnforced));
            contentValues.put("requiresCharging", Boolean.valueOf(this.mRequiresCharging));
            contentValues.put("requiresDeviceIdle", Boolean.valueOf(this.mRequiresDeviceIdle));
            contentValues.put("exact", Boolean.valueOf(this.mExact));
            contentValues.put("networkType", this.mNetworkType.toString());
            if (this.mExtras != null) {
                contentValues.put("extras", this.mExtras.saveToXml());
            } else if (!TextUtils.isEmpty((CharSequence)this.mExtrasXml)) {
                contentValues.put("extras", this.mExtrasXml);
            }
            contentValues.put("persisted", Boolean.valueOf(this.mPersisted));
        }

        public Builder setExecutionWindow(long startMs, long endMs) {
            this.mStartMs = JobPreconditions.checkArgumentPositive(startMs, "startMs must be greater than 0");
            this.mEndMs = JobPreconditions.checkArgumentInRange(endMs, startMs, Long.MAX_VALUE, "endMs");
            if (this.mStartMs > 0x5555555555555554L) {
                Cat.i((String)"startMs reduced from %d days to %d days", (Object[])new Object[]{TimeUnit.MILLISECONDS.toDays(this.mStartMs), TimeUnit.MILLISECONDS.toDays(0x5555555555555554L)});
                this.mStartMs = 0x5555555555555554L;
            }
            if (this.mEndMs > 0x5555555555555554L) {
                Cat.i((String)"endMs reduced from %d days to %d days", (Object[])new Object[]{TimeUnit.MILLISECONDS.toDays(this.mEndMs), TimeUnit.MILLISECONDS.toDays(0x5555555555555554L)});
                this.mEndMs = 0x5555555555555554L;
            }
            return this;
        }

        public Builder setExtras(@Nullable PersistableBundleCompat extras) {
            if (extras == null) {
                this.mExtras = null;
                this.mExtrasXml = null;
            } else {
                this.mExtras = new PersistableBundleCompat(extras);
            }
            return this;
        }

        public Builder setRequirementsEnforced(boolean enforced) {
            this.mRequirementsEnforced = enforced;
            return this;
        }

        public Builder setRequiredNetworkType(@Nullable NetworkType networkType) {
            this.mNetworkType = networkType;
            return this;
        }

        public Builder setRequiresCharging(boolean requiresCharging) {
            this.mRequiresCharging = requiresCharging;
            return this;
        }

        public Builder setRequiresDeviceIdle(boolean requiresDeviceIdle) {
            this.mRequiresDeviceIdle = requiresDeviceIdle;
            return this;
        }

        public Builder setExact(long exactMs) {
            this.mExact = true;
            if (exactMs > 0x5555555555555554L) {
                Cat.i((String)"exactMs clamped from %d days to %d days", (Object[])new Object[]{TimeUnit.MILLISECONDS.toDays(exactMs), TimeUnit.MILLISECONDS.toDays(0x5555555555555554L)});
                exactMs = 0x5555555555555554L;
            }
            return this.setExecutionWindow(exactMs, exactMs);
        }

        public Builder setPeriodic(long intervalMs) {
            this.mIntervalMs = JobPreconditions.checkArgumentInRange(intervalMs, 60000L, Long.MAX_VALUE, "intervalMs");
            return this;
        }

        public Builder setBackoffCriteria(long backoffMs, @NonNull BackoffPolicy backoffPolicy) {
            this.mBackoffMs = JobPreconditions.checkArgumentPositive(backoffMs, "backoffMs must be > 0");
            this.mBackoffPolicy = JobPreconditions.checkNotNull(backoffPolicy);
            return this;
        }

        public Builder setPersisted(boolean persisted) {
            if (persisted && !JobUtil.hasBootPermission(JobManager.instance().getContext())) {
                throw new IllegalStateException("Does not have RECEIVE_BOOT_COMPLETED permission, which is mandatory for this feature");
            }
            this.mPersisted = persisted;
            return this;
        }

        public Builder setUpdateCurrent(boolean updateCurrent) {
            this.mUpdateCurrent = updateCurrent;
            return this;
        }

        public JobRequest build() {
            JobPreconditions.checkArgumentNonnegative(this.mId, "id can't be negative");
            JobPreconditions.checkNotEmpty(this.mTag);
            JobPreconditions.checkArgumentPositive(this.mBackoffMs, "backoffMs must be > 0");
            JobPreconditions.checkNotNull(this.mBackoffPolicy);
            JobPreconditions.checkNotNull(this.mNetworkType);
            if (this.mIntervalMs > 0L) {
                JobPreconditions.checkArgumentInRange(this.mIntervalMs, 60000L, Long.MAX_VALUE, "intervalMs");
            }
            if (this.mExact && this.mIntervalMs > 0L) {
                throw new IllegalArgumentException("Can't call setExact() on a periodic job.");
            }
            if (this.mExact && this.mStartMs != this.mEndMs) {
                throw new IllegalArgumentException("Can't call setExecutionWindow() for an exact job.");
            }
            if (this.mExact && (this.mRequirementsEnforced || this.mRequiresDeviceIdle || this.mRequiresCharging || !DEFAULT_NETWORK_TYPE.equals((Object)this.mNetworkType))) {
                throw new IllegalArgumentException("Can't require any condition for an exact job.");
            }
            if (this.mIntervalMs <= 0L && (this.mStartMs == -1L || this.mEndMs == -1L)) {
                throw new IllegalArgumentException("You're trying to build a job with no constraints, this is not allowed.");
            }
            if (this.mIntervalMs > 0L && (this.mStartMs != -1L || this.mEndMs != -1L)) {
                throw new IllegalArgumentException("Can't call setExecutionWindow() on a periodic job.");
            }
            if (!(this.mIntervalMs <= 0L || this.mBackoffMs == 30000L && DEFAULT_BACKOFF_POLICY.equals((Object)this.mBackoffPolicy))) {
                throw new IllegalArgumentException("A periodic job will not respect any back-off policy, so calling setBackoffCriteria() with setPeriodic() is an error.");
            }
            if (this.mIntervalMs <= 0L && (this.mStartMs > 0x2AAAAAAAAAAAAAAAL || this.mEndMs > 0x2AAAAAAAAAAAAAAAL)) {
                Cat.w((String)"Attention: your execution window is too large. This could result in undesired behavior, see https://github.com/evernote/android-job/blob/master/FAQ.md");
            }
            return new JobRequest(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            return this.mId == builder.mId;
        }

        public int hashCode() {
            return this.mId;
        }
    }
}

