/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import android.content.Context;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.JobUtil;
import net.vrallev.android.cat.CatLog;

final class WakeLockUtil {
    private static final CatLog CAT = new JobCat("WakeLockUtil");

    private WakeLockUtil() {
    }

    @Nullable
    public static PowerManager.WakeLock acquireWakeLock(@NonNull Context context, @NonNull String tag, long timeoutMillis) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        PowerManager.WakeLock wakeLock = powerManager.newWakeLock(1, tag);
        wakeLock.setReferenceCounted(false);
        return WakeLockUtil.acquireWakeLock(context, wakeLock, timeoutMillis) ? wakeLock : null;
    }

    public static boolean acquireWakeLock(@NonNull Context context, @Nullable PowerManager.WakeLock wakeLock, long timeoutMillis) {
        if (wakeLock != null && !wakeLock.isHeld() && JobUtil.hasWakeLockPermission(context)) {
            try {
                wakeLock.acquire(timeoutMillis);
                return true;
            }
            catch (Exception e) {
                CAT.e((Throwable)e);
            }
        }
        return false;
    }

    public static void releaseWakeLock(@Nullable PowerManager.WakeLock wakeLock) {
        try {
            if (wakeLock != null && wakeLock.isHeld()) {
                wakeLock.release();
            }
        }
        catch (Exception e) {
            CAT.e((Throwable)e);
        }
    }
}

