/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.PowerManager;
import android.support.v4.net.ConnectivityManagerCompat;
import com.evernote.android.job.JobRequest;

public final class Device {
    private Device() {
    }

    @TargetApi(value=17)
    public static boolean isCharging(Context context) {
        Intent intent = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        if (intent == null) {
            return false;
        }
        int plugged = intent.getIntExtra("plugged", 0);
        return plugged == 1 || plugged == 2 || Build.VERSION.SDK_INT >= 17 && plugged == 4;
    }

    public static boolean isIdle(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (Build.VERSION.SDK_INT >= 23) {
            return powerManager.isDeviceIdleMode() || !powerManager.isInteractive();
        }
        if (Build.VERSION.SDK_INT >= 20) {
            return !powerManager.isInteractive();
        }
        return !powerManager.isScreenOn();
    }

    public static JobRequest.NetworkType getNetworkType(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnectedOrConnecting()) {
            return JobRequest.NetworkType.ANY;
        }
        boolean metered = ConnectivityManagerCompat.isActiveNetworkMetered((ConnectivityManager)connectivityManager);
        return metered ? JobRequest.NetworkType.CONNECTED : JobRequest.NetworkType.UNMETERED;
    }
}

