/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.v21;

import android.annotation.TargetApi;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.support.annotation.NonNull;
import com.evernote.android.job.JobProxy;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.JobUtil;
import com.evernote.android.job.v21.PlatformJobService;
import java.util.List;
import net.vrallev.android.cat.CatLog;

@TargetApi(value=21)
public class JobProxy21
implements JobProxy {
    private static final CatLog CAT = new JobCat("JobProxy21");
    private final Context mContext;

    public JobProxy21(Context context) {
        this.mContext = context;
    }

    @Override
    public void plantOneOff(JobRequest request) {
        int scheduleResult;
        JobInfo jobInfo = this.createBaseBuilder(request).setMinimumLatency(JobProxy.Common.getStartMs(request)).setOverrideDeadline(JobProxy.Common.getEndMs(request)).setRequiresCharging(request.requiresCharging()).setRequiresDeviceIdle(request.requiresDeviceIdle()).setRequiredNetworkType(this.convertNetworkType(request.requiredNetworkType())).setPersisted(request.isPersisted()).build();
        try {
            scheduleResult = this.getJobScheduler().schedule(jobInfo);
        }
        catch (Exception e) {
            CAT.e((Throwable)e);
            scheduleResult = 0;
        }
        CAT.d("Schedule one-off jobInfo %s, %s, start %s, end %s", new Object[]{scheduleResult == 1 ? "success" : "failure", request, JobUtil.timeToString(JobProxy.Common.getStartMs(request)), JobUtil.timeToString(JobProxy.Common.getEndMs(request))});
    }

    @Override
    public void plantPeriodic(JobRequest request) {
        int scheduleResult;
        JobInfo jobInfo = this.createBaseBuilder(request).setPeriodic(request.getIntervalMs()).setRequiresCharging(request.requiresCharging()).setRequiresDeviceIdle(request.requiresDeviceIdle()).setRequiredNetworkType(this.convertNetworkType(request.requiredNetworkType())).setPersisted(request.isPersisted()).build();
        try {
            scheduleResult = this.getJobScheduler().schedule(jobInfo);
        }
        catch (Exception e) {
            CAT.e((Throwable)e);
            scheduleResult = 0;
        }
        CAT.d("Schedule periodic jobInfo %s, %s, interval %s", new Object[]{scheduleResult == 1 ? "success" : "failure", request, JobUtil.timeToString(request.getIntervalMs())});
    }

    @Override
    public void cancel(int jobId) {
        try {
            this.getJobScheduler().cancel(jobId);
        }
        catch (Exception e) {
            CAT.e((Throwable)e);
        }
    }

    @Override
    public boolean isPlatformJobScheduled(JobRequest request) {
        List pendingJobs;
        try {
            pendingJobs = this.getJobScheduler().getAllPendingJobs();
        }
        catch (Exception e) {
            CAT.e((Throwable)e);
            return false;
        }
        if (pendingJobs == null || pendingJobs.isEmpty()) {
            return false;
        }
        int requestId = request.getJobId();
        for (JobInfo info : pendingJobs) {
            if (info.getId() != requestId) continue;
            return true;
        }
        return false;
    }

    protected JobInfo.Builder createBaseBuilder(JobRequest request) {
        return new JobInfo.Builder(request.getJobId(), new ComponentName(this.mContext, PlatformJobService.class));
    }

    protected int convertNetworkType(@NonNull JobRequest.NetworkType networkType) {
        switch (networkType) {
            case ANY: {
                return 0;
            }
            case CONNECTED: {
                return 1;
            }
            case UNMETERED: {
                return 2;
            }
        }
        throw new IllegalStateException("not implemented");
    }

    protected final JobScheduler getJobScheduler() {
        return (JobScheduler)this.mContext.getSystemService("jobscheduler");
    }
}

