/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import com.evernote.android.job.Job;
import com.evernote.android.job.JobConfig;
import com.evernote.android.job.JobManager;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.support.PersistableBundleCompat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

public abstract class DailyJob
extends Job {
    private static final JobCat CAT = new JobCat("DailyJob");
    @VisibleForTesting
    static final String EXTRA_START_MS = "EXTRA_START_MS";
    @VisibleForTesting
    static final String EXTRA_END_MS = "EXTRA_END_MS";
    @VisibleForTesting
    private static final String EXTRA_ONCE = "EXTRA_ONCE";
    private static final long DAY = TimeUnit.DAYS.toMillis(1L);

    public static int schedule(@NonNull JobRequest.Builder baseBuilder, long startMs, long endMs) {
        return DailyJob.schedule(baseBuilder, true, startMs, endMs);
    }

    public static int startNowOnce(@NonNull JobRequest.Builder baseBuilder) {
        PersistableBundleCompat extras = new PersistableBundleCompat();
        extras.putBoolean(EXTRA_ONCE, true);
        return baseBuilder.startNow().addExtras(extras).build().schedule();
    }

    private static int schedule(@NonNull JobRequest.Builder builder, boolean newJob, long startMs, long endMs) {
        if (startMs >= DAY || endMs >= DAY || startMs < 0L || endMs < 0L) {
            throw new IllegalArgumentException("startMs or endMs should be less than one day (in milliseconds)");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(JobConfig.getClock().currentTimeMillis());
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        long startDelay = TimeUnit.SECONDS.toMillis(60 - second) + TimeUnit.MINUTES.toMillis(60 - minute) + TimeUnit.HOURS.toMillis((24 - hour) % 24) - TimeUnit.HOURS.toMillis(1L) - TimeUnit.MINUTES.toMillis(1L) + TimeUnit.DAYS.toMillis(1L);
        startDelay = (startDelay + startMs) % TimeUnit.DAYS.toMillis(1L);
        if (startMs > endMs) {
            endMs += TimeUnit.DAYS.toMillis(1L);
        }
        long endDelay = startDelay + (endMs - startMs);
        PersistableBundleCompat extras = new PersistableBundleCompat();
        extras.putLong(EXTRA_START_MS, startMs);
        extras.putLong(EXTRA_END_MS, endMs);
        builder.addExtras(extras);
        if (newJob) {
            JobManager manager = JobManager.instance();
            HashSet<JobRequest> requests = new HashSet<JobRequest>(manager.getAllJobRequestsForTag(builder.mTag));
            for (JobRequest request : requests) {
                if (request.isExact() && request.getStartMs() == 1L) continue;
                manager.cancel(request.getJobId());
            }
        }
        JobRequest request = builder.setExecutionWindow(Math.max(1L, startDelay), Math.max(1L, endDelay)).build();
        if (newJob && (request.isExact() || request.isPeriodic() || request.isTransient())) {
            throw new IllegalArgumentException("Daily jobs cannot be exact, periodic or transient");
        }
        return request.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    protected final Job.Result onRunJob(@NonNull Job.Params params) {
        block12: {
            JobRequest request;
            block13: {
                PersistableBundleCompat extras = params.getExtras();
                boolean runOnce = extras.getBoolean(EXTRA_ONCE, false);
                if (!(runOnce || extras.containsKey(EXTRA_START_MS) && extras.containsKey(EXTRA_END_MS))) {
                    CAT.e("Daily job doesn't contain start and end time");
                    return Job.Result.FAILURE;
                }
                DailyJobResult result = null;
                try {
                    if (this.meetsRequirements(true)) {
                        result = this.onRunDailyJob(params);
                    } else {
                        result = DailyJobResult.SUCCESS;
                        CAT.i("Daily job requirements not met, reschedule for the next day");
                    }
                    if (result == null) {
                        result = DailyJobResult.SUCCESS;
                        CAT.e("Daily job result was null");
                    }
                    if (runOnce) break block12;
                    request = params.getRequest();
                    if (result != DailyJobResult.SUCCESS) break block13;
                }
                catch (Throwable throwable) {
                    if (result == null) {
                        result = DailyJobResult.SUCCESS;
                        CAT.e("Daily job result was null");
                    }
                    if (!runOnce) {
                        JobRequest request2 = params.getRequest();
                        if (result == DailyJobResult.SUCCESS) {
                            CAT.i("Rescheduling daily job %s", request2);
                            int newJobId = DailyJob.schedule(request2.createBuilder(), false, extras.getLong(EXTRA_START_MS, 0L) % DAY, extras.getLong(EXTRA_END_MS, 0L) % DAY);
                            request2 = JobManager.instance().getJobRequest(newJobId);
                            if (request2 != null) {
                                request2.updateStats(false, true);
                            }
                        } else {
                            CAT.i("Cancel daily job %s", request2);
                        }
                    }
                    throw throwable;
                }
                CAT.i("Rescheduling daily job %s", request);
                int newJobId = DailyJob.schedule(request.createBuilder(), false, extras.getLong(EXTRA_START_MS, 0L) % DAY, extras.getLong(EXTRA_END_MS, 0L) % DAY);
                request = JobManager.instance().getJobRequest(newJobId);
                if (request != null) {
                    request.updateStats(false, true);
                }
                break block12;
            }
            CAT.i("Cancel daily job %s", request);
        }
        return Job.Result.SUCCESS;
    }

    @NonNull
    @WorkerThread
    protected abstract DailyJobResult onRunDailyJob(@NonNull Job.Params var1);

    public static enum DailyJobResult {
        SUCCESS,
        CANCEL;

    }
}

