/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.LruCache;
import android.util.SparseArray;
import com.evernote.android.job.Job;
import com.evernote.android.job.JobConfig;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.WakeLockUtil;
import com.evernote.android.job.util.JobCat;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class JobExecutor {
    private static final JobCat CAT = new JobCat("JobExecutor");
    private static final long WAKE_LOCK_TIMEOUT = TimeUnit.MINUTES.toMillis(3L);
    private final SparseArray<Job> mJobs = new SparseArray();
    private final LruCache<Integer, WeakReference<Job>> mFinishedJobsCache = new LruCache(20);
    private final SparseArray<Job.Result> mFinishedJobResults = new SparseArray();
    private final Set<JobRequest> mStartingRequests = new HashSet<JobRequest>();

    public synchronized Future<Job.Result> execute(@NonNull Context context, @NonNull JobRequest request, @Nullable Job job, @NonNull Bundle transientExtras) {
        this.mStartingRequests.remove(request);
        if (job == null) {
            CAT.w("JobCreator returned null for tag %s", request.getTag());
            return null;
        }
        if (job.isFinished()) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Job for tag %s was already run, a creator should always create a new Job instance", request.getTag()));
        }
        job.setContext(context).setRequest(request, transientExtras);
        CAT.i("Executing %s, context %s", request, context.getClass().getSimpleName());
        this.mJobs.put(request.getJobId(), (Object)job);
        return JobConfig.getExecutorService().submit(new JobCallable(job));
    }

    public synchronized Job getJob(int jobId) {
        Job job = (Job)this.mJobs.get(jobId);
        if (job != null) {
            return job;
        }
        WeakReference reference = (WeakReference)this.mFinishedJobsCache.get((Object)jobId);
        return reference != null ? (Job)reference.get() : null;
    }

    public synchronized Set<Job> getAllJobs() {
        return this.getAllJobsForTag(null);
    }

    public synchronized Set<Job> getAllJobsForTag(String tag) {
        HashSet<Job> result = new HashSet<Job>();
        for (int i = 0; i < this.mJobs.size(); ++i) {
            Job job = (Job)this.mJobs.valueAt(i);
            if (tag != null && !tag.equals(job.getParams().getTag())) continue;
            result.add(job);
        }
        Map snapshot = this.mFinishedJobsCache.snapshot();
        for (WeakReference reference : snapshot.values()) {
            Job job = (Job)reference.get();
            if (job == null || tag != null && !tag.equals(job.getParams().getTag())) continue;
            result.add(job);
        }
        return result;
    }

    public SparseArray<Job.Result> getAllJobResults() {
        return this.mFinishedJobResults.clone();
    }

    public synchronized void markJobRequestStarting(@NonNull JobRequest request) {
        this.mStartingRequests.add(request);
    }

    public synchronized boolean isRequestStarting(JobRequest request) {
        return request != null && this.mStartingRequests.contains(request);
    }

    @VisibleForTesting
    synchronized void markJobAsFinished(Job job) {
        int id = job.getParams().getId();
        this.mJobs.remove(id);
        this.cleanUpRoutine(this.mFinishedJobsCache);
        this.mFinishedJobResults.put(id, (Object)job.getResult());
        this.mFinishedJobsCache.put((Object)id, new WeakReference<Job>(job));
    }

    @VisibleForTesting
    @SuppressLint(value={"UseSparseArrays"})
    void cleanUpRoutine(LruCache<Integer, WeakReference<Job>> cache) {
        HashMap snapshot = new HashMap(cache.snapshot());
        for (Integer key : snapshot.keySet()) {
            if (snapshot.get(key) != null && ((WeakReference)snapshot.get(key)).get() != null) continue;
            cache.remove((Object)key);
        }
    }

    private final class JobCallable
    implements Callable<Job.Result> {
        private final Job mJob;
        private final PowerManager.WakeLock mWakeLock;

        private JobCallable(Job job) {
            this.mJob = job;
            Context context = this.mJob.getContext();
            this.mWakeLock = WakeLockUtil.acquireWakeLock(context, "JobExecutor", WAKE_LOCK_TIMEOUT);
        }

        @Override
        public Job.Result call() throws Exception {
            Job.Result result;
            try {
                WakeLockUtil.acquireWakeLock(this.mJob.getContext(), this.mWakeLock, WAKE_LOCK_TIMEOUT);
                result = this.runJob();
                JobExecutor.this.markJobAsFinished(this.mJob);
            }
            catch (Throwable throwable) {
                JobExecutor.this.markJobAsFinished(this.mJob);
                if (this.mWakeLock == null || !this.mWakeLock.isHeld()) {
                    CAT.w("Wake lock was not held after job %s was done. The job took too long to complete. This could have unintended side effects on your app.", this.mJob);
                }
                WakeLockUtil.releaseWakeLock(this.mWakeLock);
                throw throwable;
            }
            if (this.mWakeLock == null || !this.mWakeLock.isHeld()) {
                CAT.w("Wake lock was not held after job %s was done. The job took too long to complete. This could have unintended side effects on your app.", this.mJob);
            }
            WakeLockUtil.releaseWakeLock(this.mWakeLock);
            return result;
        }

        private Job.Result runJob() {
            Job.Result result;
            try {
                result = this.mJob.runJob();
                CAT.i("Finished %s", this.mJob);
                this.handleResult(this.mJob, result);
            }
            catch (Throwable t) {
                CAT.e(t, "Crashed %s", this.mJob);
                result = this.mJob.getResult();
            }
            return result;
        }

        private void handleResult(Job job, Job.Result result) {
            JobRequest request = this.mJob.getParams().getRequest();
            boolean incFailureCount = false;
            boolean updateLastRun = false;
            if (!request.isPeriodic() && Job.Result.RESCHEDULE.equals((Object)result) && !job.isDeleted()) {
                request = request.reschedule(true, true);
                this.mJob.onReschedule(request.getJobId());
                updateLastRun = true;
            } else if (request.isPeriodic()) {
                updateLastRun = true;
                if (!Job.Result.SUCCESS.equals((Object)result)) {
                    incFailureCount = true;
                }
            }
            if (!job.isDeleted() && (incFailureCount || updateLastRun)) {
                request.updateStats(incFailureCount, updateLastRun);
            }
        }
    }
}

