/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.JobUtil;
import java.util.concurrent.TimeUnit;

final class WakeLockUtil {
    private static final JobCat CAT = new JobCat("WakeLockUtil");
    private static final String EXTRA_WAKE_LOCK_ID = "com.evernote.android.job.wakelockid";
    private static final SparseArray<PowerManager.WakeLock> ACTIVE_WAKE_LOCKS = new SparseArray();
    private static int nextId = 1;

    private WakeLockUtil() {
    }

    @Nullable
    static PowerManager.WakeLock acquireWakeLock(@NonNull Context context, @NonNull String tag, long timeoutMillis) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        PowerManager.WakeLock wakeLock = powerManager.newWakeLock(1, tag);
        wakeLock.setReferenceCounted(false);
        return WakeLockUtil.acquireWakeLock(context, wakeLock, timeoutMillis) ? wakeLock : null;
    }

    static boolean acquireWakeLock(@NonNull Context context, @Nullable PowerManager.WakeLock wakeLock, long timeoutMillis) {
        if (wakeLock != null && !wakeLock.isHeld() && JobUtil.hasWakeLockPermission(context)) {
            try {
                wakeLock.acquire(timeoutMillis);
                return true;
            }
            catch (Exception e) {
                CAT.e(e);
            }
        }
        return false;
    }

    static void releaseWakeLock(@Nullable PowerManager.WakeLock wakeLock) {
        try {
            if (wakeLock != null && wakeLock.isHeld()) {
                wakeLock.release();
            }
        }
        catch (Exception e) {
            CAT.e(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentName startWakefulService(Context context, Intent intent) {
        SparseArray<PowerManager.WakeLock> sparseArray = ACTIVE_WAKE_LOCKS;
        synchronized (sparseArray) {
            int id = nextId++;
            if (nextId <= 0) {
                nextId = 1;
            }
            intent.putExtra(EXTRA_WAKE_LOCK_ID, id);
            ComponentName comp = context.startService(intent);
            if (comp == null) {
                return null;
            }
            String tag = "wake:" + comp.flattenToShortString();
            PowerManager.WakeLock wakeLock = WakeLockUtil.acquireWakeLock(context, tag, TimeUnit.MINUTES.toMillis(3L));
            if (wakeLock != null) {
                ACTIVE_WAKE_LOCKS.put(id, (Object)wakeLock);
            }
            return comp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean completeWakefulIntent(Intent intent) {
        if (intent == null) {
            return false;
        }
        int id = intent.getIntExtra(EXTRA_WAKE_LOCK_ID, 0);
        if (id == 0) {
            return false;
        }
        SparseArray<PowerManager.WakeLock> sparseArray = ACTIVE_WAKE_LOCKS;
        synchronized (sparseArray) {
            WakeLockUtil.releaseWakeLock((PowerManager.WakeLock)ACTIVE_WAKE_LOCKS.get(id));
            ACTIVE_WAKE_LOCKS.remove(id);
            return true;
        }
    }
}

