/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.gcm;

import android.content.Context;
import android.support.annotation.NonNull;
import com.evernote.android.job.JobProxy;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.gcm.PlatformGcmService;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.JobUtil;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.OneoffTask;
import com.google.android.gms.gcm.PeriodicTask;
import com.google.android.gms.gcm.Task;

public class JobProxyGcm
implements JobProxy {
    private static final JobCat CAT = new JobCat("JobProxyGcm");
    private final Context mContext;
    private final GcmNetworkManager mGcmNetworkManager;

    public JobProxyGcm(Context context) {
        this.mContext = context;
        this.mGcmNetworkManager = GcmNetworkManager.getInstance((Context)context);
    }

    @Override
    public void plantOneOff(JobRequest request) {
        long startMs = JobProxy.Common.getStartMs(request);
        long startSeconds = startMs / 1000L;
        long endMs = JobProxy.Common.getEndMs(request);
        long endSeconds = Math.max(endMs / 1000L, startSeconds + 1L);
        OneoffTask task = this.prepareBuilder(new OneoffTask.Builder(), request).setExecutionWindow(startSeconds, endSeconds).build();
        this.mGcmNetworkManager.schedule((Task)task);
        CAT.d("Scheduled OneoffTask, %s, start %s, end %s (from now), reschedule count %d", request, JobUtil.timeToString(startMs), JobUtil.timeToString(endMs), JobProxy.Common.getRescheduleCount(request));
    }

    @Override
    public void plantPeriodic(JobRequest request) {
        PeriodicTask task = this.prepareBuilder(new PeriodicTask.Builder(), request).setPeriod(request.getIntervalMs() / 1000L).setFlex(request.getFlexMs() / 1000L).build();
        this.mGcmNetworkManager.schedule((Task)task);
        CAT.d("Scheduled PeriodicTask, %s, interval %s, flex %s", request, JobUtil.timeToString(request.getIntervalMs()), JobUtil.timeToString(request.getFlexMs()));
    }

    @Override
    public void plantPeriodicFlexSupport(JobRequest request) {
        CAT.w("plantPeriodicFlexSupport called although flex is supported");
        long startMs = JobProxy.Common.getStartMsSupportFlex(request);
        long endMs = JobProxy.Common.getEndMsSupportFlex(request);
        OneoffTask task = this.prepareBuilder(new OneoffTask.Builder(), request).setExecutionWindow(startMs / 1000L, endMs / 1000L).build();
        this.mGcmNetworkManager.schedule((Task)task);
        CAT.d("Scheduled periodic (flex support), %s, start %s, end %s, flex %s", request, JobUtil.timeToString(startMs), JobUtil.timeToString(endMs), JobUtil.timeToString(request.getFlexMs()));
    }

    @Override
    public void cancel(int jobId) {
        this.mGcmNetworkManager.cancelTask(this.createTag(jobId), PlatformGcmService.class);
    }

    @Override
    public boolean isPlatformJobScheduled(JobRequest request) {
        return true;
    }

    protected <T extends Task.Builder> T prepareBuilder(T builder, JobRequest request) {
        builder.setTag(this.createTag(request)).setService(PlatformGcmService.class).setUpdateCurrent(true).setRequiredNetwork(this.convertNetworkType(request.requiredNetworkType())).setPersisted(JobUtil.hasBootPermission(this.mContext)).setRequiresCharging(request.requiresCharging()).setExtras(request.getTransientExtras());
        return builder;
    }

    protected String createTag(JobRequest request) {
        return this.createTag(request.getJobId());
    }

    protected String createTag(int jobId) {
        return String.valueOf(jobId);
    }

    protected int convertNetworkType(@NonNull JobRequest.NetworkType networkType) {
        switch (networkType) {
            case ANY: {
                return 2;
            }
            case CONNECTED: {
                return 0;
            }
            case UNMETERED: {
                return 1;
            }
            case NOT_ROAMING: {
                return 1;
            }
        }
        throw new IllegalStateException("not implemented");
    }
}

