/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.support.v4.net.ConnectivityManagerCompat;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.BatteryStatus;

public final class Device {
    private Device() {
    }

    @TargetApi(value=17)
    public static BatteryStatus getBatteryStatus(Context context) {
        Intent intent = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        if (intent == null) {
            return BatteryStatus.DEFAULT;
        }
        int level = intent.getIntExtra("level", -1);
        int scale = intent.getIntExtra("scale", -1);
        float batteryPct = (float)level / (float)scale;
        int plugged = intent.getIntExtra("plugged", 0);
        boolean charging = plugged == 1 || plugged == 2 || Build.VERSION.SDK_INT >= 17 && plugged == 4;
        return new BatteryStatus(charging, batteryPct);
    }

    public static boolean isIdle(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (Build.VERSION.SDK_INT >= 23) {
            return powerManager.isDeviceIdleMode() || !powerManager.isInteractive();
        }
        if (Build.VERSION.SDK_INT >= 20) {
            return !powerManager.isInteractive();
        }
        return !powerManager.isScreenOn();
    }

    @NonNull
    public static JobRequest.NetworkType getNetworkType(@NonNull Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnectedOrConnecting()) {
            return JobRequest.NetworkType.ANY;
        }
        boolean metered = ConnectivityManagerCompat.isActiveNetworkMetered((ConnectivityManager)connectivityManager);
        if (!metered) {
            return JobRequest.NetworkType.UNMETERED;
        }
        if (networkInfo.isRoaming()) {
            return JobRequest.NetworkType.CONNECTED;
        }
        return JobRequest.NetworkType.NOT_ROAMING;
    }

    public static boolean isStorageLow() {
        return false;
    }
}

