/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.evernote.android.job.util.JobLogger;
import java.util.Arrays;

public class JobCat
implements JobLogger {
    private static volatile JobLogger[] loggers = new JobLogger[0];
    private static volatile boolean logcatEnabled = true;
    protected final String mTag;
    protected final boolean mEnabled;

    public static synchronized boolean addLogger(@NonNull JobLogger logger) {
        for (JobLogger printer1 : loggers) {
            if (!logger.equals(printer1)) continue;
            return false;
        }
        for (int i = 0; i < loggers.length; ++i) {
            if (loggers[i] != null) continue;
            JobCat.loggers[i] = logger;
            return true;
        }
        int index = loggers.length;
        loggers = Arrays.copyOf(loggers, loggers.length + 2);
        JobCat.loggers[index] = logger;
        return true;
    }

    public static synchronized void removeLogger(@NonNull JobLogger logger) {
        for (int i = 0; i < loggers.length; ++i) {
            if (!logger.equals(loggers[i])) continue;
            JobCat.loggers[i] = null;
        }
    }

    public static synchronized void clearLogger() {
        Arrays.fill(loggers, null);
    }

    public static void setLogcatEnabled(boolean enabled) {
        logcatEnabled = enabled;
    }

    public static boolean isLogcatEnabled() {
        return logcatEnabled;
    }

    public JobCat(Class<?> clazz) {
        this(clazz.getSimpleName());
    }

    public JobCat(String tag) {
        this(tag, true);
    }

    public JobCat(String tag, boolean enabled) {
        this.mTag = tag;
        this.mEnabled = enabled;
    }

    public void i(@NonNull String message) {
        this.log(4, this.mTag, message, null);
    }

    public void i(@NonNull String message, Object ... args) {
        this.log(4, this.mTag, String.format(message, args), null);
    }

    public void d(@NonNull String message) {
        this.log(3, this.mTag, message, null);
    }

    public void d(@NonNull String message, Object ... args) {
        this.log(3, this.mTag, String.format(message, args), null);
    }

    public void d(@NonNull Throwable t, String message, Object ... args) {
        this.log(3, this.mTag, String.format(message, args), t);
    }

    public void w(@NonNull String message) {
        this.log(5, this.mTag, message, null);
    }

    public void w(@NonNull String message, Object ... args) {
        this.log(5, this.mTag, String.format(message, args), null);
    }

    public void w(@NonNull Throwable t, @NonNull String message, Object ... args) {
        this.log(5, this.mTag, String.format(message, args), t);
    }

    public void e(@NonNull Throwable t) {
        String message = t.getMessage();
        this.log(6, this.mTag, message == null ? "empty message" : message, t);
    }

    public void e(@NonNull String message) {
        this.log(6, this.mTag, message, null);
    }

    public void e(@NonNull String message, Object ... args) {
        this.log(6, this.mTag, String.format(message, args), null);
    }

    public void e(@NonNull Throwable t, @NonNull String message, Object ... args) {
        this.log(6, this.mTag, String.format(message, args), t);
    }

    @Override
    public void log(int priority, @NonNull String tag, @NonNull String message, @Nullable Throwable t) {
        JobLogger[] printers;
        if (!this.mEnabled) {
            return;
        }
        if (logcatEnabled) {
            String stacktrace = t == null ? "" : '\n' + Log.getStackTraceString((Throwable)t);
            Log.println((int)priority, (String)tag, (String)(message + stacktrace));
        }
        if ((printers = loggers).length > 0) {
            for (JobLogger logger : printers) {
                if (logger == null) continue;
                logger.log(priority, tag, message, t);
            }
        }
    }
}

