/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.v21;

import android.annotation.TargetApi;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.evernote.android.job.JobProxy;
import com.evernote.android.job.JobProxyIllegalStateException;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.JobUtil;
import com.evernote.android.job.v21.PlatformJobService;
import com.evernote.android.job.v21.TransientBundleCompat;
import java.util.List;

@TargetApi(value=21)
public class JobProxy21
implements JobProxy {
    private static final String TAG = "JobProxy21";
    private static final int ERROR_BOOT_PERMISSION = -123;
    protected final Context mContext;
    protected final JobCat mCat;

    public JobProxy21(Context context) {
        this(context, TAG);
    }

    protected JobProxy21(Context context, String logTag) {
        this.mContext = context;
        this.mCat = new JobCat(logTag);
    }

    @Override
    public void plantOneOff(JobRequest request) {
        long startMs = JobProxy.Common.getStartMs(request);
        long endMs = JobProxy.Common.getEndMs(request, true);
        JobInfo jobInfo = this.createBuilderOneOff(this.createBaseBuilder(request, true), startMs, endMs).build();
        int scheduleResult = this.schedule(jobInfo);
        if (scheduleResult == -123) {
            jobInfo = this.createBuilderOneOff(this.createBaseBuilder(request, false), startMs, endMs).build();
            scheduleResult = this.schedule(jobInfo);
        }
        this.mCat.d("Schedule one-off jobInfo %s, %s, start %s, end %s (from now), reschedule count %d", JobProxy21.scheduleResultToString(scheduleResult), request, JobUtil.timeToString(startMs), JobUtil.timeToString(endMs), JobProxy.Common.getRescheduleCount(request));
    }

    @Override
    public void plantPeriodic(JobRequest request) {
        long intervalMs = request.getIntervalMs();
        long flexMs = request.getFlexMs();
        JobInfo jobInfo = this.createBuilderPeriodic(this.createBaseBuilder(request, true), intervalMs, flexMs).build();
        int scheduleResult = this.schedule(jobInfo);
        if (scheduleResult == -123) {
            jobInfo = this.createBuilderPeriodic(this.createBaseBuilder(request, false), intervalMs, flexMs).build();
            scheduleResult = this.schedule(jobInfo);
        }
        this.mCat.d("Schedule periodic jobInfo %s, %s, interval %s, flex %s", JobProxy21.scheduleResultToString(scheduleResult), request, JobUtil.timeToString(intervalMs), JobUtil.timeToString(flexMs));
    }

    @Override
    public void plantPeriodicFlexSupport(JobRequest request) {
        long startMs = JobProxy.Common.getStartMsSupportFlex(request);
        long endMs = JobProxy.Common.getEndMsSupportFlex(request);
        JobInfo jobInfo = this.createBuilderOneOff(this.createBaseBuilder(request, true), startMs, endMs).build();
        int scheduleResult = this.schedule(jobInfo);
        if (scheduleResult == -123) {
            jobInfo = this.createBuilderOneOff(this.createBaseBuilder(request, false), startMs, endMs).build();
            scheduleResult = this.schedule(jobInfo);
        }
        this.mCat.d("Schedule periodic (flex support) jobInfo %s, %s, start %s, end %s, flex %s", JobProxy21.scheduleResultToString(scheduleResult), request, JobUtil.timeToString(startMs), JobUtil.timeToString(endMs), JobUtil.timeToString(request.getFlexMs()));
    }

    @Override
    public void cancel(int jobId) {
        try {
            this.getJobScheduler().cancel(jobId);
        }
        catch (Exception e) {
            this.mCat.e(e);
        }
        TransientBundleCompat.cancel(this.mContext, jobId, null);
    }

    @Override
    public boolean isPlatformJobScheduled(JobRequest request) {
        List pendingJobs;
        try {
            pendingJobs = this.getJobScheduler().getAllPendingJobs();
        }
        catch (Exception e) {
            this.mCat.e(e);
            return false;
        }
        if (pendingJobs == null || pendingJobs.isEmpty()) {
            return false;
        }
        for (JobInfo info : pendingJobs) {
            if (!this.isJobInfoScheduled(info, request)) continue;
            return true;
        }
        return false;
    }

    protected boolean isJobInfoScheduled(@Nullable JobInfo info, @NonNull JobRequest request) {
        boolean correctInfo;
        boolean bl = correctInfo = info != null && info.getId() == request.getJobId();
        if (!correctInfo) {
            return false;
        }
        return !request.isTransient() || TransientBundleCompat.isScheduled(this.mContext, request.getJobId());
    }

    protected JobInfo.Builder createBaseBuilder(JobRequest request, boolean allowPersisting) {
        JobInfo.Builder builder = new JobInfo.Builder(request.getJobId(), new ComponentName(this.mContext, PlatformJobService.class)).setRequiresCharging(request.requiresCharging()).setRequiresDeviceIdle(request.requiresDeviceIdle()).setRequiredNetworkType(this.convertNetworkType(request.requiredNetworkType())).setPersisted(allowPersisting && !request.isTransient() && JobUtil.hasBootPermission(this.mContext));
        return this.setTransientBundle(request, builder);
    }

    protected JobInfo.Builder createBuilderOneOff(JobInfo.Builder builder, long startMs, long endMs) {
        return builder.setMinimumLatency(startMs).setOverrideDeadline(endMs);
    }

    protected JobInfo.Builder createBuilderPeriodic(JobInfo.Builder builder, long intervalMs, long flexMs) {
        return builder.setPeriodic(intervalMs);
    }

    protected JobInfo.Builder setTransientBundle(JobRequest request, JobInfo.Builder builder) {
        if (request.isTransient()) {
            TransientBundleCompat.persistBundle(this.mContext, request);
        }
        return builder;
    }

    protected int convertNetworkType(@NonNull JobRequest.NetworkType networkType) {
        switch (networkType) {
            case ANY: {
                return 0;
            }
            case CONNECTED: {
                return 1;
            }
            case UNMETERED: {
                return 2;
            }
            case NOT_ROAMING: {
                return 2;
            }
            case METERED: {
                return 1;
            }
        }
        throw new IllegalStateException("not implemented");
    }

    protected final JobScheduler getJobScheduler() {
        return (JobScheduler)this.mContext.getSystemService("jobscheduler");
    }

    protected final int schedule(JobInfo jobInfo) {
        JobScheduler jobScheduler = this.getJobScheduler();
        if (jobScheduler == null) {
            throw new JobProxyIllegalStateException("JobScheduler is null");
        }
        try {
            return jobScheduler.schedule(jobInfo);
        }
        catch (IllegalArgumentException e) {
            this.mCat.e(e);
            String message = e.getMessage();
            if (message != null && message.contains("RECEIVE_BOOT_COMPLETED")) {
                return -123;
            }
            if (message != null && message.contains("No such service ComponentInfo")) {
                throw new JobProxyIllegalStateException(e);
            }
            throw e;
        }
        catch (NullPointerException e) {
            this.mCat.e(e);
            throw new JobProxyIllegalStateException(e);
        }
    }

    protected static String scheduleResultToString(int scheduleResult) {
        return scheduleResult == 1 ? "success" : "failure";
    }
}

