/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.v21;

import android.annotation.TargetApi;
import android.app.Service;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import com.evernote.android.job.Job;
import com.evernote.android.job.JobConfig;
import com.evernote.android.job.JobManager;
import com.evernote.android.job.JobProxy;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.v21.TransientBundleCompat;

@TargetApi(value=21)
public class PlatformJobService
extends JobService {
    private static final JobCat CAT = new JobCat("PlatformJobService");

    public boolean onStartJob(final JobParameters params) {
        int jobId = params.getJobId();
        final JobProxy.Common common = new JobProxy.Common((Service)this, CAT, jobId);
        final JobRequest request = common.getPendingRequest(true, false);
        if (request == null) {
            return false;
        }
        if (request.isTransient()) {
            if (TransientBundleCompat.startWithTransientBundle((Context)this, request)) {
                if (Build.VERSION.SDK_INT >= 26) {
                    CAT.d("PendingIntent for transient bundle is not null although running on O, using compat mode, request %s", request);
                }
                return false;
            }
            if (Build.VERSION.SDK_INT < 26) {
                CAT.d("PendingIntent for transient job %s expired", request);
                return false;
            }
        }
        common.markStarting(request);
        JobConfig.getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    common.executeJobRequest(request, PlatformJobService.this.getTransientBundle(params));
                }
                finally {
                    PlatformJobService.this.jobFinished(params, false);
                }
            }
        });
        return true;
    }

    public boolean onStopJob(JobParameters params) {
        Job job = JobManager.instance().getJob(params.getJobId());
        if (job != null) {
            job.cancel();
            CAT.d("Called onStopJob for %s", job);
        } else {
            CAT.d("Called onStopJob, job %d not found", params.getJobId());
        }
        return false;
    }

    @TargetApi(value=26)
    private Bundle getTransientBundle(JobParameters params) {
        if (Build.VERSION.SDK_INT >= 26) {
            return params.getTransientExtras();
        }
        return Bundle.EMPTY;
    }
}

