/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.evernote.android.job.DailyJob;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.Device;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.support.PersistableBundleCompat;
import java.lang.ref.WeakReference;

public abstract class Job {
    private static final JobCat CAT = new JobCat("Job");
    private Params mParams;
    private WeakReference<Context> mContextReference;
    private Context mApplicationContext;
    private volatile boolean mCanceled;
    private volatile boolean mDeleted;
    private volatile long mFinishedTimeStamp = -1L;
    private Result mResult = Result.FAILURE;
    private final Object mMonitor = new Object();

    @NonNull
    @WorkerThread
    protected abstract Result onRunJob(@NonNull Params var1);

    protected void onCancel() {
    }

    final Result runJob() {
        try {
            this.mResult = this instanceof DailyJob || this.meetsRequirements(true) ? this.onRunJob(this.getParams()) : (this.getParams().isPeriodic() ? Result.FAILURE : Result.RESCHEDULE);
            Result result = this.mResult;
            return result;
        }
        finally {
            this.mFinishedTimeStamp = System.currentTimeMillis();
        }
    }

    @WorkerThread
    protected void onReschedule(int newJobId) {
    }

    protected boolean meetsRequirements() {
        return this.meetsRequirements(false);
    }

    boolean meetsRequirements(boolean checkRequirementsEnforced) {
        if (checkRequirementsEnforced && !this.getParams().getRequest().requirementsEnforced()) {
            return true;
        }
        if (!this.isRequirementChargingMet()) {
            CAT.w("Job requires charging, reschedule");
            return false;
        }
        if (!this.isRequirementDeviceIdleMet()) {
            CAT.w("Job requires device to be idle, reschedule");
            return false;
        }
        if (!this.isRequirementNetworkTypeMet()) {
            CAT.w("Job requires network to be %s, but was %s", new Object[]{this.getParams().getRequest().requiredNetworkType(), Device.getNetworkType(this.getContext())});
            return false;
        }
        if (!this.isRequirementBatteryNotLowMet()) {
            CAT.w("Job requires battery not be low, reschedule");
            return false;
        }
        if (!this.isRequirementStorageNotLowMet()) {
            CAT.w("Job requires storage not be low, reschedule");
            return false;
        }
        return true;
    }

    protected boolean isRequirementChargingMet() {
        return !this.getParams().getRequest().requiresCharging() || Device.getBatteryStatus(this.getContext()).isCharging();
    }

    protected boolean isRequirementDeviceIdleMet() {
        return !this.getParams().getRequest().requiresDeviceIdle() || Device.isIdle(this.getContext());
    }

    protected boolean isRequirementBatteryNotLowMet() {
        return !this.getParams().getRequest().requiresBatteryNotLow() || !Device.getBatteryStatus(this.getContext()).isBatteryLow();
    }

    protected boolean isRequirementStorageNotLowMet() {
        return !this.getParams().getRequest().requiresStorageNotLow() || !Device.isStorageLow();
    }

    protected boolean isRequirementNetworkTypeMet() {
        JobRequest.NetworkType requirement = this.getParams().getRequest().requiredNetworkType();
        if (requirement == JobRequest.NetworkType.ANY) {
            return true;
        }
        JobRequest.NetworkType current = Device.getNetworkType(this.getContext());
        switch (requirement) {
            case CONNECTED: {
                return current != JobRequest.NetworkType.ANY;
            }
            case NOT_ROAMING: {
                return current == JobRequest.NetworkType.NOT_ROAMING || current == JobRequest.NetworkType.UNMETERED || current == JobRequest.NetworkType.METERED;
            }
            case UNMETERED: {
                return current == JobRequest.NetworkType.UNMETERED;
            }
            case METERED: {
                return current == JobRequest.NetworkType.CONNECTED || current == JobRequest.NetworkType.NOT_ROAMING;
            }
        }
        throw new IllegalStateException("not implemented");
    }

    final Job setRequest(JobRequest request, @NonNull Bundle transientExtras) {
        this.mParams = new Params(request, transientExtras);
        return this;
    }

    @NonNull
    protected final Params getParams() {
        return this.mParams;
    }

    final Job setContext(Context context) {
        this.mContextReference = new WeakReference<Context>(context);
        this.mApplicationContext = context.getApplicationContext();
        return this;
    }

    @NonNull
    protected final Context getContext() {
        Context context = (Context)this.mContextReference.get();
        return context == null ? this.mApplicationContext : context;
    }

    public final void cancel() {
        this.cancel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean cancel(boolean deleted) {
        Object object = this.mMonitor;
        synchronized (object) {
            if (!this.isFinished()) {
                if (!this.mCanceled) {
                    this.mCanceled = true;
                    this.onCancel();
                }
                this.mDeleted |= deleted;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isCanceled() {
        Object object = this.mMonitor;
        synchronized (object) {
            return this.mCanceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isFinished() {
        Object object = this.mMonitor;
        synchronized (object) {
            return this.mFinishedTimeStamp > 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long getFinishedTimeStamp() {
        Object object = this.mMonitor;
        synchronized (object) {
            return this.mFinishedTimeStamp;
        }
    }

    final Result getResult() {
        return this.mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isDeleted() {
        Object object = this.mMonitor;
        synchronized (object) {
            return this.mDeleted;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        return this.mParams.equals(job.mParams);
    }

    public int hashCode() {
        return this.mParams.hashCode();
    }

    public String toString() {
        return "job{id=" + this.mParams.getId() + ", finished=" + this.isFinished() + ", result=" + (Object)((Object)this.mResult) + ", canceled=" + this.mCanceled + ", periodic=" + this.mParams.isPeriodic() + ", class=" + this.getClass().getSimpleName() + ", tag=" + this.mParams.getTag() + '}';
    }

    public static final class Params {
        private final JobRequest mRequest;
        private PersistableBundleCompat mExtras;
        private Bundle mTransientExtras;

        private Params(@NonNull JobRequest request, @NonNull Bundle transientExtras) {
            this.mRequest = request;
            this.mTransientExtras = transientExtras;
        }

        public int getId() {
            return this.mRequest.getJobId();
        }

        public String getTag() {
            return this.mRequest.getTag();
        }

        public boolean isPeriodic() {
            return this.mRequest.isPeriodic();
        }

        public boolean isExact() {
            return this.mRequest.isExact();
        }

        public long getStartMs() {
            return this.mRequest.getStartMs();
        }

        public long getEndMs() {
            return this.mRequest.getEndMs();
        }

        public long getIntervalMs() {
            return this.mRequest.getIntervalMs();
        }

        public long getFlexMs() {
            return this.mRequest.getFlexMs();
        }

        public long getScheduledAt() {
            return this.mRequest.getScheduledAt();
        }

        public long getBackoffMs() {
            return this.mRequest.getBackoffMs();
        }

        public JobRequest.BackoffPolicy getBackoffPolicy() {
            return this.mRequest.getBackoffPolicy();
        }

        public boolean requiresCharging() {
            return this.mRequest.requiresCharging();
        }

        public boolean requiresDeviceIdle() {
            return this.mRequest.requiresDeviceIdle();
        }

        public JobRequest.NetworkType requiredNetworkType() {
            return this.mRequest.requiredNetworkType();
        }

        public boolean requiresBatteryNotLow() {
            return this.mRequest.requiresBatteryNotLow();
        }

        public boolean requiresStorageNotLow() {
            return this.mRequest.requiresStorageNotLow();
        }

        public boolean requirementsEnforced() {
            return this.mRequest.requirementsEnforced();
        }

        public int getFailureCount() {
            return this.mRequest.getFailureCount();
        }

        public long getLastRun() {
            return this.mRequest.getLastRun();
        }

        public boolean isTransient() {
            return this.mRequest.isTransient();
        }

        @NonNull
        public Bundle getTransientExtras() {
            return this.mTransientExtras;
        }

        @NonNull
        public PersistableBundleCompat getExtras() {
            if (this.mExtras == null) {
                this.mExtras = this.mRequest.getExtras();
                if (this.mExtras == null) {
                    this.mExtras = new PersistableBundleCompat();
                }
            }
            return this.mExtras;
        }

        JobRequest getRequest() {
            return this.mRequest;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Params params = (Params)o;
            return this.mRequest.equals(params.mRequest);
        }

        public int hashCode() {
            return this.mRequest.hashCode();
        }
    }

    public static enum Result {
        SUCCESS,
        FAILURE,
        RESCHEDULE;

    }
}

