/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.SparseArray;
import com.evernote.android.job.Job;
import com.evernote.android.job.JobApi;
import com.evernote.android.job.JobConfig;
import com.evernote.android.job.JobCreator;
import com.evernote.android.job.JobCreatorHolder;
import com.evernote.android.job.JobExecutor;
import com.evernote.android.job.JobManagerCreateException;
import com.evernote.android.job.JobProxy;
import com.evernote.android.job.JobProxyIllegalStateException;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.JobRescheduleService;
import com.evernote.android.job.JobStorage;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.JobPreconditions;
import com.evernote.android.job.util.JobUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class JobManager {
    private static final JobCat CAT = new JobCat("JobManager");
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile JobManager instance;
    private final Context mContext;
    private final JobCreatorHolder mJobCreatorHolder;
    private final JobExecutor mJobExecutor;
    private volatile JobStorage mJobStorage;
    private final CountDownLatch mJobStorageLatch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JobManager create(@NonNull Context context) throws JobManagerCreateException {
        if (instance != null) return instance;
        Class<JobManager> clazz = JobManager.class;
        synchronized (JobManager.class) {
            JobApi api;
            if (instance != null) return instance;
            JobPreconditions.checkNotNull(context, "Context cannot be null");
            if (context.getApplicationContext() != null) {
                context = context.getApplicationContext();
            }
            if ((api = JobApi.getDefault(context)) == JobApi.V_14 && !api.isSupported(context)) {
                throw new JobManagerCreateException("All APIs are disabled, cannot schedule any job");
            }
            instance = new JobManager(context);
            if (!JobUtil.hasWakeLockPermission(context)) {
                CAT.w("No wake lock permission");
            }
            if (!JobUtil.hasBootPermission(context)) {
                CAT.w("No boot permission");
            }
            JobManager.sendAddJobCreatorIntent(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JobManager instance() {
        if (instance != null) return instance;
        Class<JobManager> clazz = JobManager.class;
        synchronized (JobManager.class) {
            if (instance != null) return instance;
            throw new IllegalStateException("You need to call create() at least once to create the singleton");
        }
    }

    private JobManager(final Context context) {
        this.mContext = context;
        this.mJobCreatorHolder = new JobCreatorHolder();
        this.mJobExecutor = new JobExecutor();
        if (!JobConfig.isSkipJobReschedule()) {
            JobRescheduleService.startService(this.mContext);
        }
        this.mJobStorageLatch = new CountDownLatch(1);
        new Thread("AndroidJob-storage-init"){

            @Override
            public void run() {
                JobManager.this.mJobStorage = new JobStorage(context);
                JobManager.this.mJobStorageLatch.countDown();
            }
        }.start();
    }

    public synchronized void schedule(@NonNull JobRequest request) {
        if (this.mJobCreatorHolder.isEmpty()) {
            CAT.w("you haven't registered a JobCreator with addJobCreator(), it's likely that your job never will be executed");
        }
        if (request.getScheduledAt() > 0L) {
            return;
        }
        if (request.isUpdateCurrent()) {
            this.cancelAllForTag(request.getTag());
        }
        JobProxy.Common.cleanUpOrphanedJob(this.mContext, request.getJobId());
        JobApi jobApi = request.getJobApi();
        boolean periodic = request.isPeriodic();
        boolean flexSupport = periodic && jobApi.isFlexSupport() && request.getFlexMs() < request.getIntervalMs();
        request.setScheduledAt(JobConfig.getClock().currentTimeMillis());
        request.setFlexSupport(flexSupport);
        this.getJobStorage().put(request);
        try {
            this.scheduleWithApi(request, jobApi, periodic, flexSupport);
            return;
        }
        catch (JobProxyIllegalStateException jobProxyIllegalStateException) {
        }
        catch (Exception e) {
            this.getJobStorage().remove(request);
            throw e;
        }
        try {
            jobApi.invalidateCachedProxy();
            this.scheduleWithApi(request, jobApi, periodic, flexSupport);
            return;
        }
        catch (Exception e) {
            if (jobApi == JobApi.V_14 || jobApi == JobApi.V_19) {
                this.getJobStorage().remove(request);
                throw e;
            }
            jobApi = JobApi.V_19.isSupported(this.mContext) ? JobApi.V_19 : JobApi.V_14;
            try {
                this.scheduleWithApi(request, jobApi, periodic, flexSupport);
            }
            catch (Exception e2) {
                this.getJobStorage().remove(request);
                throw e2;
            }
            return;
        }
    }

    private void scheduleWithApi(JobRequest request, JobApi jobApi, boolean periodic, boolean flexSupport) {
        JobProxy proxy = this.getJobProxy(jobApi);
        if (periodic) {
            if (flexSupport) {
                proxy.plantPeriodicFlexSupport(request);
            } else {
                proxy.plantPeriodic(request);
            }
        } else {
            proxy.plantOneOff(request);
        }
    }

    public JobRequest getJobRequest(int jobId) {
        JobRequest request = this.getJobRequest(jobId, false);
        if (request != null && request.isTransient() && !request.getJobApi().getProxy(this.mContext).isPlatformJobScheduled(request)) {
            this.getJobStorage().remove(request);
            return null;
        }
        return request;
    }

    JobRequest getJobRequest(int jobId, boolean includeStarted) {
        JobRequest jobRequest = this.getJobStorage().get(jobId);
        if (!includeStarted && jobRequest != null && jobRequest.isStarted()) {
            return null;
        }
        return jobRequest;
    }

    @NonNull
    public Set<JobRequest> getAllJobRequests() {
        return this.getAllJobRequests(null, false, true);
    }

    public Set<JobRequest> getAllJobRequestsForTag(@NonNull String tag) {
        return this.getAllJobRequests(tag, false, true);
    }

    Set<JobRequest> getAllJobRequests(@Nullable String tag, boolean includeStarted, boolean cleanUpTransient) {
        Set<JobRequest> requests = this.getJobStorage().getAllJobRequests(tag, includeStarted);
        if (cleanUpTransient) {
            Iterator<JobRequest> iterator = requests.iterator();
            while (iterator.hasNext()) {
                JobRequest request = iterator.next();
                if (!request.isTransient() || request.getJobApi().getProxy(this.mContext).isPlatformJobScheduled(request)) continue;
                this.getJobStorage().remove(request);
                iterator.remove();
            }
        }
        return requests;
    }

    public Job getJob(int jobId) {
        return this.mJobExecutor.getJob(jobId);
    }

    @NonNull
    public Set<Job> getAllJobs() {
        return this.mJobExecutor.getAllJobs();
    }

    @NonNull
    public Set<Job> getAllJobsForTag(@NonNull String tag) {
        return this.mJobExecutor.getAllJobsForTag(tag);
    }

    @NonNull
    public SparseArray<Job.Result> getAllJobResults() {
        return this.mJobExecutor.getAllJobResults();
    }

    public boolean cancel(int jobId) {
        boolean result = this.cancelInner(this.getJobRequest(jobId, true)) | this.cancelInner(this.getJob(jobId));
        JobProxy.Common.cleanUpOrphanedJob(this.mContext, jobId);
        return result;
    }

    public int cancelAll() {
        return this.cancelAllInner(null);
    }

    public int cancelAllForTag(@NonNull String tag) {
        return this.cancelAllInner(tag);
    }

    private boolean cancelInner(@Nullable JobRequest request) {
        if (request != null) {
            CAT.i("Found pending job %s, canceling", request);
            this.getJobProxy(request.getJobApi()).cancel(request.getJobId());
            this.getJobStorage().remove(request);
            request.setScheduledAt(0L);
            return true;
        }
        return false;
    }

    private boolean cancelInner(@Nullable Job job) {
        if (job != null && job.cancel(true)) {
            CAT.i("Cancel running %s", job);
            return true;
        }
        return false;
    }

    private synchronized int cancelAllInner(@Nullable String tag) {
        int canceled = 0;
        Set<JobRequest> requests = this.getAllJobRequests(tag, true, false);
        for (JobRequest request : requests) {
            if (!this.cancelInner(request)) continue;
            ++canceled;
        }
        Set<Job> jobs = TextUtils.isEmpty((CharSequence)tag) ? this.getAllJobs() : this.getAllJobsForTag(tag);
        for (Job job : jobs) {
            if (!this.cancelInner(job)) continue;
            ++canceled;
        }
        return canceled;
    }

    public void addJobCreator(JobCreator jobCreator) {
        this.mJobCreatorHolder.addJobCreator(jobCreator);
    }

    public void removeJobCreator(JobCreator jobCreator) {
        this.mJobCreatorHolder.removeJobCreator(jobCreator);
    }

    @NonNull
    JobStorage getJobStorage() {
        if (this.mJobStorage == null) {
            try {
                this.mJobStorageLatch.await(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.mJobStorage == null) {
            throw new IllegalStateException("Job storage shouldn't be null");
        }
        return this.mJobStorage;
    }

    JobExecutor getJobExecutor() {
        return this.mJobExecutor;
    }

    JobCreatorHolder getJobCreatorHolder() {
        return this.mJobCreatorHolder;
    }

    Context getContext() {
        return this.mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        Class<JobManager> clazz = JobManager.class;
        synchronized (JobManager.class) {
            instance = null;
            for (JobApi api : JobApi.values()) {
                api.invalidateCachedProxy();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    JobProxy getJobProxy(JobApi api) {
        return api.getProxy(this.mContext);
    }

    private static void sendAddJobCreatorIntent(@NonNull Context context) {
        List resolveInfos;
        String myPackage = context.getPackageName();
        Intent intent = new Intent("com.evernote.android.job.ADD_JOB_CREATOR");
        intent.setPackage(myPackage);
        try {
            resolveInfos = context.getPackageManager().queryBroadcastReceivers(intent, 0);
        }
        catch (Exception e) {
            resolveInfos = Collections.emptyList();
        }
        for (ResolveInfo resolveInfo : resolveInfos) {
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null || activityInfo.exported || !myPackage.equals(activityInfo.packageName) || TextUtils.isEmpty((CharSequence)activityInfo.name)) continue;
            try {
                JobCreator.AddJobCreatorReceiver receiver = (JobCreator.AddJobCreatorReceiver)((Object)Class.forName(activityInfo.name).newInstance());
                receiver.addJobCreator(context, instance);
            }
            catch (Exception exception) {}
        }
    }
}

