/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.SafeJobIntentService;
import com.evernote.android.job.Job;
import com.evernote.android.job.JobConfig;
import com.evernote.android.job.JobManager;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.JobCat;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class JobRescheduleService
extends SafeJobIntentService {
    private static final JobCat CAT = new JobCat("JobRescheduleService", false);
    @VisibleForTesting
    static CountDownLatch latch;

    static void startService(Context context) {
        try {
            JobRescheduleService.enqueueWork((Context)context, JobRescheduleService.class, (int)2147480000, (Intent)new Intent());
            latch = new CountDownLatch(1);
        }
        catch (Exception e) {
            CAT.e(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onHandleWork(@NonNull Intent intent) {
        try {
            JobManager manager;
            CAT.d("Reschedule service started");
            SystemClock.sleep((long)JobConfig.getJobReschedulePause());
            try {
                manager = JobManager.create((Context)this);
            }
            catch (Exception e) {
                if (latch != null) {
                    latch.countDown();
                }
                return;
            }
            Set<JobRequest> requests = manager.getAllJobRequests(null, true, true);
            int rescheduledCount = this.rescheduleJobs(manager, requests);
            CAT.d("Reschedule %d jobs of %d jobs", rescheduledCount, requests.size());
        }
        finally {
            if (latch != null) {
                latch.countDown();
            }
        }
    }

    int rescheduleJobs(JobManager manager) {
        return this.rescheduleJobs(manager, manager.getAllJobRequests(null, true, true));
    }

    int rescheduleJobs(JobManager manager, Collection<JobRequest> requests) {
        int rescheduledCount = 0;
        boolean exceptionThrown = false;
        for (JobRequest request : requests) {
            block5: {
                boolean reschedule;
                if (request.isStarted()) {
                    Job job = manager.getJob(request.getJobId());
                    reschedule = job == null;
                } else {
                    boolean bl = reschedule = !manager.getJobProxy(request.getJobApi()).isPlatformJobScheduled(request);
                }
                if (!reschedule) continue;
                try {
                    request.cancelAndEdit().build().schedule();
                }
                catch (Exception e) {
                    if (exceptionThrown) break block5;
                    CAT.e(e);
                    exceptionThrown = true;
                }
            }
            ++rescheduledCount;
        }
        return rescheduledCount;
    }
}

