/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.v14;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.evernote.android.job.JobConfig;
import com.evernote.android.job.JobProxy;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.util.JobUtil;
import com.evernote.android.job.v14.PlatformAlarmReceiver;
import com.evernote.android.job.v14.PlatformAlarmService;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class JobProxy14
implements JobProxy {
    private static final String TAG = "JobProxy14";
    protected final Context mContext;
    protected final JobCat mCat;
    private AlarmManager mAlarmManager;

    public JobProxy14(Context context) {
        this(context, TAG);
    }

    protected JobProxy14(Context context, String logTag) {
        this.mContext = context;
        this.mCat = new JobCat(logTag);
    }

    @Override
    public void plantOneOff(JobRequest request) {
        PendingIntent pendingIntent = this.getPendingIntent(request, false);
        AlarmManager alarmManager = this.getAlarmManager();
        if (alarmManager == null) {
            return;
        }
        try {
            if (request.isExact()) {
                if (request.getStartMs() == 1L && request.getFailureCount() <= 0) {
                    PlatformAlarmService.start(this.mContext, request.getJobId(), request.getTransientExtras());
                } else {
                    this.plantOneOffExact(request, alarmManager, pendingIntent);
                }
            } else {
                this.plantOneOffInexact(request, alarmManager, pendingIntent);
            }
        }
        catch (Exception e) {
            this.mCat.e(e);
        }
    }

    protected void plantOneOffInexact(JobRequest request, AlarmManager alarmManager, PendingIntent pendingIntent) {
        alarmManager.set(this.getType(false), this.getTriggerAtMillis(request), pendingIntent);
        this.logScheduled(request);
    }

    protected void plantOneOffExact(JobRequest request, AlarmManager alarmManager, PendingIntent pendingIntent) {
        long triggerAtMillis = this.getTriggerAtMillis(request);
        if (Build.VERSION.SDK_INT >= 23) {
            alarmManager.setExactAndAllowWhileIdle(this.getType(true), triggerAtMillis, pendingIntent);
        } else if (Build.VERSION.SDK_INT >= 19) {
            alarmManager.setExact(this.getType(true), triggerAtMillis, pendingIntent);
        } else {
            alarmManager.set(this.getType(true), triggerAtMillis, pendingIntent);
        }
        this.logScheduled(request);
    }

    protected void plantOneOffFlexSupport(JobRequest request, AlarmManager alarmManager, PendingIntent pendingIntent) {
        long triggerAtMs = JobConfig.getClock().currentTimeMillis() + JobProxy.Common.getAverageDelayMsSupportFlex(request);
        alarmManager.set(1, triggerAtMs, pendingIntent);
        this.mCat.d("Scheduled repeating alarm (flex support), %s, interval %s, flex %s", request, JobUtil.timeToString(request.getIntervalMs()), JobUtil.timeToString(request.getFlexMs()));
    }

    protected long getTriggerAtMillis(JobRequest request) {
        if (JobConfig.isForceRtc()) {
            return JobConfig.getClock().currentTimeMillis() + JobProxy.Common.getAverageDelayMs(request);
        }
        return JobConfig.getClock().elapsedRealtime() + JobProxy.Common.getAverageDelayMs(request);
    }

    protected int getType(boolean wakeup) {
        if (wakeup) {
            return JobConfig.isForceRtc() ? 0 : 2;
        }
        return JobConfig.isForceRtc() ? 1 : 3;
    }

    private void logScheduled(JobRequest request) {
        this.mCat.d("Scheduled alarm, %s, delay %s (from now), exact %b, reschedule count %d", request, JobUtil.timeToString(JobProxy.Common.getAverageDelayMs(request)), request.isExact(), JobProxy.Common.getRescheduleCount(request));
    }

    @Override
    public void plantPeriodic(JobRequest request) {
        PendingIntent pendingIntent = this.getPendingIntent(request, true);
        AlarmManager alarmManager = this.getAlarmManager();
        if (alarmManager != null) {
            alarmManager.setRepeating(this.getType(true), this.getTriggerAtMillis(request), request.getIntervalMs(), pendingIntent);
        }
        this.mCat.d("Scheduled repeating alarm, %s, interval %s", request, JobUtil.timeToString(request.getIntervalMs()));
    }

    @Override
    public void plantPeriodicFlexSupport(JobRequest request) {
        PendingIntent pendingIntent = this.getPendingIntent(request, false);
        AlarmManager alarmManager = this.getAlarmManager();
        if (alarmManager == null) {
            return;
        }
        try {
            this.plantOneOffFlexSupport(request, alarmManager, pendingIntent);
        }
        catch (Exception e) {
            this.mCat.e(e);
        }
    }

    @Override
    public void cancel(int jobId) {
        AlarmManager alarmManager = this.getAlarmManager();
        if (alarmManager != null) {
            try {
                alarmManager.cancel(this.getPendingIntent(jobId, false, null, this.createPendingIntentFlags(true)));
                alarmManager.cancel(this.getPendingIntent(jobId, false, null, this.createPendingIntentFlags(false)));
            }
            catch (Exception e) {
                this.mCat.e(e);
            }
        }
    }

    @Override
    public boolean isPlatformJobScheduled(JobRequest request) {
        PendingIntent pendingIntent = this.getPendingIntent(request, 0x20000000);
        return pendingIntent != null;
    }

    protected int createPendingIntentFlags(boolean repeating) {
        int flags = 0x8000000;
        if (!repeating) {
            flags |= 0x40000000;
        }
        return flags;
    }

    protected PendingIntent getPendingIntent(JobRequest request, boolean repeating) {
        return this.getPendingIntent(request, this.createPendingIntentFlags(repeating));
    }

    protected PendingIntent getPendingIntent(JobRequest request, int flags) {
        return this.getPendingIntent(request.getJobId(), request.isExact(), request.getTransientExtras(), flags);
    }

    protected PendingIntent getPendingIntent(int jobId, boolean exact, @Nullable Bundle transientExtras, int flags) {
        Intent intent = PlatformAlarmReceiver.createIntent(this.mContext, jobId, exact, transientExtras);
        try {
            return PendingIntent.getBroadcast((Context)this.mContext, (int)jobId, (Intent)intent, (int)flags);
        }
        catch (Exception e) {
            this.mCat.e(e);
            return null;
        }
    }

    @Nullable
    protected AlarmManager getAlarmManager() {
        if (this.mAlarmManager == null) {
            this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        }
        if (this.mAlarmManager == null) {
            this.mCat.e("AlarmManager is null");
        }
        return this.mAlarmManager;
    }
}

