/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.v19;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.support.annotation.RestrictTo;
import com.evernote.android.job.JobProxy;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.JobUtil;
import com.evernote.android.job.v14.JobProxy14;

@TargetApi(value=19)
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class JobProxy19
extends JobProxy14 {
    private static final String TAG = "JobProxy19";

    public JobProxy19(Context context) {
        super(context, TAG);
    }

    @Override
    protected void plantOneOffInexact(JobRequest request, AlarmManager alarmManager, PendingIntent pendingIntent) {
        long currentTime = System.currentTimeMillis();
        long startMs = currentTime + JobProxy.Common.getStartMs(request);
        long lengthMs = JobProxy.Common.getEndMs(request) - JobProxy.Common.getStartMs(request);
        alarmManager.setWindow(1, startMs, lengthMs, pendingIntent);
        this.mCat.d("Schedule alarm, %s, start %s, end %s", request, JobUtil.timeToString(JobProxy.Common.getStartMs(request)), JobUtil.timeToString(JobProxy.Common.getEndMs(request)));
    }

    @Override
    protected void plantOneOffFlexSupport(JobRequest request, AlarmManager alarmManager, PendingIntent pendingIntent) {
        long currentTime = System.currentTimeMillis();
        long startMs = currentTime + JobProxy.Common.getStartMsSupportFlex(request);
        long lengthMs = JobProxy.Common.getEndMsSupportFlex(request) - JobProxy.Common.getStartMsSupportFlex(request);
        alarmManager.setWindow(1, startMs, lengthMs, pendingIntent);
        this.mCat.d("Scheduled repeating alarm (flex support), %s, start %s, end %s, flex %s", request, JobUtil.timeToString(JobProxy.Common.getStartMsSupportFlex(request)), JobUtil.timeToString(JobProxy.Common.getEndMsSupportFlex(request)), JobUtil.timeToString(request.getFlexMs()));
    }
}

