/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.v21;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RestrictTo;
import com.evernote.android.job.Job;
import com.evernote.android.job.JobConfig;
import com.evernote.android.job.JobManager;
import com.evernote.android.job.JobProxy;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.v21.TransientBundleCompat;

@TargetApi(value=21)
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class PlatformJobService
extends JobService {
    private static final JobCat CAT = new JobCat("PlatformJobService");

    public boolean onStartJob(final JobParameters params) {
        JobConfig.getExecutorService().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int jobId = params.getJobId();
                    JobProxy.Common common = new JobProxy.Common((Context)PlatformJobService.this, CAT, jobId);
                    JobRequest request = common.getPendingRequest(true, false);
                    if (request == null) {
                        return;
                    }
                    if (request.isTransient()) {
                        if (TransientBundleCompat.startWithTransientBundle((Context)PlatformJobService.this, request)) {
                            if (Build.VERSION.SDK_INT >= 26) {
                                CAT.d("PendingIntent for transient bundle is not null although running on O, using compat mode, request %s", request);
                            }
                            return;
                        }
                        if (Build.VERSION.SDK_INT < 26) {
                            CAT.d("PendingIntent for transient job %s expired", request);
                            return;
                        }
                    }
                    common.markStarting(request);
                    common.executeJobRequest(request, PlatformJobService.this.getTransientBundle(params));
                }
                finally {
                    PlatformJobService.this.jobFinished(params, false);
                }
            }
        });
        return true;
    }

    public boolean onStopJob(JobParameters params) {
        Job job = JobManager.create((Context)this).getJob(params.getJobId());
        if (job != null) {
            job.cancel();
            CAT.d("Called onStopJob for %s", job);
        } else {
            CAT.d("Called onStopJob, job %d not found", params.getJobId());
        }
        return false;
    }

    @TargetApi(value=26)
    private Bundle getTransientBundle(JobParameters params) {
        if (Build.VERSION.SDK_INT >= 26) {
            return params.getTransientExtras();
        }
        return Bundle.EMPTY;
    }
}

