/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.work;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import androidx.work.Configuration;
import androidx.work.Constraints;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkInfo;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.evernote.android.job.JobProxy;
import com.evernote.android.job.JobProxyIllegalStateException;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.work.PlatformWorker;
import com.evernote.android.job.work.TransientBundleHolder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class JobProxyWorkManager
implements JobProxy {
    private static final String PREFIX = "android-job-";
    private static final JobCat CAT = new JobCat("JobProxyWork");
    private final Context mContext;

    public JobProxyWorkManager(Context context) {
        this.mContext = context;
    }

    @Override
    public void plantOneOff(JobRequest request) {
        if (request.isTransient()) {
            TransientBundleHolder.putBundle(request.getJobId(), request.getTransientExtras());
        }
        OneTimeWorkRequest workRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(PlatformWorker.class).setInitialDelay(request.getStartMs(), TimeUnit.MILLISECONDS).setConstraints(JobProxyWorkManager.buildConstraints(request))).addTag(JobProxyWorkManager.createTag(request.getJobId()))).build();
        WorkManager workManager = this.getWorkManager();
        if (workManager == null) {
            throw new JobProxyIllegalStateException("WorkManager is null");
        }
        workManager.enqueue((WorkRequest)workRequest);
    }

    @Override
    public void plantPeriodic(JobRequest request) {
        PeriodicWorkRequest workRequest = (PeriodicWorkRequest)((PeriodicWorkRequest.Builder)((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(PlatformWorker.class, request.getIntervalMs(), TimeUnit.MILLISECONDS, request.getFlexMs(), TimeUnit.MILLISECONDS).setConstraints(JobProxyWorkManager.buildConstraints(request))).addTag(JobProxyWorkManager.createTag(request.getJobId()))).build();
        WorkManager workManager = this.getWorkManager();
        if (workManager == null) {
            throw new JobProxyIllegalStateException("WorkManager is null");
        }
        workManager.enqueue((WorkRequest)workRequest);
    }

    @Override
    public void plantPeriodicFlexSupport(JobRequest request) {
        CAT.w("plantPeriodicFlexSupport called although flex is supported");
        this.plantPeriodic(request);
    }

    @Override
    public void cancel(int jobId) {
        WorkManager workManager = this.getWorkManager();
        if (workManager == null) {
            return;
        }
        workManager.cancelAllWorkByTag(JobProxyWorkManager.createTag(jobId));
        TransientBundleHolder.cleanUpBundle(jobId);
    }

    @Override
    public boolean isPlatformJobScheduled(JobRequest request) {
        List<WorkInfo> infos = this.getWorkStatusBlocking(JobProxyWorkManager.createTag(request.getJobId()));
        if (infos == null || infos.isEmpty()) {
            return false;
        }
        WorkInfo.State state = infos.get(0).getState();
        return state == WorkInfo.State.ENQUEUED;
    }

    static String createTag(int jobId) {
        return PREFIX + jobId;
    }

    static int getJobIdFromTags(Collection<String> tags) {
        for (String tag : tags) {
            if (!tag.startsWith(PREFIX)) continue;
            return Integer.parseInt(tag.substring(PREFIX.length()));
        }
        return -1;
    }

    private static Constraints buildConstraints(JobRequest request) {
        Constraints.Builder constraintsBuilder = new Constraints.Builder().setRequiresBatteryNotLow(request.requiresBatteryNotLow()).setRequiresCharging(request.requiresCharging()).setRequiresStorageNotLow(request.requiresStorageNotLow()).setRequiredNetworkType(JobProxyWorkManager.mapNetworkType(request.requiredNetworkType()));
        if (Build.VERSION.SDK_INT >= 23) {
            constraintsBuilder.setRequiresDeviceIdle(request.requiresDeviceIdle());
        }
        return constraintsBuilder.build();
    }

    @NonNull
    private static NetworkType mapNetworkType(@NonNull JobRequest.NetworkType networkType) {
        switch (networkType) {
            case ANY: {
                return NetworkType.NOT_REQUIRED;
            }
            case METERED: {
                return NetworkType.METERED;
            }
            case CONNECTED: {
                return NetworkType.CONNECTED;
            }
            case UNMETERED: {
                return NetworkType.UNMETERED;
            }
            case NOT_ROAMING: {
                return NetworkType.NOT_ROAMING;
            }
        }
        throw new IllegalStateException("Not implemented");
    }

    private WorkManager getWorkManager() {
        WorkManager workManager;
        try {
            workManager = WorkManager.getInstance();
        }
        catch (Throwable t) {
            workManager = null;
        }
        if (workManager == null) {
            try {
                WorkManager.initialize((Context)this.mContext, (Configuration)new Configuration.Builder().build());
                workManager = WorkManager.getInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            CAT.w("WorkManager getInstance() returned null, now: %s", workManager);
        }
        return workManager;
    }

    private List<WorkInfo> getWorkStatusBlocking(String tag) {
        WorkManager workManager = this.getWorkManager();
        if (workManager == null) {
            return Collections.emptyList();
        }
        try {
            return (List)workManager.getWorkInfosByTag(tag).get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

