/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.security.NetworkSecurityPolicy;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSettings;
import com.facebook.ads.CacheFlag;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.RewardData;
import com.facebook.ads.internal.adapters.AdAdapter;
import com.facebook.ads.internal.adapters.BannerAdapterListener;
import com.facebook.ads.internal.adapters.InterstitialAdapterListener;
import com.facebook.ads.internal.adapters.f;
import com.facebook.ads.internal.adapters.h;
import com.facebook.ads.internal.adapters.j;
import com.facebook.ads.internal.adapters.o;
import com.facebook.ads.internal.adapters.r;
import com.facebook.ads.internal.adapters.t;
import com.facebook.ads.internal.adapters.u;
import com.facebook.ads.internal.j.e;
import com.facebook.ads.internal.protocol.AdErrorType;
import com.facebook.ads.internal.protocol.AdPlacementType;
import com.facebook.ads.internal.q.c;
import com.facebook.ads.internal.q.g;
import com.facebook.ads.internal.s.a.d;
import com.facebook.ads.internal.s.a.m;
import com.facebook.ads.internal.s.a.q;
import com.facebook.ads.internal.s.a.z;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisplayAdController
implements c.a {
    protected com.facebook.ads.internal.adapters.a a;
    private static final String b;
    private final Context c;
    private final String d;
    private final AdPlacementType e;
    private final com.facebook.ads.internal.q.c f;
    private final Handler g = new Handler();
    private static final Handler h;
    private static boolean i;
    private final Runnable j;
    private final Runnable k;
    private volatile boolean l;
    private boolean m;
    private volatile boolean n;
    private AdAdapter o;
    private AdAdapter p;
    private View q;
    private com.facebook.ads.internal.j.c r;
    private com.facebook.ads.internal.q.b s;
    private com.facebook.ads.internal.protocol.e t;
    private com.facebook.ads.internal.protocol.d u;
    private int v;
    private boolean w = false;
    private int x = -1;
    private final c y;
    private boolean z;
    private final com.facebook.ads.internal.o.c A;
    private final EnumSet<CacheFlag> B;
    private String C;
    private com.facebook.ads.internal.p.d D;

    public DisplayAdController(Context context, String string, com.facebook.ads.internal.protocol.e e2, AdPlacementType adPlacementType, com.facebook.ads.internal.protocol.d d2, int n2, boolean bl) {
        this(context, string, e2, adPlacementType, d2, n2, bl, EnumSet.of(CacheFlag.NONE));
    }

    public DisplayAdController(Context context, String string, com.facebook.ads.internal.protocol.e e2, AdPlacementType adPlacementType, com.facebook.ads.internal.protocol.d d2, int n2, boolean bl, EnumSet<CacheFlag> enumSet) {
        this.c = context.getApplicationContext();
        this.d = string;
        this.t = e2;
        this.e = adPlacementType;
        this.u = d2;
        this.v = n2;
        this.y = new c();
        this.B = enumSet;
        this.f = new com.facebook.ads.internal.q.c(this.c);
        this.f.a(this);
        this.j = new a(this);
        this.k = new b(this);
        this.m = this.m;
        this.i();
        try {
            CookieManager.getInstance();
            if (Build.VERSION.SDK_INT < 21) {
                CookieSyncManager.createInstance((Context)this.c);
            }
        }
        catch (Exception exception) {
            Log.w((String)b, (String)"Failed to initialize CookieManager.", (Throwable)exception);
        }
        com.facebook.ads.internal.k.a.a(this.c).a();
        this.A = com.facebook.ads.internal.o.d.a(this.c);
    }

    private void i() {
        if (this.m) {
            return;
        }
        IntentFilter intentFilter = new IntentFilter("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        this.c.registerReceiver((BroadcastReceiver)this.y, intentFilter);
        this.z = true;
    }

    private void j() {
        if (this.z) {
            try {
                this.c.unregisterReceiver((BroadcastReceiver)this.y);
                this.z = false;
            }
            catch (Exception exception) {
                com.facebook.ads.internal.l.b.a(com.facebook.ads.internal.l.a.a(exception, "Error unregistering screen state receiever"));
            }
        }
    }

    public void a(com.facebook.ads.internal.adapters.a a2) {
        this.a = a2;
    }

    public void a(String string) {
        this.C = string;
    }

    public void a(@Nullable com.facebook.ads.internal.p.d d2) {
        this.D = d2;
    }

    public void a(boolean bl) {
        this.w = bl;
    }

    public void a(int n2) {
        this.x = n2;
    }

    public com.facebook.ads.internal.j.d a() {
        if (this.r == null) {
            return null;
        }
        return this.r.a();
    }

    private void a(AdAdapter adAdapter) {
        if (adAdapter != null) {
            adAdapter.onDestroy();
        }
    }

    private AdPlacementType k() {
        if (this.e != null) {
            return this.e;
        }
        if (this.u == null) {
            return AdPlacementType.NATIVE;
        }
        if (this.u == com.facebook.ads.internal.protocol.d.b) {
            return AdPlacementType.INTERSTITIAL;
        }
        return AdPlacementType.BANNER;
    }

    public void b(String string) {
        this.c(string);
    }

    private void c(String string) {
        com.facebook.ads.internal.protocol.g g2;
        try {
            g2 = new com.facebook.ads.internal.protocol.g(this.c, string, this.d, this.t);
        }
        catch (com.facebook.ads.internal.protocol.b b2) {
            this.a(com.facebook.ads.internal.protocol.a.a(b2));
            return;
        }
        this.s = new com.facebook.ads.internal.q.b(this.c, new com.facebook.ads.internal.k.c(this.c, false), this.d, this.u != null ? new m(this.u.b(), this.u.a()) : null, this.t, AdSettings.getTestAdType() != AdSettings.TestAdType.DEFAULT ? AdSettings.getTestAdType().getAdTypeString() : null, this.v, AdSettings.isTestMode(this.c), AdSettings.isChildDirected(), g2, com.facebook.ads.internal.s.a.q.a(com.facebook.ads.internal.n.a.t(this.c)), this.C);
        this.f.a(this.s);
    }

    public void a(RewardData rewardData) {
        if (this.p == null) {
            throw new IllegalStateException("no adapter ready to set reward on");
        }
        if (this.p.getPlacementType() != AdPlacementType.REWARDED_VIDEO) {
            throw new IllegalStateException("can only set on rewarded video ads");
        }
        t t2 = (t)this.p;
        t2.a(rewardData);
    }

    public void b() {
        if (this.p == null) {
            com.facebook.ads.internal.s.d.a.a(this.c, "api", com.facebook.ads.internal.s.d.b.e, new com.facebook.ads.internal.protocol.b(AdErrorType.NO_ADAPTER_ON_START, "Adapter is null on startAd"));
            this.a.a(com.facebook.ads.internal.protocol.a.a(AdErrorType.INTERNAL_ERROR, AdErrorType.INTERNAL_ERROR.getDefaultErrorMessage()));
            return;
        }
        if (this.n) {
            com.facebook.ads.internal.s.d.a.a(this.c, "api", com.facebook.ads.internal.s.d.b.c, new com.facebook.ads.internal.protocol.b(AdErrorType.AD_ALREADY_STARTED, "ad already started"));
            this.a.a(com.facebook.ads.internal.protocol.a.a(AdErrorType.AD_ALREADY_STARTED, AdErrorType.AD_ALREADY_STARTED.getDefaultErrorMessage()));
            return;
        }
        this.n = true;
        AdPlacementType adPlacementType = this.p.getPlacementType();
        switch (adPlacementType) {
            case INTERSTITIAL: {
                h h2 = (h)this.p;
                h2.a();
                break;
            }
            case BANNER: {
                if (this.q == null) break;
                this.a.a(this.q);
                break;
            }
            case NATIVE: 
            case NATIVE_BANNER: {
                j j2 = (j)this.p;
                if (!j2.K()) {
                    throw new IllegalStateException("ad is not ready or already displayed");
                }
                this.a.a(j2);
                break;
            }
            case INSTREAM: {
                o o2 = (o)this.p;
                o2.e();
                break;
            }
            case REWARDED_VIDEO: {
                t t2 = (t)this.p;
                t2.a(this.x);
                t2.b();
                break;
            }
            default: {
                Log.e((String)b, (String)"start unexpected adapter type");
            }
        }
    }

    public void c() {
        this.b(false);
    }

    public void b(boolean bl) {
        this.j();
        if (!bl && !this.n) {
            return;
        }
        this.o();
        this.a(this.p);
        this.f.a();
        this.q = null;
        this.n = false;
    }

    public boolean d() {
        return this.r == null || this.r.f();
    }

    @Override
    public synchronized void a(final g g2) {
        com.facebook.ads.internal.protocol.a a2;
        if (com.facebook.ads.internal.n.a.F(this.c) && (a2 = this.e()) != null) {
            Log.e((String)"FBAudienceNetwork", (String)a2.b());
            this.a(a2);
            return;
        }
        this.p().post(new Runnable(){

            @Override
            public void run() {
                com.facebook.ads.internal.j.c c2 = g2.a();
                if (c2 == null || c2.a() == null) {
                    throw new IllegalStateException("invalid placement in response");
                }
                DisplayAdController.this.r = c2;
                DisplayAdController.this.l();
            }
        });
    }

    @Nullable
    com.facebook.ads.internal.protocol.a e() {
        if (this.D != null && this.D != com.facebook.ads.internal.p.d.a) {
            return this.f() ? null : new com.facebook.ads.internal.protocol.a(AdErrorType.CLEAR_TEXT_SUPPORT_NOT_ALLOWED, "");
        }
        if (this.w) {
            return this.f() ? null : new com.facebook.ads.internal.protocol.a(AdErrorType.CLEAR_TEXT_SUPPORT_NOT_ALLOWED, "");
        }
        if (this.B != null && !this.B.contains((Object)CacheFlag.NONE)) {
            return this.f() ? null : new com.facebook.ads.internal.protocol.a(AdErrorType.CLEAR_TEXT_SUPPORT_NOT_ALLOWED, "");
        }
        return null;
    }

    boolean f() {
        boolean bl;
        boolean bl2 = bl = Build.VERSION.SDK_INT < 24 || NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted() || NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted("127.0.0.1");
        if (!bl) {
            com.facebook.ads.internal.s.d.a.a(this.c, "cache", com.facebook.ads.internal.s.d.b.L, new Exception("Cleartext http is not allowed."));
        }
        return bl;
    }

    private synchronized void l() {
        h.post(new Runnable(){

            @Override
            public void run() {
                try {
                    DisplayAdController.this.m();
                }
                catch (Exception exception) {
                    com.facebook.ads.internal.s.d.a.a(DisplayAdController.this.c, "api", com.facebook.ads.internal.s.d.b.k, exception);
                }
            }
        });
    }

    private void m() {
        this.o = null;
        com.facebook.ads.internal.j.c c2 = this.r;
        com.facebook.ads.internal.j.a a2 = c2.e();
        if (a2 == null) {
            this.a.a(com.facebook.ads.internal.protocol.a.a(AdErrorType.NO_FILL, ""));
            this.n();
            return;
        }
        String string = a2.a();
        AdAdapter adAdapter = com.facebook.ads.internal.adapters.d.a(c2.a().b());
        if (adAdapter == null) {
            Log.e((String)b, (String)("Adapter does not exist: " + string));
            this.l();
            return;
        }
        AdPlacementType adPlacementType = this.k();
        if (adPlacementType != adAdapter.getPlacementType()) {
            this.a.a(com.facebook.ads.internal.protocol.a.a(AdErrorType.INTERNAL_ERROR, ""));
            return;
        }
        this.o = adAdapter;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        com.facebook.ads.internal.j.d d2 = c2.a();
        hashMap.put("data", a2.b());
        hashMap.put("definition", d2);
        hashMap.put("placementId", this.d);
        hashMap.put("requestTime", d2.a());
        if (this.s == null) {
            com.facebook.ads.internal.protocol.a a3 = com.facebook.ads.internal.protocol.a.a(AdErrorType.UNKNOWN_ERROR, "environment is empty");
            this.a.a(a3);
            return;
        }
        switch (adAdapter.getPlacementType()) {
            case BANNER: {
                this.a((f)adAdapter, c2, hashMap);
                break;
            }
            case INTERSTITIAL: {
                this.a((h)adAdapter, c2, hashMap);
                break;
            }
            case NATIVE: 
            case NATIVE_BANNER: {
                this.a((j)adAdapter, c2, a2, hashMap);
                break;
            }
            case INSTREAM: {
                this.a((o)adAdapter, c2, hashMap);
                break;
            }
            case REWARDED_VIDEO: {
                this.a((t)adAdapter, c2, hashMap);
                break;
            }
            default: {
                Log.e((String)b, (String)"attempt unexpected adapter type");
            }
        }
    }

    private void a(o o2, com.facebook.ads.internal.j.c c2, Map<String, Object> map) {
        o2.a(this.c, new com.facebook.ads.a.a(){

            @Override
            public void a(o o2) {
                DisplayAdController.this.p = o2;
                DisplayAdController.this.n = false;
                DisplayAdController.this.a.a(o2);
            }

            @Override
            public void a(o o2, View view) {
                DisplayAdController.this.a.a(view);
            }

            @Override
            public void a(o o2, AdError adError) {
                DisplayAdController.this.a.a(new com.facebook.ads.internal.protocol.a(adError.getErrorCode(), adError.getErrorMessage()));
            }

            @Override
            public void b(o o2) {
                DisplayAdController.this.a.a();
            }

            @Override
            public void c(o o2) {
                DisplayAdController.this.a.b();
            }

            @Override
            public void d(o o2) {
                DisplayAdController.this.a.c();
            }
        }, map, this.A, this.B);
    }

    private void a(t t2, com.facebook.ads.internal.j.c c2, Map<String, Object> map) {
        t2.a(this.c, new u(){

            @Override
            public void a(t t2) {
                DisplayAdController.this.p = t2;
                DisplayAdController.this.a.a(t2);
            }

            @Override
            public void a(t t2, AdError adError) {
                DisplayAdController.this.a.a(new com.facebook.ads.internal.protocol.a(AdErrorType.INTERNAL_ERROR, null));
                DisplayAdController.this.a(t2);
                DisplayAdController.this.l();
            }

            @Override
            public void b(t t2) {
                DisplayAdController.this.a.a();
            }

            @Override
            public void c(t t2) {
                DisplayAdController.this.a.b();
            }

            @Override
            public void d(t t2) {
                DisplayAdController.this.a.g();
            }

            @Override
            public void a() {
                DisplayAdController.this.a.h();
            }

            @Override
            public void e(t t2) {
                DisplayAdController.this.a.i();
            }

            @Override
            public void f(t t2) {
                DisplayAdController.this.a.j();
            }

            @Override
            public void b() {
                DisplayAdController.this.a.k();
            }
        }, map, this.w);
    }

    private void a(final f f2, com.facebook.ads.internal.j.c c2, Map<String, Object> map) {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DisplayAdController.this.a(f2);
                DisplayAdController.this.l();
            }
        };
        this.g.postDelayed(runnable, (long)c2.a().j());
        f2.a(this.c, this.A, this.u, new BannerAdapterListener(){

            @Override
            public void onBannerAdLoaded(f f2, View view) {
                if (f2 != DisplayAdController.this.o) {
                    return;
                }
                DisplayAdController.this.g.removeCallbacks(runnable);
                AdAdapter adAdapter = DisplayAdController.this.p;
                DisplayAdController.this.p = f2;
                DisplayAdController.this.q = view;
                if (!DisplayAdController.this.n) {
                    DisplayAdController.this.a.a(f2);
                } else {
                    DisplayAdController.this.a.a(view);
                    DisplayAdController.this.a(adAdapter);
                }
            }

            @Override
            public void onBannerError(f f2, AdError adError) {
                if (f2 != DisplayAdController.this.o) {
                    return;
                }
                DisplayAdController.this.g.removeCallbacks(runnable);
                DisplayAdController.this.a(f2);
                DisplayAdController.this.l();
            }

            @Override
            public void onBannerLoggingImpression(f f2) {
                DisplayAdController.this.a.b();
            }

            @Override
            public void onBannerAdClicked(f f2) {
                DisplayAdController.this.a.a();
            }
        }, map);
    }

    private void a(final h h2, com.facebook.ads.internal.j.c c2, Map<String, Object> map) {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DisplayAdController.this.a(h2);
                DisplayAdController.this.l();
            }
        };
        this.g.postDelayed(runnable, (long)c2.a().j());
        h2.a(this.c, new InterstitialAdapterListener(){

            @Override
            public void onInterstitialAdLoaded(h h2) {
                if (h2 != DisplayAdController.this.o) {
                    return;
                }
                if (h2 == null) {
                    com.facebook.ads.internal.s.d.a.a(DisplayAdController.this.c, "api", com.facebook.ads.internal.s.d.b.b, new com.facebook.ads.internal.protocol.b(AdErrorType.NO_ADAPTER_ON_LOAD, "Adapter is null on loadInterstitialAd"));
                    this.onInterstitialError(h2, AdError.internalError(2004));
                    return;
                }
                DisplayAdController.this.g.removeCallbacks(runnable);
                DisplayAdController.this.p = h2;
                DisplayAdController.this.a.a(h2);
                DisplayAdController.this.n();
            }

            @Override
            public void onInterstitialError(h h2, AdError adError) {
                if (h2 != DisplayAdController.this.o) {
                    return;
                }
                DisplayAdController.this.g.removeCallbacks(runnable);
                DisplayAdController.this.a(h2);
                DisplayAdController.this.l();
                DisplayAdController.this.a.a(new com.facebook.ads.internal.protocol.a(adError.getErrorCode(), adError.getErrorMessage()));
            }

            @Override
            public void onInterstitialLoggingImpression(h h2) {
                DisplayAdController.this.a.b();
            }

            @Override
            public void onInterstitialAdClicked(h h2, String string, boolean bl) {
                boolean bl2;
                DisplayAdController.this.a.a();
                boolean bl3 = bl2 = !TextUtils.isEmpty((CharSequence)string);
                if (bl && bl2) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    if (!(((DisplayAdController)DisplayAdController.this).s.b instanceof Activity)) {
                        intent.addFlags(0x10000000);
                    }
                    intent.setData(Uri.parse((String)string));
                    ((DisplayAdController)DisplayAdController.this).s.b.startActivity(intent);
                }
            }

            @Override
            public void onInterstitialAdDisplayed(h h2) {
                DisplayAdController.this.a.d();
            }

            @Override
            public void onInterstitialAdDismissed(h h2) {
                DisplayAdController.this.a.e();
            }

            @Override
            public void onInterstitialActivityDestroyed() {
                DisplayAdController.this.a.f();
            }
        }, map, this.A, this.B);
    }

    private void a(final j j2, com.facebook.ads.internal.j.c c2, final com.facebook.ads.internal.j.a a2, Map<String, Object> map) {
        final long l2 = System.currentTimeMillis();
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DisplayAdController.this.a(j2);
                Map map = DisplayAdController.this.a(l2);
                map.put("error", "-1");
                map.put("msg", "timeout");
                DisplayAdController.this.a(a2.a(com.facebook.ads.internal.j.e.a), map);
                DisplayAdController.this.l();
            }
        };
        this.g.postDelayed(runnable, (long)c2.a().j());
        j2.a(this.c, new r(){
            boolean a = false;
            boolean b = false;
            boolean c = false;

            @Override
            public void a(j j2) {
                if (j2 != DisplayAdController.this.o) {
                    return;
                }
                DisplayAdController.this.g.removeCallbacks(runnable);
                DisplayAdController.this.p = j2;
                DisplayAdController.this.a.a((AdAdapter)j2);
                if (!this.a) {
                    this.a = true;
                    Map map = DisplayAdController.this.a(l2);
                    DisplayAdController.this.a(a2.a(com.facebook.ads.internal.j.e.a), map);
                }
            }

            @Override
            public void a(j j2, com.facebook.ads.internal.protocol.a a22) {
                if (j2 != DisplayAdController.this.o) {
                    return;
                }
                DisplayAdController.this.g.removeCallbacks(runnable);
                DisplayAdController.this.a(j2);
                if (!this.a) {
                    this.a = true;
                    Map map = DisplayAdController.this.a(l2);
                    map.put("error", String.valueOf(a22.a().getErrorCode()));
                    map.put("msg", String.valueOf(a22.b()));
                    DisplayAdController.this.a(a2.a(com.facebook.ads.internal.j.e.a), map);
                }
                DisplayAdController.this.l();
            }

            @Override
            public void b(j j2) {
                if (!this.b) {
                    this.b = true;
                    DisplayAdController.this.a(a2.a(com.facebook.ads.internal.j.e.b), null);
                }
            }

            @Override
            public void c(j j2) {
                if (!this.c) {
                    this.c = true;
                    DisplayAdController.this.a(a2.a(com.facebook.ads.internal.j.e.c), null);
                }
                if (DisplayAdController.this.a != null) {
                    DisplayAdController.this.a.a();
                }
            }
        }, this.A, map, NativeAdBase.getViewTraversalPredicate());
    }

    @Override
    public synchronized void a(final com.facebook.ads.internal.protocol.a a2) {
        this.p().post(new Runnable(){

            @Override
            public void run() {
                DisplayAdController.this.a.a(a2);
            }
        });
    }

    public com.facebook.ads.internal.o.c g() {
        return this.A;
    }

    private void n() {
        long l2;
        if (this.m || this.l) {
            return;
        }
        switch (this.k()) {
            case INTERSTITIAL: {
                if (com.facebook.ads.internal.s.e.a.a(this.c)) break;
                this.g.postDelayed(this.k, 1000L);
                break;
            }
            default: {
                return;
            }
        }
        long l3 = l2 = this.r == null ? 30000L : this.r.a().c();
        if (l2 > 0L) {
            this.g.postDelayed(this.j, l2);
            this.l = true;
        }
    }

    private void o() {
        if (!this.l) {
            return;
        }
        this.g.removeCallbacks(this.j);
        this.l = false;
    }

    private void a(List<String> list, Map<String, String> map) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (String string : list) {
            new com.facebook.ads.internal.s.c.e(this.c, map).execute(new String[]{string});
        }
    }

    private Map<String, String> a(long l2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("delay", String.valueOf(System.currentTimeMillis() - l2));
        return hashMap;
    }

    private Handler p() {
        if (!DisplayAdController.q()) {
            return this.g;
        }
        return h;
    }

    private static synchronized boolean q() {
        return i;
    }

    protected static synchronized void setMainThreadForced(boolean bl) {
        Log.d((String)b, (String)("DisplayAdController changed main thread forced from " + i + " to " + bl));
        i = bl;
    }

    public AdAdapter h() {
        return this.p;
    }

    static {
        com.facebook.ads.internal.s.a.d.a();
        b = DisplayAdController.class.getSimpleName();
        h = new Handler(Looper.getMainLooper());
        i = false;
    }

    private class c
    extends BroadcastReceiver {
        private c() {
        }

        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            if ("android.intent.action.SCREEN_OFF".equals(string)) {
                DisplayAdController.this.o();
            } else if ("android.intent.action.SCREEN_ON".equals(string)) {
                DisplayAdController.this.n();
            }
        }
    }

    private static final class b
    extends z<DisplayAdController> {
        public b(DisplayAdController displayAdController) {
            super(displayAdController);
        }

        @Override
        public void run() {
            DisplayAdController displayAdController = (DisplayAdController)this.a();
            if (displayAdController == null) {
                return;
            }
            displayAdController.n();
        }
    }

    private static final class a
    extends z<DisplayAdController> {
        public a(DisplayAdController displayAdController) {
            super(displayAdController);
        }

        @Override
        public void run() {
            DisplayAdController displayAdController = (DisplayAdController)this.a();
            if (displayAdController == null) {
                return;
            }
            displayAdController.l = false;
            displayAdController.c(null);
        }
    }
}

