/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.Bundle;
import com.facebook.AppEventsLogger;
import com.facebook.LoggingBehavior;
import com.facebook.internal.Logger;
import java.io.Serializable;

class FacebookTimeSpentData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TAG = AppEventsLogger.class.getCanonicalName();
    private static final long FIRST_TIME_LOAD_RESUME_TIME = -1L;
    private static final long INTERRUPTION_THRESHOLD_MILLISECONDS = 1000L;
    private static final long NUM_MILLISECONDS_IDLE_TO_BE_NEW_SESSION = 60000L;
    private static final long APP_ACTIVATE_SUPPRESSION_PERIOD_IN_MILLISECONDS = 300000L;
    private static final long[] INACTIVE_SECONDS_QUANTA = new long[]{300000L, 900000L, 1800000L, 3600000L, 21600000L, 43200000L, 86400000L, 172800000L, 259200000L, 604800000L, 1209600000L, 1814400000L, 2419200000L, 5184000000L, 7776000000L, 10368000000L, 12960000000L, 15552000000L, 31536000000L};
    private boolean isWarmLaunch;
    private boolean isAppActive;
    private long lastActivateEventLoggedTime;
    private long lastResumeTime;
    private long lastSuspendTime;
    private long millisecondsSpentInSession;
    private int interruptionCount;
    private String firstOpenSourceApplication;

    private FacebookTimeSpentData(long lastResumeTime, long lastSuspendTime, long millisecondsSpentInSession, int interruptionCount) {
        this.resetSession();
        this.lastResumeTime = lastResumeTime;
        this.lastSuspendTime = lastSuspendTime;
        this.millisecondsSpentInSession = millisecondsSpentInSession;
        this.interruptionCount = interruptionCount;
    }

    FacebookTimeSpentData() {
        this.resetSession();
    }

    private FacebookTimeSpentData(long lastResumeTime, long lastSuspendTime, long millisecondsSpentInSession, int interruptionCount, String firstOpenSourceApplication) {
        this.resetSession();
        this.lastResumeTime = lastResumeTime;
        this.lastSuspendTime = lastSuspendTime;
        this.millisecondsSpentInSession = millisecondsSpentInSession;
        this.interruptionCount = interruptionCount;
        this.firstOpenSourceApplication = firstOpenSourceApplication;
    }

    private Object writeReplace() {
        return new SerializationProxyV2(this.lastResumeTime, this.lastSuspendTime, this.millisecondsSpentInSession, this.interruptionCount, this.firstOpenSourceApplication);
    }

    void onSuspend(AppEventsLogger logger, long eventTime) {
        if (!this.isAppActive) {
            Logger.log(LoggingBehavior.APP_EVENTS, TAG, "Suspend for inactive app");
            return;
        }
        long now = eventTime;
        long delta = now - this.lastResumeTime;
        if (delta < 0L) {
            Logger.log(LoggingBehavior.APP_EVENTS, TAG, "Clock skew detected");
            delta = 0L;
        }
        this.millisecondsSpentInSession += delta;
        this.lastSuspendTime = now;
        this.isAppActive = false;
    }

    void onResume(AppEventsLogger logger, long eventTime, String sourceApplicationInfo) {
        long interruptionDurationMillis;
        long now = eventTime;
        if (this.isColdLaunch() || now - this.lastActivateEventLoggedTime > 300000L) {
            Bundle eventParams = new Bundle();
            eventParams.putString("fb_mobile_launch_source", sourceApplicationInfo);
            logger.logEvent("fb_mobile_activate_app", eventParams);
            this.lastActivateEventLoggedTime = now;
        }
        if (this.isAppActive) {
            Logger.log(LoggingBehavior.APP_EVENTS, TAG, "Resume for active app");
            return;
        }
        long l = interruptionDurationMillis = this.wasSuspendedEver() ? now - this.lastSuspendTime : 0L;
        if (interruptionDurationMillis < 0L) {
            Logger.log(LoggingBehavior.APP_EVENTS, TAG, "Clock skew detected");
            interruptionDurationMillis = 0L;
        }
        if (interruptionDurationMillis > 60000L) {
            this.logAppDeactivatedEvent(logger, interruptionDurationMillis);
        } else if (interruptionDurationMillis > 1000L) {
            ++this.interruptionCount;
        }
        if (this.interruptionCount == 0) {
            this.firstOpenSourceApplication = sourceApplicationInfo;
        }
        this.lastResumeTime = now;
        this.isAppActive = true;
    }

    private void logAppDeactivatedEvent(AppEventsLogger logger, long interruptionDurationMillis) {
        Bundle eventParams = new Bundle();
        eventParams.putInt("fb_mobile_app_interruptions", this.interruptionCount);
        eventParams.putString("fb_mobile_time_between_sessions", String.format("session_quanta_%d", FacebookTimeSpentData.getQuantaIndex(interruptionDurationMillis)));
        eventParams.putString("fb_mobile_launch_source", this.firstOpenSourceApplication);
        logger.logEvent("fb_mobile_deactivate_app", this.millisecondsSpentInSession / 1000L, eventParams);
        this.resetSession();
    }

    private static int getQuantaIndex(long timeBetweenSessions) {
        int quantaIndex;
        for (quantaIndex = 0; quantaIndex < INACTIVE_SECONDS_QUANTA.length && INACTIVE_SECONDS_QUANTA[quantaIndex] < timeBetweenSessions; ++quantaIndex) {
        }
        return quantaIndex;
    }

    private void resetSession() {
        this.isAppActive = false;
        this.lastResumeTime = -1L;
        this.lastSuspendTime = -1L;
        this.interruptionCount = 0;
        this.millisecondsSpentInSession = 0L;
    }

    private boolean wasSuspendedEver() {
        return this.lastSuspendTime != -1L;
    }

    private boolean isColdLaunch() {
        boolean result = !this.isWarmLaunch;
        this.isWarmLaunch = true;
        return result;
    }

    private static class SerializationProxyV2
    implements Serializable {
        private static final long serialVersionUID = 6L;
        private final long lastResumeTime;
        private final long lastSuspendTime;
        private final long millisecondsSpentInSession;
        private final int interruptionCount;
        private final String firstOpenSourceApplication;

        SerializationProxyV2(long lastResumeTime, long lastSuspendTime, long millisecondsSpentInSession, int interruptionCount, String firstOpenSourceApplication) {
            this.lastResumeTime = lastResumeTime;
            this.lastSuspendTime = lastSuspendTime;
            this.millisecondsSpentInSession = millisecondsSpentInSession;
            this.interruptionCount = interruptionCount;
            this.firstOpenSourceApplication = firstOpenSourceApplication;
        }

        private Object readResolve() {
            return new FacebookTimeSpentData(this.lastResumeTime, this.lastSuspendTime, this.millisecondsSpentInSession, this.interruptionCount, this.firstOpenSourceApplication);
        }
    }

    private static class SerializationProxyV1
    implements Serializable {
        private static final long serialVersionUID = 6L;
        private final long lastResumeTime;
        private final long lastSuspendTime;
        private final long millisecondsSpentInSession;
        private final int interruptionCount;

        SerializationProxyV1(long lastResumeTime, long lastSuspendTime, long millisecondsSpentInSession, int interruptionCount) {
            this.lastResumeTime = lastResumeTime;
            this.lastSuspendTime = lastSuspendTime;
            this.millisecondsSpentInSession = millisecondsSpentInSession;
            this.interruptionCount = interruptionCount;
        }

        private Object readResolve() {
            return new FacebookTimeSpentData(this.lastResumeTime, this.lastSuspendTime, this.millisecondsSpentInSession, this.interruptionCount);
        }
    }
}

