/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.Handler;
import com.facebook.Request;
import com.facebook.RequestBatch;
import com.facebook.RequestOutputStream;
import com.facebook.RequestProgress;
import com.facebook.Settings;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

class ProgressOutputStream
extends FilterOutputStream
implements RequestOutputStream {
    private final Map<Request, RequestProgress> progressMap;
    private final RequestBatch requests;
    private final long threshold;
    private long batchProgress;
    private long lastReportedProgress;
    private long maxProgress;
    private RequestProgress currentRequestProgress;

    ProgressOutputStream(OutputStream out, RequestBatch requests, Map<Request, RequestProgress> progressMap, long maxProgress) {
        super(out);
        this.requests = requests;
        this.progressMap = progressMap;
        this.maxProgress = maxProgress;
        this.threshold = Settings.getOnProgressThreshold();
    }

    private void addProgress(long size) {
        if (this.currentRequestProgress != null) {
            this.currentRequestProgress.addProgress(size);
        }
        this.batchProgress += size;
        if (this.batchProgress >= this.lastReportedProgress + this.threshold || this.batchProgress >= this.maxProgress) {
            this.reportBatchProgress();
        }
    }

    private void reportBatchProgress() {
        if (this.batchProgress > this.lastReportedProgress) {
            for (RequestBatch.Callback callback : this.requests.getCallbacks()) {
                if (!(callback instanceof RequestBatch.OnProgressCallback)) continue;
                Handler callbackHandler = this.requests.getCallbackHandler();
                final RequestBatch.OnProgressCallback progressCallback = (RequestBatch.OnProgressCallback)callback;
                if (callbackHandler == null) {
                    progressCallback.onBatchProgress(this.requests, this.batchProgress, this.maxProgress);
                    continue;
                }
                callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        progressCallback.onBatchProgress(ProgressOutputStream.this.requests, ProgressOutputStream.this.batchProgress, ProgressOutputStream.this.maxProgress);
                    }
                });
            }
            this.lastReportedProgress = this.batchProgress;
        }
    }

    @Override
    public void setCurrentRequest(Request request) {
        this.currentRequestProgress = request != null ? this.progressMap.get(request) : null;
    }

    long getBatchProgress() {
        return this.batchProgress;
    }

    long getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.out.write(buffer);
        this.addProgress(buffer.length);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.out.write(buffer, offset, length);
        this.addProgress(length);
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.out.write(oneByte);
        this.addProgress(1L);
    }

    @Override
    public void close() throws IOException {
        super.close();
        for (RequestProgress p : this.progressMap.values()) {
            p.reportProgress();
        }
        this.reportBatchProgress();
    }
}

