/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.model;

import com.facebook.model.CreateGraphObject;
import com.facebook.model.GraphObject;
import com.facebook.model.GraphObjectList;
import com.facebook.model.PropertyName;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public interface OpenGraphObject
extends GraphObject {
    public String getId();

    public void setId(String var1);

    public String getType();

    public void setType(String var1);

    public String getUrl();

    public void setUrl(String var1);

    public String getTitle();

    public void setTitle(String var1);

    public String getDescription();

    public void setDescription(String var1);

    public GraphObjectList<GraphObject> getImage();

    public void setImage(GraphObjectList<GraphObject> var1);

    @CreateGraphObject(value="url")
    @PropertyName(value="image")
    public void setImageUrls(List<String> var1);

    public GraphObjectList<GraphObject> getVideo();

    public void setVideo(GraphObjectList<GraphObject> var1);

    public GraphObjectList<GraphObject> getAudio();

    public void setAudio(GraphObjectList<GraphObject> var1);

    public String getDeterminer();

    public void setDeterminer(String var1);

    public List<String> getSeeAlso();

    public void setSeeAlso(List<String> var1);

    public String getSiteName();

    public void setSiteName(String var1);

    public Date getCreatedTime();

    public void setCreatedTime(Date var1);

    public Date getUpdatedTime();

    public void setUpdatedTime(Date var1);

    public GraphObject getApplication();

    public void setApplication(GraphObject var1);

    public boolean getIsScraped();

    public void setIsScraped(boolean var1);

    public String getPostActionId();

    public void setPostActionId(String var1);

    public GraphObject getData();

    public void setData(GraphObject var1);

    @PropertyName(value="fbsdk:create_object")
    public boolean getCreateObject();

    @PropertyName(value="fbsdk:create_object")
    public void setCreateObject(boolean var1);

    public static final class Factory {
        public static OpenGraphObject createForPost(String type) {
            return Factory.createForPost(OpenGraphObject.class, type);
        }

        public static <T extends OpenGraphObject> T createForPost(Class<T> graphObjectClass, String type) {
            return Factory.createForPost(graphObjectClass, type, null, null, null, null);
        }

        public static <T extends OpenGraphObject> T createForPost(Class<T> graphObjectClass, String type, String title, String imageUrl, String url, String description) {
            OpenGraphObject object = (OpenGraphObject)GraphObject.Factory.create(graphObjectClass);
            if (type != null) {
                object.setType(type);
            }
            if (title != null) {
                object.setTitle(title);
            }
            if (imageUrl != null) {
                object.setImageUrls(Arrays.asList(imageUrl));
            }
            if (url != null) {
                object.setUrl(url);
            }
            if (description != null) {
                object.setDescription(description);
            }
            object.setCreateObject(true);
            object.setData(GraphObject.Factory.create());
            return (T)object;
        }
    }
}

