/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.R;
import com.facebook.internal.Validate;
import com.facebook.share.internal.WebDialogParameters;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareOpenGraphContent;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceShareDialogFragment
extends DialogFragment {
    public static final String TAG = "DeviceShareDialogFragment";
    private static final String DEVICE_SHARE_ENDPOINT = "device/share";
    private static final String REQUEST_STATE_KEY = "request_state";
    private ProgressBar progressBar;
    private TextView confirmationCode;
    private Dialog dialog;
    private volatile RequestState currentRequestState;
    private volatile ScheduledFuture codeExpiredFuture;
    private static ScheduledThreadPoolExecutor backgroundExecutor;
    private ShareContent shareContent;

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        RequestState requestState;
        View view = super.onCreateView(inflater, container, savedInstanceState);
        if (savedInstanceState != null && (requestState = (RequestState)savedInstanceState.getParcelable(REQUEST_STATE_KEY)) != null) {
            this.setCurrentRequestState(requestState);
        }
        return view;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        this.dialog = new Dialog((Context)this.getActivity(), R.style.com_facebook_auth_dialog);
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        View view = inflater.inflate(R.layout.com_facebook_device_auth_dialog_fragment, null);
        this.progressBar = (ProgressBar)view.findViewById(R.id.progress_bar);
        this.confirmationCode = (TextView)view.findViewById(R.id.confirmation_code);
        Button cancelButton = (Button)view.findViewById(R.id.cancel_button);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DeviceShareDialogFragment.this.dialog.dismiss();
            }
        });
        TextView instructions = (TextView)view.findViewById(R.id.com_facebook_device_auth_instructions);
        instructions.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.com_facebook_device_auth_instructions)));
        this.dialog.setContentView(view);
        this.startShare();
        return this.dialog;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.codeExpiredFuture != null) {
            this.codeExpiredFuture.cancel(true);
        }
        Intent resultIntent = new Intent();
        this.finishActivity(-1, resultIntent);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.currentRequestState != null) {
            outState.putParcelable(REQUEST_STATE_KEY, (Parcelable)this.currentRequestState);
        }
    }

    private void finishActivity(int resultCode, Intent data) {
        if (this.isAdded()) {
            FragmentActivity activity = this.getActivity();
            activity.setResult(resultCode, data);
            activity.finish();
        }
    }

    private void detach() {
        if (this.isAdded()) {
            this.getFragmentManager().beginTransaction().remove((Fragment)this).commit();
        }
    }

    public void setShareContent(ShareContent shareContent) {
        this.shareContent = shareContent;
    }

    private Bundle getGraphParametersForShareContent() {
        ShareContent content = this.shareContent;
        if (content == null) {
            return null;
        }
        if (content instanceof ShareLinkContent) {
            return WebDialogParameters.create((ShareLinkContent)content);
        }
        if (content instanceof ShareOpenGraphContent) {
            return WebDialogParameters.create((ShareOpenGraphContent)content);
        }
        return null;
    }

    private void startShare() {
        Bundle parameters = this.getGraphParametersForShareContent();
        if (parameters == null || parameters.size() == 0) {
            this.finishActivityWithError(new FacebookRequestError(0, "", "Failed to get share content"));
        }
        String accessToken = Validate.hasAppID() + "|" + Validate.hasClientToken();
        parameters.putString("access_token", accessToken);
        GraphRequest graphRequest = new GraphRequest(null, DEVICE_SHARE_ENDPOINT, parameters, HttpMethod.POST, new GraphRequest.Callback(){

            @Override
            public void onCompleted(GraphResponse response) {
                FacebookRequestError error = response.getError();
                if (error != null) {
                    DeviceShareDialogFragment.this.finishActivityWithError(error);
                    return;
                }
                JSONObject jsonObject = response.getJSONObject();
                RequestState requestState = new RequestState();
                try {
                    requestState.setUserCode(jsonObject.getString("user_code"));
                    requestState.setExpiresIn(jsonObject.getLong("expires_in"));
                }
                catch (JSONException ex) {
                    DeviceShareDialogFragment.this.finishActivityWithError(new FacebookRequestError(0, "", "Malformed server response"));
                    return;
                }
                DeviceShareDialogFragment.this.setCurrentRequestState(requestState);
            }
        });
        graphRequest.executeAsync();
    }

    private void finishActivityWithError(FacebookRequestError error) {
        this.detach();
        Intent intent = new Intent();
        intent.putExtra("error", (Parcelable)error);
        this.finishActivity(-1, intent);
    }

    private static synchronized ScheduledThreadPoolExecutor getBackgroundExecutor() {
        if (backgroundExecutor == null) {
            backgroundExecutor = new ScheduledThreadPoolExecutor(1);
        }
        return backgroundExecutor;
    }

    private void setCurrentRequestState(RequestState currentRequestState) {
        this.currentRequestState = currentRequestState;
        this.confirmationCode.setText((CharSequence)currentRequestState.getUserCode());
        this.confirmationCode.setVisibility(0);
        this.progressBar.setVisibility(8);
        this.codeExpiredFuture = DeviceShareDialogFragment.getBackgroundExecutor().schedule(new Runnable(){

            @Override
            public void run() {
                DeviceShareDialogFragment.this.dialog.dismiss();
            }
        }, currentRequestState.getExpiresIn(), TimeUnit.SECONDS);
    }

    private static class RequestState
    implements Parcelable {
        private String userCode;
        private long expiresIn;
        public static final Parcelable.Creator<RequestState> CREATOR = new Parcelable.Creator<RequestState>(){

            public RequestState createFromParcel(Parcel in) {
                return new RequestState(in);
            }

            public RequestState[] newArray(int size) {
                return new RequestState[size];
            }
        };

        RequestState() {
        }

        public String getUserCode() {
            return this.userCode;
        }

        public void setUserCode(String userCode) {
            this.userCode = userCode;
        }

        public long getExpiresIn() {
            return this.expiresIn;
        }

        public void setExpiresIn(long expiresIn) {
            this.expiresIn = expiresIn;
        }

        protected RequestState(Parcel in) {
            this.userCode = in.readString();
            this.expiresIn = in.readLong();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.userCode);
            dest.writeLong(this.expiresIn);
        }
    }
}

