/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.facebook.R;

public class LikeBoxCountView
extends FrameLayout {
    private TextView likeCountLabel;
    private LikeBoxCountViewCaretPosition caretPosition = LikeBoxCountViewCaretPosition.LEFT;
    private float caretHeight;
    private float caretWidth;
    private float borderRadius;
    private Paint borderPaint;
    private int textPadding;
    private int additionalTextPadding;

    public LikeBoxCountView(Context context) {
        super(context);
        this.initialize(context);
    }

    public void setText(String text) {
        this.likeCountLabel.setText((CharSequence)text);
    }

    public void setCaretPosition(LikeBoxCountViewCaretPosition caretPosition) {
        this.caretPosition = caretPosition;
        switch (caretPosition) {
            case LEFT: {
                this.setAdditionalTextPadding(this.additionalTextPadding, 0, 0, 0);
                break;
            }
            case TOP: {
                this.setAdditionalTextPadding(0, this.additionalTextPadding, 0, 0);
                break;
            }
            case RIGHT: {
                this.setAdditionalTextPadding(0, 0, this.additionalTextPadding, 0);
                break;
            }
            case BOTTOM: {
                this.setAdditionalTextPadding(0, 0, 0, this.additionalTextPadding);
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int top = this.getPaddingTop();
        int left = this.getPaddingLeft();
        int right = this.getWidth() - this.getPaddingRight();
        int bottom = this.getHeight() - this.getPaddingBottom();
        switch (this.caretPosition) {
            case BOTTOM: {
                bottom = (int)((float)bottom - this.caretHeight);
                break;
            }
            case LEFT: {
                left = (int)((float)left + this.caretHeight);
                break;
            }
            case TOP: {
                top = (int)((float)top + this.caretHeight);
                break;
            }
            case RIGHT: {
                right = (int)((float)right - this.caretHeight);
            }
        }
        this.drawBorder(canvas, left, top, right, bottom);
    }

    private void initialize(Context context) {
        this.setWillNotDraw(false);
        this.caretHeight = this.getResources().getDimension(R.dimen.com_facebook_likeboxcountview_caret_height);
        this.caretWidth = this.getResources().getDimension(R.dimen.com_facebook_likeboxcountview_caret_width);
        this.borderRadius = this.getResources().getDimension(R.dimen.com_facebook_likeboxcountview_border_radius);
        this.borderPaint = new Paint();
        this.borderPaint.setColor(this.getResources().getColor(R.color.com_facebook_likeboxcountview_border_color));
        this.borderPaint.setStrokeWidth(this.getResources().getDimension(R.dimen.com_facebook_likeboxcountview_border_width));
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.initializeLikeCountLabel(context);
        this.addView((View)this.likeCountLabel);
        this.setCaretPosition(this.caretPosition);
    }

    private void initializeLikeCountLabel(Context context) {
        this.likeCountLabel = new TextView(context);
        FrameLayout.LayoutParams likeCountLabelLayoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.likeCountLabel.setLayoutParams((ViewGroup.LayoutParams)likeCountLabelLayoutParams);
        this.likeCountLabel.setGravity(17);
        this.likeCountLabel.setTextSize(0, this.getResources().getDimension(R.dimen.com_facebook_likeboxcountview_text_size));
        this.likeCountLabel.setTextColor(this.getResources().getColor(R.color.com_facebook_likeboxcountview_text_color));
        this.textPadding = this.getResources().getDimensionPixelSize(R.dimen.com_facebook_likeboxcountview_text_padding);
        this.additionalTextPadding = this.getResources().getDimensionPixelSize(R.dimen.com_facebook_likeboxcountview_caret_height);
    }

    private void setAdditionalTextPadding(int left, int top, int right, int bottom) {
        this.likeCountLabel.setPadding(this.textPadding + left, this.textPadding + top, this.textPadding + right, this.textPadding + bottom);
    }

    private void drawBorder(Canvas canvas, float left, float top, float right, float bottom) {
        Path borderPath = new Path();
        float ovalSize = 2.0f * this.borderRadius;
        borderPath.addArc(new RectF(left, top, left + ovalSize, top + ovalSize), -180.0f, 90.0f);
        if (this.caretPosition == LikeBoxCountViewCaretPosition.TOP) {
            borderPath.lineTo(left + (right - left - this.caretWidth) / 2.0f, top);
            borderPath.lineTo(left + (right - left) / 2.0f, top - this.caretHeight);
            borderPath.lineTo(left + (right - left + this.caretWidth) / 2.0f, top);
        }
        borderPath.lineTo(right - this.borderRadius, top);
        borderPath.addArc(new RectF(right - ovalSize, top, right, top + ovalSize), -90.0f, 90.0f);
        if (this.caretPosition == LikeBoxCountViewCaretPosition.RIGHT) {
            borderPath.lineTo(right, top + (bottom - top - this.caretWidth) / 2.0f);
            borderPath.lineTo(right + this.caretHeight, top + (bottom - top) / 2.0f);
            borderPath.lineTo(right, top + (bottom - top + this.caretWidth) / 2.0f);
        }
        borderPath.lineTo(right, bottom - this.borderRadius);
        borderPath.addArc(new RectF(right - ovalSize, bottom - ovalSize, right, bottom), 0.0f, 90.0f);
        if (this.caretPosition == LikeBoxCountViewCaretPosition.BOTTOM) {
            borderPath.lineTo(left + (right - left + this.caretWidth) / 2.0f, bottom);
            borderPath.lineTo(left + (right - left) / 2.0f, bottom + this.caretHeight);
            borderPath.lineTo(left + (right - left - this.caretWidth) / 2.0f, bottom);
        }
        borderPath.lineTo(left + this.borderRadius, bottom);
        borderPath.addArc(new RectF(left, bottom - ovalSize, left + ovalSize, bottom), 90.0f, 90.0f);
        if (this.caretPosition == LikeBoxCountViewCaretPosition.LEFT) {
            borderPath.lineTo(left, top + (bottom - top + this.caretWidth) / 2.0f);
            borderPath.lineTo(left - this.caretHeight, top + (bottom - top) / 2.0f);
            borderPath.lineTo(left, top + (bottom - top - this.caretWidth) / 2.0f);
        }
        borderPath.lineTo(left, top + this.borderRadius);
        canvas.drawPath(borderPath, this.borderPaint);
    }

    public static enum LikeBoxCountViewCaretPosition {
        LEFT,
        TOP,
        RIGHT,
        BOTTOM;

    }
}

