/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.applinks;

import android.net.Uri;
import android.os.Bundle;
import bolts.AppLink;
import bolts.AppLinkResolver;
import bolts.Continuation;
import bolts.Task;
import com.facebook.AccessToken;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FacebookAppLinkResolver
implements AppLinkResolver {
    private static final String APP_LINK_KEY = "app_links";
    private static final String APP_LINK_ANDROID_TARGET_KEY = "android";
    private static final String APP_LINK_WEB_TARGET_KEY = "web";
    private static final String APP_LINK_TARGET_PACKAGE_KEY = "package";
    private static final String APP_LINK_TARGET_CLASS_KEY = "class";
    private static final String APP_LINK_TARGET_APP_NAME_KEY = "app_name";
    private static final String APP_LINK_TARGET_URL_KEY = "url";
    private static final String APP_LINK_TARGET_SHOULD_FALLBACK_KEY = "should_fallback";
    private final HashMap<Uri, AppLink> cachedAppLinks = new HashMap();

    public Task<AppLink> getAppLinkFromUrlInBackground(final Uri uri) {
        ArrayList<Uri> uris = new ArrayList<Uri>();
        uris.add(uri);
        Task<Map<Uri, AppLink>> resolveTask = this.getAppLinkFromUrlsInBackground(uris);
        return resolveTask.onSuccess((Continuation)new Continuation<Map<Uri, AppLink>, AppLink>(){

            public AppLink then(Task<Map<Uri, AppLink>> resolveUrisTask) throws Exception {
                return (AppLink)((Map)resolveUrisTask.getResult()).get(uri);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Map<Uri, AppLink>> getAppLinkFromUrlsInBackground(List<Uri> uris) {
        final HashMap<Uri, AppLink> appLinkResults = new HashMap<Uri, AppLink>();
        final HashSet<Uri> urisToRequest = new HashSet<Uri>();
        StringBuilder graphRequestFields = new StringBuilder();
        for (Uri uri : uris) {
            AppLink appLink;
            HashMap<Uri, AppLink> hashMap = this.cachedAppLinks;
            synchronized (hashMap) {
                appLink = this.cachedAppLinks.get(uri);
            }
            if (appLink != null) {
                appLinkResults.put(uri, appLink);
                continue;
            }
            if (!urisToRequest.isEmpty()) {
                graphRequestFields.append(',');
            }
            graphRequestFields.append(uri.toString());
            urisToRequest.add(uri);
        }
        if (urisToRequest.isEmpty()) {
            return Task.forResult(appLinkResults);
        }
        final Task.TaskCompletionSource taskCompletionSource = Task.create();
        Bundle appLinkRequestParameters = new Bundle();
        appLinkRequestParameters.putString("ids", graphRequestFields.toString());
        appLinkRequestParameters.putString("fields", String.format("%s.fields(%s,%s)", APP_LINK_KEY, APP_LINK_ANDROID_TARGET_KEY, APP_LINK_WEB_TARGET_KEY));
        GraphRequest appLinkRequest = new GraphRequest(AccessToken.getCurrentAccessToken(), "", appLinkRequestParameters, null, new GraphRequest.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompleted(GraphResponse response) {
                FacebookRequestError error = response.getError();
                if (error != null) {
                    taskCompletionSource.setError((Exception)((Object)error.getException()));
                    return;
                }
                JSONObject responseJson = response.getJSONObject();
                if (responseJson == null) {
                    taskCompletionSource.setResult((Object)appLinkResults);
                    return;
                }
                for (Uri uri : urisToRequest) {
                    String uriString = uri.toString();
                    if (!responseJson.has(uriString)) continue;
                    try {
                        JSONObject urlData = responseJson.getJSONObject(uri.toString());
                        JSONObject appLinkData = urlData.getJSONObject(FacebookAppLinkResolver.APP_LINK_KEY);
                        JSONArray rawTargets = appLinkData.getJSONArray(FacebookAppLinkResolver.APP_LINK_ANDROID_TARGET_KEY);
                        int targetsCount = rawTargets.length();
                        ArrayList<AppLink.Target> targets = new ArrayList<AppLink.Target>(targetsCount);
                        for (int i = 0; i < targetsCount; ++i) {
                            AppLink.Target target = FacebookAppLinkResolver.getAndroidTargetFromJson(rawTargets.getJSONObject(i));
                            if (target == null) continue;
                            targets.add(target);
                        }
                        Uri webFallbackUrl = FacebookAppLinkResolver.getWebFallbackUriFromJson(uri, appLinkData);
                        AppLink appLink = new AppLink(uri, targets, webFallbackUrl);
                        appLinkResults.put(uri, appLink);
                        HashMap hashMap = FacebookAppLinkResolver.this.cachedAppLinks;
                        synchronized (hashMap) {
                            FacebookAppLinkResolver.this.cachedAppLinks.put(uri, appLink);
                        }
                    }
                    catch (JSONException e) {
                    }
                }
                taskCompletionSource.setResult((Object)appLinkResults);
            }
        });
        appLinkRequest.executeAsync();
        return taskCompletionSource.getTask();
    }

    private static AppLink.Target getAndroidTargetFromJson(JSONObject targetJson) {
        String packageName = FacebookAppLinkResolver.tryGetStringFromJson(targetJson, APP_LINK_TARGET_PACKAGE_KEY, null);
        if (packageName == null) {
            return null;
        }
        String className = FacebookAppLinkResolver.tryGetStringFromJson(targetJson, APP_LINK_TARGET_CLASS_KEY, null);
        String appName = FacebookAppLinkResolver.tryGetStringFromJson(targetJson, APP_LINK_TARGET_APP_NAME_KEY, null);
        String targetUrlString = FacebookAppLinkResolver.tryGetStringFromJson(targetJson, APP_LINK_TARGET_URL_KEY, null);
        Uri targetUri = null;
        if (targetUrlString != null) {
            targetUri = Uri.parse((String)targetUrlString);
        }
        return new AppLink.Target(packageName, className, targetUri, appName);
    }

    private static Uri getWebFallbackUriFromJson(Uri sourceUrl, JSONObject urlData) {
        try {
            JSONObject webTarget = urlData.getJSONObject(APP_LINK_WEB_TARGET_KEY);
            boolean shouldFallback = FacebookAppLinkResolver.tryGetBooleanFromJson(webTarget, APP_LINK_TARGET_SHOULD_FALLBACK_KEY, true);
            if (!shouldFallback) {
                return null;
            }
            String webTargetUrlString = FacebookAppLinkResolver.tryGetStringFromJson(webTarget, APP_LINK_TARGET_URL_KEY, null);
            Uri webUri = null;
            if (webTargetUrlString != null) {
                webUri = Uri.parse((String)webTargetUrlString);
            }
            return webUri != null ? webUri : sourceUrl;
        }
        catch (JSONException e) {
            return sourceUrl;
        }
    }

    private static String tryGetStringFromJson(JSONObject json, String propertyName, String defaultValue) {
        try {
            return json.getString(propertyName);
        }
        catch (JSONException e) {
            return defaultValue;
        }
    }

    private static boolean tryGetBooleanFromJson(JSONObject json, String propertyName, boolean defaultValue) {
        try {
            return json.getBoolean(propertyName);
        }
        catch (JSONException e) {
            return defaultValue;
        }
    }
}

