/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.applinks;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppLinkData {
    public static final String ARGUMENTS_TAPTIME_KEY = "com.facebook.platform.APPLINK_TAP_TIME_UTC";
    public static final String ARGUMENTS_REFERER_DATA_KEY = "referer_data";
    public static final String ARGUMENTS_EXTRAS_KEY = "extras";
    public static final String ARGUMENTS_NATIVE_CLASS_KEY = "com.facebook.platform.APPLINK_NATIVE_CLASS";
    public static final String ARGUMENTS_NATIVE_URL = "com.facebook.platform.APPLINK_NATIVE_URL";
    private static final String BUNDLE_APPLINK_ARGS_KEY = "com.facebook.platform.APPLINK_ARGS";
    private static final String BUNDLE_AL_APPLINK_DATA_KEY = "al_applink_data";
    private static final String APPLINK_BRIDGE_ARGS_KEY = "bridge_args";
    private static final String APPLINK_METHOD_ARGS_KEY = "method_args";
    private static final String APPLINK_VERSION_KEY = "version";
    private static final String BRIDGE_ARGS_METHOD_KEY = "method";
    private static final String DEFERRED_APP_LINK_EVENT = "DEFERRED_APP_LINK";
    private static final String DEFERRED_APP_LINK_PATH = "%s/activities";
    private static final String DEFERRED_APP_LINK_ARGS_FIELD = "applink_args";
    private static final String DEFERRED_APP_LINK_CLASS_FIELD = "applink_class";
    private static final String DEFERRED_APP_LINK_CLICK_TIME_FIELD = "click_time";
    private static final String DEFERRED_APP_LINK_URL_FIELD = "applink_url";
    private static final String AUTO_APPLINK_FLAG_KEY = "is_auto_applink";
    private static final String METHOD_ARGS_TARGET_URL_KEY = "target_url";
    private static final String METHOD_ARGS_REF_KEY = "ref";
    private static final String REFERER_DATA_REF_KEY = "fb_ref";
    private static final String EXTRAS_DEEPLINK_CONTEXT_KEY = "deeplink_context";
    private static final String PROMOTION_CODE_KEY = "promo_code";
    private static final String TAG = AppLinkData.class.getCanonicalName();
    @Nullable
    private String ref;
    @Nullable
    private Uri targetUri;
    @Nullable
    private JSONObject arguments;
    @Nullable
    private Bundle argumentBundle;
    @Nullable
    private String promotionCode;
    @Nullable
    private JSONObject appLinkData;

    public static void fetchDeferredAppLinkData(Context context, CompletionHandler completionHandler) {
        AppLinkData.fetchDeferredAppLinkData(context, null, completionHandler);
    }

    public static void fetchDeferredAppLinkData(Context context, String applicationId, final CompletionHandler completionHandler) {
        Validate.notNull((Object)context, (String)"context");
        Validate.notNull((Object)completionHandler, (String)"completionHandler");
        if (applicationId == null) {
            applicationId = Utility.getMetadataApplicationId((Context)context);
        }
        Validate.notNull((Object)applicationId, (String)"applicationId");
        final Context applicationContext = context.getApplicationContext();
        final String applicationIdCopy = applicationId;
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                    return;
                }
                try {
                    AppLinkData.fetchDeferredAppLinkFromServer(applicationContext, applicationIdCopy, completionHandler);
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                    return;
                }
            }
        });
    }

    private static void fetchDeferredAppLinkFromServer(Context context, String applicationId, CompletionHandler completionHandler) {
        AppLinkData appLinkData;
        block18: {
            JSONObject deferredApplinkParams = new JSONObject();
            try {
                deferredApplinkParams.put("event", (Object)DEFERRED_APP_LINK_EVENT);
                Utility.setAppEventAttributionParameters((JSONObject)deferredApplinkParams, (AttributionIdentifiers)AttributionIdentifiers.getAttributionIdentifiers((Context)context), (String)AppEventsLogger.getAnonymousAppDeviceGUID((Context)context), (boolean)FacebookSdk.getLimitEventAndDataUsage((Context)context));
                Utility.setAppEventExtendedDeviceInfoParameters((JSONObject)deferredApplinkParams, (Context)FacebookSdk.getApplicationContext());
                deferredApplinkParams.put("application_package_name", (Object)context.getPackageName());
            }
            catch (JSONException e) {
                throw new FacebookException("An error occurred while preparing deferred app link", (Throwable)e);
            }
            String deferredApplinkUrlPath = String.format(DEFERRED_APP_LINK_PATH, applicationId);
            appLinkData = null;
            try {
                GraphRequest deferredApplinkRequest = GraphRequest.newPostRequest(null, (String)deferredApplinkUrlPath, (JSONObject)deferredApplinkParams, null);
                GraphResponse deferredApplinkResponse = deferredApplinkRequest.executeAndWait();
                JSONObject jsonResponse = deferredApplinkResponse.getJSONObject();
                if (jsonResponse == null) break block18;
                String appLinkArgsJsonString = jsonResponse.optString(DEFERRED_APP_LINK_ARGS_FIELD);
                long tapTimeUtc = jsonResponse.optLong(DEFERRED_APP_LINK_CLICK_TIME_FIELD, -1L);
                String appLinkClassName = jsonResponse.optString(DEFERRED_APP_LINK_CLASS_FIELD);
                String appLinkUrl = jsonResponse.optString(DEFERRED_APP_LINK_URL_FIELD);
                if (TextUtils.isEmpty((CharSequence)appLinkArgsJsonString) || (appLinkData = AppLinkData.createFromJson(appLinkArgsJsonString)) == null) break block18;
                if (tapTimeUtc != -1L) {
                    try {
                        if (appLinkData.arguments != null) {
                            appLinkData.arguments.put(ARGUMENTS_TAPTIME_KEY, tapTimeUtc);
                        }
                        if (appLinkData.argumentBundle != null) {
                            appLinkData.argumentBundle.putString(ARGUMENTS_TAPTIME_KEY, Long.toString(tapTimeUtc));
                        }
                    }
                    catch (JSONException e) {
                        Utility.logd((String)TAG, (String)"Unable to put tap time in AppLinkData.arguments");
                    }
                }
                if (appLinkClassName != null) {
                    try {
                        if (appLinkData.arguments != null) {
                            appLinkData.arguments.put(ARGUMENTS_NATIVE_CLASS_KEY, (Object)appLinkClassName);
                        }
                        if (appLinkData.argumentBundle != null) {
                            appLinkData.argumentBundle.putString(ARGUMENTS_NATIVE_CLASS_KEY, appLinkClassName);
                        }
                    }
                    catch (JSONException e) {
                        Utility.logd((String)TAG, (String)"Unable to put app link class name in AppLinkData.arguments");
                    }
                }
                if (appLinkUrl == null) break block18;
                try {
                    if (appLinkData.arguments != null) {
                        appLinkData.arguments.put(ARGUMENTS_NATIVE_URL, (Object)appLinkUrl);
                    }
                    if (appLinkData.argumentBundle != null) {
                        appLinkData.argumentBundle.putString(ARGUMENTS_NATIVE_URL, appLinkUrl);
                    }
                }
                catch (JSONException e) {
                    Utility.logd((String)TAG, (String)"Unable to put app link URL in AppLinkData.arguments");
                }
            }
            catch (Exception e) {
                Utility.logd((String)TAG, (String)"Unable to fetch deferred applink from server");
            }
        }
        completionHandler.onDeferredAppLinkDataFetched(appLinkData);
    }

    @Nullable
    public static AppLinkData createFromActivity(Activity activity) {
        Validate.notNull((Object)activity, (String)"activity");
        Intent intent = activity.getIntent();
        if (intent == null) {
            return null;
        }
        AppLinkData appLinkData = AppLinkData.createFromAlApplinkData(intent);
        if (appLinkData == null) {
            String appLinkArgsJsonString = intent.getStringExtra(BUNDLE_APPLINK_ARGS_KEY);
            appLinkData = AppLinkData.createFromJson(appLinkArgsJsonString);
        }
        if (appLinkData == null) {
            appLinkData = AppLinkData.createFromUri(intent.getData());
        }
        return appLinkData;
    }

    @Nullable
    public static AppLinkData createFromAlApplinkData(Intent intent) {
        String deeplinkContext;
        Bundle extras;
        String targetUriString;
        if (intent == null) {
            return null;
        }
        Bundle applinks = intent.getBundleExtra(BUNDLE_AL_APPLINK_DATA_KEY);
        if (applinks == null) {
            return null;
        }
        AppLinkData appLinkData = new AppLinkData();
        appLinkData.targetUri = intent.getData();
        appLinkData.appLinkData = AppLinkData.getAppLinkData(appLinkData.targetUri);
        if (appLinkData.targetUri == null && (targetUriString = applinks.getString(METHOD_ARGS_TARGET_URL_KEY)) != null) {
            appLinkData.targetUri = Uri.parse((String)targetUriString);
        }
        appLinkData.argumentBundle = applinks;
        appLinkData.arguments = null;
        Bundle refererData = applinks.getBundle(ARGUMENTS_REFERER_DATA_KEY);
        if (refererData != null) {
            appLinkData.ref = refererData.getString(REFERER_DATA_REF_KEY);
        }
        if ((extras = applinks.getBundle(ARGUMENTS_EXTRAS_KEY)) != null && (deeplinkContext = extras.getString(EXTRAS_DEEPLINK_CONTEXT_KEY)) != null) {
            try {
                JSONObject dlContextJson = new JSONObject(deeplinkContext);
                if (dlContextJson.has(PROMOTION_CODE_KEY)) {
                    appLinkData.promotionCode = dlContextJson.getString(PROMOTION_CODE_KEY);
                }
            }
            catch (JSONException e) {
                Utility.logd((String)TAG, (String)"Unable to parse deeplink_context JSON", (Throwable)e);
            }
        }
        return appLinkData;
    }

    @Nullable
    private static AppLinkData createFromJson(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        try {
            JSONObject appLinkArgsJson = new JSONObject(jsonString);
            String version = appLinkArgsJson.getString(APPLINK_VERSION_KEY);
            JSONObject bridgeArgs = appLinkArgsJson.getJSONObject(APPLINK_BRIDGE_ARGS_KEY);
            String method = bridgeArgs.getString(BRIDGE_ARGS_METHOD_KEY);
            if (method.equals("applink") && version.equals("2")) {
                JSONObject deeplink_context;
                JSONObject extrasData;
                JSONObject refererData;
                AppLinkData appLinkData = new AppLinkData();
                appLinkData.arguments = appLinkArgsJson.getJSONObject(APPLINK_METHOD_ARGS_KEY);
                if (appLinkData.arguments.has(METHOD_ARGS_REF_KEY)) {
                    appLinkData.ref = appLinkData.arguments.getString(METHOD_ARGS_REF_KEY);
                } else if (appLinkData.arguments.has(ARGUMENTS_REFERER_DATA_KEY) && (refererData = appLinkData.arguments.getJSONObject(ARGUMENTS_REFERER_DATA_KEY)).has(REFERER_DATA_REF_KEY)) {
                    appLinkData.ref = refererData.getString(REFERER_DATA_REF_KEY);
                }
                if (appLinkData.arguments.has(METHOD_ARGS_TARGET_URL_KEY)) {
                    appLinkData.targetUri = Uri.parse((String)appLinkData.arguments.getString(METHOD_ARGS_TARGET_URL_KEY));
                    appLinkData.appLinkData = AppLinkData.getAppLinkData(appLinkData.targetUri);
                }
                if (appLinkData.arguments.has(ARGUMENTS_EXTRAS_KEY) && (extrasData = appLinkData.arguments.getJSONObject(ARGUMENTS_EXTRAS_KEY)).has(EXTRAS_DEEPLINK_CONTEXT_KEY) && (deeplink_context = extrasData.getJSONObject(EXTRAS_DEEPLINK_CONTEXT_KEY)).has(PROMOTION_CODE_KEY)) {
                    appLinkData.promotionCode = deeplink_context.getString(PROMOTION_CODE_KEY);
                }
                appLinkData.argumentBundle = AppLinkData.toBundle(appLinkData.arguments);
                return appLinkData;
            }
        }
        catch (JSONException e) {
            Utility.logd((String)TAG, (String)"Unable to parse AppLink JSON", (Throwable)e);
        }
        catch (FacebookException e) {
            Utility.logd((String)TAG, (String)"Unable to parse AppLink JSON", (Throwable)e);
        }
        return null;
    }

    @Nullable
    private static AppLinkData createFromUri(Uri appLinkDataUri) {
        if (appLinkDataUri == null) {
            return null;
        }
        AppLinkData appLinkData = new AppLinkData();
        appLinkData.targetUri = appLinkDataUri;
        appLinkData.appLinkData = AppLinkData.getAppLinkData(appLinkData.targetUri);
        return appLinkData;
    }

    private static Bundle toBundle(JSONObject node) throws JSONException {
        Bundle bundle = new Bundle();
        Iterator fields = node.keys();
        while (fields.hasNext()) {
            String key = (String)fields.next();
            Object value = node.get(key);
            if (value instanceof JSONObject) {
                bundle.putBundle(key, AppLinkData.toBundle((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                int i;
                JSONArray valueArr = (JSONArray)value;
                if (valueArr.length() == 0) {
                    bundle.putStringArray(key, new String[0]);
                    continue;
                }
                Object firstNode = valueArr.get(0);
                if (firstNode instanceof JSONObject) {
                    Bundle[] bundles = new Bundle[valueArr.length()];
                    for (i = 0; i < valueArr.length(); ++i) {
                        bundles[i] = AppLinkData.toBundle(valueArr.getJSONObject(i));
                    }
                    bundle.putParcelableArray(key, (Parcelable[])bundles);
                    continue;
                }
                if (firstNode instanceof JSONArray) {
                    throw new FacebookException("Nested arrays are not supported.");
                }
                String[] arrValues = new String[valueArr.length()];
                for (i = 0; i < valueArr.length(); ++i) {
                    arrValues[i] = valueArr.get(i).toString();
                }
                bundle.putStringArray(key, arrValues);
                continue;
            }
            bundle.putString(key, value.toString());
        }
        return bundle;
    }

    @Nullable
    private static JSONObject getAppLinkData(@Nullable Uri uri) {
        if (uri == null) {
            return null;
        }
        String data = uri.getQueryParameter(BUNDLE_AL_APPLINK_DATA_KEY);
        if (data == null) {
            return null;
        }
        try {
            return new JSONObject(data);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    private AppLinkData() {
    }

    public boolean isAutoAppLink() {
        if (null == this.targetUri) {
            return false;
        }
        String host = this.targetUri.getHost();
        String scheme = this.targetUri.getScheme();
        String expectedHost = "applinks";
        String expectedScheme = String.format("fb%s", FacebookSdk.getApplicationId());
        boolean autoFlag = this.appLinkData != null && this.appLinkData.optBoolean(AUTO_APPLINK_FLAG_KEY);
        return autoFlag && expectedHost.equals(host) && expectedScheme.equals(scheme);
    }

    @Nullable
    public Uri getTargetUri() {
        return this.targetUri;
    }

    @Nullable
    public String getRef() {
        return this.ref;
    }

    @Nullable
    public String getPromotionCode() {
        return this.promotionCode;
    }

    @Nullable
    public Bundle getArgumentBundle() {
        return this.argumentBundle;
    }

    @Nullable
    public Bundle getRefererData() {
        if (this.argumentBundle != null) {
            return this.argumentBundle.getBundle(ARGUMENTS_REFERER_DATA_KEY);
        }
        return null;
    }

    public JSONObject getAppLinkData() {
        return this.appLinkData != null ? this.appLinkData : new JSONObject();
    }

    public static interface CompletionHandler {
        public void onDeferredAppLinkDataFetched(@Nullable AppLinkData var1);
    }
}

