/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.app.Activity;
import android.content.Intent;
import android.util.Log;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookDialog;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.LoggingBehavior;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.DialogPresenter;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.util.List;

public abstract class FacebookDialogBase<CONTENT, RESULT>
implements FacebookDialog<CONTENT, RESULT> {
    private static final String TAG = "FacebookDialog";
    protected static final Object BASE_AUTOMATIC_MODE = new Object();
    private final Activity activity;
    private final FragmentWrapper fragmentWrapper;
    private List<ModeHandler> modeHandlers;
    private int requestCode;

    protected FacebookDialogBase(Activity activity, int requestCode) {
        Validate.notNull((Object)activity, (String)"activity");
        this.activity = activity;
        this.fragmentWrapper = null;
        this.requestCode = requestCode;
    }

    protected FacebookDialogBase(FragmentWrapper fragmentWrapper, int requestCode) {
        Validate.notNull((Object)fragmentWrapper, (String)"fragmentWrapper");
        this.fragmentWrapper = fragmentWrapper;
        this.activity = null;
        this.requestCode = requestCode;
        if (fragmentWrapper.getActivity() == null) {
            throw new IllegalArgumentException("Cannot use a fragment that is not attached to an activity");
        }
    }

    @Override
    public final void registerCallback(CallbackManager callbackManager, FacebookCallback<RESULT> callback) {
        if (!(callbackManager instanceof CallbackManagerImpl)) {
            throw new FacebookException("Unexpected CallbackManager, please use the provided Factory.");
        }
        this.registerCallbackImpl((CallbackManagerImpl)callbackManager, callback);
    }

    @Override
    public final void registerCallback(CallbackManager callbackManager, FacebookCallback<RESULT> callback, int requestCode) {
        this.setRequestCode(requestCode);
        this.registerCallback(callbackManager, callback);
    }

    protected abstract void registerCallbackImpl(CallbackManagerImpl var1, FacebookCallback<RESULT> var2);

    protected void setRequestCode(int requestCode) {
        if (FacebookSdk.isFacebookRequestCode((int)requestCode)) {
            throw new IllegalArgumentException("Request code " + requestCode + " cannot be within the range reserved by the Facebook SDK.");
        }
        this.requestCode = requestCode;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    @Override
    public boolean canShow(CONTENT content) {
        return this.canShowImpl(content, BASE_AUTOMATIC_MODE);
    }

    protected boolean canShowImpl(CONTENT content, Object mode) {
        boolean anyModeAllowed = mode == BASE_AUTOMATIC_MODE;
        for (ModeHandler handler : this.cachedModeHandlers()) {
            if (!anyModeAllowed && !Utility.areObjectsEqual((Object)handler.getMode(), (Object)mode) || !handler.canShow(content, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void show(CONTENT content) {
        this.showImpl(content, BASE_AUTOMATIC_MODE);
    }

    protected void showImpl(CONTENT content, Object mode) {
        AppCall appCall = this.createAppCallForMode(content, mode);
        if (appCall != null) {
            if (this.fragmentWrapper != null) {
                DialogPresenter.present(appCall, this.fragmentWrapper);
            } else {
                DialogPresenter.present(appCall, this.activity);
            }
        } else {
            String errorMessage = "No code path should ever result in a null appCall";
            Log.e((String)TAG, (String)errorMessage);
            if (FacebookSdk.isDebugEnabled()) {
                throw new IllegalStateException(errorMessage);
            }
        }
    }

    protected Activity getActivityContext() {
        if (this.activity != null) {
            return this.activity;
        }
        if (this.fragmentWrapper != null) {
            return this.fragmentWrapper.getActivity();
        }
        return null;
    }

    protected void startActivityForResult(Intent intent, int requestCode) {
        String error = null;
        if (this.activity != null) {
            this.activity.startActivityForResult(intent, requestCode);
        } else if (this.fragmentWrapper != null) {
            if (this.fragmentWrapper.getNativeFragment() != null) {
                this.fragmentWrapper.getNativeFragment().startActivityForResult(intent, requestCode);
            } else if (this.fragmentWrapper.getSupportFragment() != null) {
                this.fragmentWrapper.getSupportFragment().startActivityForResult(intent, requestCode);
            } else {
                error = "Failed to find Activity or Fragment to startActivityForResult ";
            }
        } else {
            error = "Failed to find Activity or Fragment to startActivityForResult ";
        }
        if (error != null) {
            Logger.log((LoggingBehavior)LoggingBehavior.DEVELOPER_ERRORS, (int)6, (String)this.getClass().getName(), (String)error);
        }
    }

    private AppCall createAppCallForMode(CONTENT content, Object mode) {
        boolean anyModeAllowed = mode == BASE_AUTOMATIC_MODE;
        AppCall appCall = null;
        for (ModeHandler handler : this.cachedModeHandlers()) {
            if (!anyModeAllowed && !Utility.areObjectsEqual((Object)handler.getMode(), (Object)mode) || !handler.canShow(content, true)) continue;
            try {
                appCall = handler.createAppCall(content);
                break;
            }
            catch (FacebookException e) {
                appCall = this.createBaseAppCall();
                DialogPresenter.setupAppCallForValidationError(appCall, e);
                break;
            }
        }
        if (appCall == null) {
            appCall = this.createBaseAppCall();
            DialogPresenter.setupAppCallForCannotShowError(appCall);
        }
        return appCall;
    }

    private List<ModeHandler> cachedModeHandlers() {
        if (this.modeHandlers == null) {
            this.modeHandlers = this.getOrderedModeHandlers();
        }
        return this.modeHandlers;
    }

    protected abstract List<ModeHandler> getOrderedModeHandlers();

    protected abstract AppCall createBaseAppCall();

    protected abstract class ModeHandler {
        protected ModeHandler() {
        }

        public Object getMode() {
            return BASE_AUTOMATIC_MODE;
        }

        public abstract boolean canShow(CONTENT var1, boolean var2);

        public abstract AppCall createAppCall(CONTENT var1);
    }
}

