/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.Parcel;
import android.os.Parcelable;
import com.facebook.AuthenticationTokenClaims;
import com.facebook.AuthenticationTokenHeader;
import com.facebook.AuthenticationTokenManager;
import com.facebook.internal.Validate;
import com.facebook.internal.security.OidcSecurityUtil;
import java.io.IOException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 +2\u00020\u0001:\u0001+B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0016J(\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003H\u0002J\r\u0010%\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b&J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u001aH\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011\u00a8\u0006,"}, d2={"Lcom/facebook/AuthenticationToken;", "Landroid/os/Parcelable;", "token", "", "expectedNonce", "(Ljava/lang/String;Ljava/lang/String;)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "jsonObject", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;)V", "claims", "Lcom/facebook/AuthenticationTokenClaims;", "getClaims", "()Lcom/facebook/AuthenticationTokenClaims;", "getExpectedNonce", "()Ljava/lang/String;", "header", "Lcom/facebook/AuthenticationTokenHeader;", "getHeader", "()Lcom/facebook/AuthenticationTokenHeader;", "signature", "getSignature", "getToken", "describeContents", "", "equals", "", "other", "", "hashCode", "isValidSignature", "headerString", "claimsString", "sigString", "kid", "toJSONObject", "toJSONObject$facebook_core_release", "writeToParcel", "", "dest", "flags", "Companion", "facebook-core_release"})
@SourceDebugExtension(value={"SMAP\nAuthenticationToken.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthenticationToken.kt\ncom/facebook/AuthenticationToken\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
public final class AuthenticationToken
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String token;
    @NotNull
    private final String expectedNonce;
    @NotNull
    private final AuthenticationTokenHeader header;
    @NotNull
    private final AuthenticationTokenClaims claims;
    @NotNull
    private final String signature;
    @NotNull
    public static final String AUTHENTICATION_TOKEN_KEY = "id_token";
    @NotNull
    private static final String TOKEN_STRING_KEY = "token_string";
    @NotNull
    private static final String EXPECTED_NONCE_KEY = "expected_nonce";
    @NotNull
    private static final String HEADER_KEY = "header";
    @NotNull
    private static final String CLAIMS_KEY = "claims";
    @NotNull
    private static final String SIGNATURE_KEY = "signature";
    @JvmField
    @NotNull
    public static final Parcelable.Creator<AuthenticationToken> CREATOR = (Parcelable.Creator)new Parcelable.Creator<AuthenticationToken>(){

        @NotNull
        public AuthenticationToken createFromParcel(@NotNull Parcel source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new AuthenticationToken(source);
        }

        @NotNull
        public AuthenticationToken[] newArray(int size) {
            return new AuthenticationToken[size];
        }
    };

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @NotNull
    public final String getExpectedNonce() {
        return this.expectedNonce;
    }

    @NotNull
    public final AuthenticationTokenHeader getHeader() {
        return this.header;
    }

    @NotNull
    public final AuthenticationTokenClaims getClaims() {
        return this.claims;
    }

    @NotNull
    public final String getSignature() {
        return this.signature;
    }

    @JvmOverloads
    public AuthenticationToken(@NotNull String token, @NotNull String expectedNonce) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)expectedNonce, (String)"expectedNonce");
        Validate.notEmpty(token, "token");
        Validate.notEmpty(expectedNonce, "expectedNonce");
        String[] stringArray = new String[]{"."};
        List tokenArray = StringsKt.split$default((CharSequence)token, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (!(tokenArray.size() == 3)) {
            boolean $i$a$-require-AuthenticationToken$32 = false;
            String $i$a$-require-AuthenticationToken$32 = "Invalid IdToken string";
            throw new IllegalArgumentException($i$a$-require-AuthenticationToken$32.toString());
        }
        String rawHeader = (String)tokenArray.get(0);
        String rawClaims = (String)tokenArray.get(1);
        String rawSignature = (String)tokenArray.get(2);
        this.token = token;
        this.expectedNonce = expectedNonce;
        this.header = new AuthenticationTokenHeader(rawHeader);
        this.claims = new AuthenticationTokenClaims(rawClaims, expectedNonce);
        if (!this.isValidSignature(rawHeader, rawClaims, rawSignature, this.header.getKid())) {
            boolean bl = false;
            String string = "Invalid Signature";
            throw new IllegalArgumentException(string.toString());
        }
        this.signature = rawSignature;
    }

    public AuthenticationToken(@NotNull Parcel parcel) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        String token = parcel.readString();
        this.token = Validate.notNullOrEmpty(token, "token");
        String expectedNonce = parcel.readString();
        this.expectedNonce = Validate.notNullOrEmpty(expectedNonce, "expectedNonce");
        Parcelable parcelable = parcel.readParcelable(AuthenticationTokenHeader.class.getClassLoader());
        if (parcelable == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        this.header = (AuthenticationTokenHeader)parcelable;
        Parcelable parcelable2 = parcel.readParcelable(AuthenticationTokenClaims.class.getClassLoader());
        if (parcelable2 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        this.claims = (AuthenticationTokenClaims)parcelable2;
        String signature = parcel.readString();
        this.signature = Validate.notNullOrEmpty(signature, SIGNATURE_KEY);
    }

    public AuthenticationToken(@NotNull JSONObject jsonObject) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        String string = jsonObject.getString(TOKEN_STRING_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.getString(TOKEN_STRING_KEY)");
        this.token = string;
        String string2 = jsonObject.getString(EXPECTED_NONCE_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonObject.getString(EXPECTED_NONCE_KEY)");
        this.expectedNonce = string2;
        String string3 = jsonObject.getString(SIGNATURE_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jsonObject.getString(SIGNATURE_KEY)");
        this.signature = string3;
        JSONObject headerJSONObject = jsonObject.getJSONObject(HEADER_KEY);
        JSONObject claimsJSONObject = jsonObject.getJSONObject(CLAIMS_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)headerJSONObject, (String)"headerJSONObject");
        this.header = new AuthenticationTokenHeader(headerJSONObject);
        Intrinsics.checkNotNullExpressionValue((Object)claimsJSONObject, (String)"claimsJSONObject");
        this.claims = AuthenticationTokenClaims.Companion.createFromJSONObject$facebook_core_release(claimsJSONObject);
    }

    @NotNull
    public final JSONObject toJSONObject$facebook_core_release() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(TOKEN_STRING_KEY, (Object)this.token);
        jsonObject.put(EXPECTED_NONCE_KEY, (Object)this.expectedNonce);
        jsonObject.put(HEADER_KEY, (Object)this.header.toJSONObject$facebook_core_release());
        jsonObject.put(CLAIMS_KEY, (Object)this.claims.toJSONObject$facebook_core_release());
        jsonObject.put(SIGNATURE_KEY, (Object)this.signature);
        return jsonObject;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AuthenticationToken)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.token, (Object)((AuthenticationToken)other).token) && Intrinsics.areEqual((Object)this.expectedNonce, (Object)((AuthenticationToken)other).expectedNonce) && Intrinsics.areEqual((Object)this.header, (Object)((AuthenticationToken)other).header) && Intrinsics.areEqual((Object)this.claims, (Object)((AuthenticationToken)other).claims) && Intrinsics.areEqual((Object)this.signature, (Object)((AuthenticationToken)other).signature);
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.token.hashCode();
        result = result * 31 + this.expectedNonce.hashCode();
        result = result * 31 + this.header.hashCode();
        result = result * 31 + this.claims.hashCode();
        result = result * 31 + this.signature.hashCode();
        return result;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeString(this.token);
        dest.writeString(this.expectedNonce);
        dest.writeParcelable((Parcelable)this.header, flags);
        dest.writeParcelable((Parcelable)this.claims, flags);
        dest.writeString(this.signature);
    }

    public int describeContents() {
        return 0;
    }

    private final boolean isValidSignature(String headerString, String claimsString, String sigString, String kid) {
        try {
            String string = OidcSecurityUtil.getRawKeyFromEndPoint(kid);
            if (string == null) {
                return false;
            }
            String pubKeyString = string;
            PublicKey pubKey = OidcSecurityUtil.getPublicKeyFromString(pubKeyString);
            return OidcSecurityUtil.verify(pubKey, headerString + '.' + claimsString, sigString);
        }
        catch (InvalidKeySpecException ex) {
            return false;
        }
        catch (IOException _ex) {
            return false;
        }
    }

    @JvmStatic
    @Nullable
    public static final AuthenticationToken getCurrentAuthenticationToken() {
        return Companion.getCurrentAuthenticationToken();
    }

    @JvmStatic
    public static final void setCurrentAuthenticationToken(@Nullable AuthenticationToken authenticationToken) {
        Companion.setCurrentAuthenticationToken(authenticationToken);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\r\u001a\u0004\u0018\u00010\bH\u0007J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/AuthenticationToken$Companion;", "", "()V", "AUTHENTICATION_TOKEN_KEY", "", "CLAIMS_KEY", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/facebook/AuthenticationToken;", "EXPECTED_NONCE_KEY", "HEADER_KEY", "SIGNATURE_KEY", "TOKEN_STRING_KEY", "getCurrentAuthenticationToken", "setCurrentAuthenticationToken", "", "authenticationToken", "facebook-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final AuthenticationToken getCurrentAuthenticationToken() {
            return AuthenticationTokenManager.Companion.getInstance().getCurrentAuthenticationToken();
        }

        @JvmStatic
        public final void setCurrentAuthenticationToken(@Nullable AuthenticationToken authenticationToken) {
            AuthenticationTokenManager.Companion.getInstance().setCurrentAuthenticationToken(authenticationToken);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

